package quic

import (
	"net"
	"time"

	"github.com/mzz2017/quic-go/internal/protocol"

	. "github.com/onsi/ginkgo/v2"
	. "github.com/onsi/gomega"
	"go.uber.org/mock/gomock"
)

var _ = Describe("Basic Conn Test", func() {
	It("reads a packet", func() {
		c := NewMockPacketConn(mockCtrl)
		addr := &net.UDPAddr{IP: net.IPv4(1, 2, 3, 4), Port: 1234}
		c.EXPECT().ReadFrom(gomock.Any()).DoAndReturn(func(b []byte) (int, net.Addr, error) {
			data := []byte("foobar")
			Expect(b).To(HaveLen(protocol.MaxPacketBufferSize))
			return copy(b, data), addr, nil
		})

		conn, err := wrapConn(c)
		Expect(err).ToNot(HaveOccurred())
		p, err := conn.ReadPacket()
		Expect(err).ToNot(HaveOccurred())
		Expect(p.data).To(Equal([]byte("foobar")))
		Expect(p.rcvTime).To(BeTemporally("~", time.Now(), scaleDuration(100*time.Millisecond)))
		Expect(p.remoteAddr).To(Equal(addr))
	})
})
