/*******************************************
* Copyright (C) 2021 Intel Corporation
* SPDX-License-Identifier: BSD-3-Clause
*******************************************/

/*
 * ALGORITHM DESCRIPTION:
 * 
 *     ( low accuracy ( < 4ulp ) or enhanced performance ( half of correct mantissa ) implementation )
 * 
 *     Argument representation:
 *     arg = N*Pi + R
 * 
 *     Result calculation:
 *     sin(arg) = sin(N*Pi + R) = (-1)^N * sin(R)
 *     sin(R) is approximated by corresponding polynomial
 * 
 */


	.text
.L_2__routine_start___svml_sin8_z0_0:

	.align    16,0x90
	.globl __svml_sin8

__svml_sin8:


	.cfi_startproc
..L2:

        pushq     %rbp
	.cfi_def_cfa_offset 16
        movq      %rsp, %rbp
	.cfi_def_cfa 6, 16
	.cfi_offset 6, -16
        andq      $-64, %rsp
        subq      $192, %rsp
        xorl      %edx, %edx

/* start arg. reduction */
        vmovups   128+__svml_dsin_data_internal(%rip), %zmm3
        vmovups   192+__svml_dsin_data_internal(%rip), %zmm9
        vmovups   640+__svml_dsin_data_internal(%rip), %zmm7
        vmovups   704+__svml_dsin_data_internal(%rip), %zmm5
        vmovups   1216+__svml_dsin_data_internal(%rip), %zmm8
        vmovups   1088+__svml_dsin_data_internal(%rip), %zmm10
        vmovups   1024+__svml_dsin_data_internal(%rip), %zmm11
        vmovups   768+__svml_dsin_data_internal(%rip), %zmm6
        vmovups   960+__svml_dsin_data_internal(%rip), %zmm12
        vmovups   320+__svml_dsin_data_internal(%rip), %zmm4
        vmovups   896+__svml_dsin_data_internal(%rip), %zmm13
        vmovups   64+__svml_dsin_data_internal(%rip), %zmm14
        vmovaps   %zmm0, %zmm2
        vfmadd213pd {rn-sae}, %zmm9, %zmm2, %zmm3
        vcmppd    $0, {sae}, %zmm4, %zmm2, %k1
        vpsllq    $63, %zmm3, %zmm0

/* dN */
        vsubpd    {rn-sae}, %zmm9, %zmm3, %zmm1
        vandpd    __svml_dsin_data_internal(%rip), %zmm2, %zmm9
        vxorpd    %zmm2, %zmm0, %zmm0{%k1}
        vfnmadd213pd {rn-sae}, %zmm2, %zmm1, %zmm7
        vmovups   1152+__svml_dsin_data_internal(%rip), %zmm3
        vcmppd    $22, {sae}, %zmm14, %zmm9, %k1
        vfnmadd231pd {rn-sae}, %zmm1, %zmm5, %zmm7

/* will branch if long arg. reduction needed */
        kortestw  %k1, %k1
        vmulpd    {rn-sae}, %zmm7, %zmm7, %zmm15
        vfnmadd213pd {rn-sae}, %zmm7, %zmm6, %zmm1
        vfmadd231pd {rn-sae}, %zmm15, %zmm8, %zmm3
        vmulpd    {rn-sae}, %zmm1, %zmm15, %zmm8
        vfmadd213pd {rn-sae}, %zmm10, %zmm15, %zmm3
        vfmadd213pd {rn-sae}, %zmm11, %zmm15, %zmm3
        vfmadd213pd {rn-sae}, %zmm12, %zmm15, %zmm3
        vfmadd213pd {rn-sae}, %zmm13, %zmm15, %zmm3

/* mask will be used to decide whether long arg. reduction is needed */
        vmovups   832+__svml_dsin_data_internal(%rip), %zmm13
        vfmadd213pd {rn-sae}, %zmm13, %zmm15, %zmm3
        vfmadd213pd {rn-sae}, %zmm1, %zmm8, %zmm3
        vxorpd    %zmm0, %zmm3, %zmm0
        jne       .LBL_1_12

.LBL_1_2:

        testl     %edx, %edx
        jne       .LBL_1_4

.LBL_1_3:


/* no invcbrt in libm, so taking it out here */
        movq      %rbp, %rsp
        popq      %rbp
	.cfi_def_cfa 7, 8
	.cfi_restore 6
        ret
	.cfi_def_cfa 6, 16
	.cfi_offset 6, -16

.LBL_1_4:

        vmovups   %zmm2, 64(%rsp)
        vmovups   %zmm0, 128(%rsp)
        je        .LBL_1_3


        xorl      %eax, %eax


        vzeroupper
        kmovw     %k4, 24(%rsp)
        kmovw     %k5, 16(%rsp)
        kmovw     %k6, 8(%rsp)
        kmovw     %k7, (%rsp)
        movq      %rsi, 40(%rsp)
        movq      %rdi, 32(%rsp)
        movq      %r12, 56(%rsp)
	.cfi_escape 0x10, 0x04, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x68, 0xff, 0xff, 0xff, 0x22
	.cfi_escape 0x10, 0x05, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x60, 0xff, 0xff, 0xff, 0x22
	.cfi_escape 0x10, 0x0c, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x78, 0xff, 0xff, 0xff, 0x22
        movl      %eax, %r12d
        movq      %r13, 48(%rsp)
	.cfi_escape 0x10, 0x0d, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x70, 0xff, 0xff, 0xff, 0x22
        movl      %edx, %r13d
	.cfi_escape 0x10, 0xfa, 0x00, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x58, 0xff, 0xff, 0xff, 0x22
	.cfi_escape 0x10, 0xfb, 0x00, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x50, 0xff, 0xff, 0xff, 0x22
	.cfi_escape 0x10, 0xfc, 0x00, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x48, 0xff, 0xff, 0xff, 0x22
	.cfi_escape 0x10, 0xfd, 0x00, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x40, 0xff, 0xff, 0xff, 0x22

.LBL_1_8:

        btl       %r12d, %r13d
        jc        .LBL_1_11

.LBL_1_9:

        incl      %r12d
        cmpl      $8, %r12d
        jl        .LBL_1_8


        kmovw     24(%rsp), %k4
	.cfi_restore 122
        kmovw     16(%rsp), %k5
	.cfi_restore 123
        kmovw     8(%rsp), %k6
	.cfi_restore 124
        kmovw     (%rsp), %k7
	.cfi_restore 125
        vmovups   128(%rsp), %zmm0
        movq      40(%rsp), %rsi
	.cfi_restore 4
        movq      32(%rsp), %rdi
	.cfi_restore 5
        movq      56(%rsp), %r12
	.cfi_restore 12
        movq      48(%rsp), %r13
	.cfi_restore 13
        jmp       .LBL_1_3
	.cfi_escape 0x10, 0x04, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x68, 0xff, 0xff, 0xff, 0x22
	.cfi_escape 0x10, 0x05, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x60, 0xff, 0xff, 0xff, 0x22
	.cfi_escape 0x10, 0x0c, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x78, 0xff, 0xff, 0xff, 0x22
	.cfi_escape 0x10, 0x0d, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x70, 0xff, 0xff, 0xff, 0x22
	.cfi_escape 0x10, 0xfa, 0x00, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x58, 0xff, 0xff, 0xff, 0x22
	.cfi_escape 0x10, 0xfb, 0x00, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x50, 0xff, 0xff, 0xff, 0x22
	.cfi_escape 0x10, 0xfc, 0x00, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x48, 0xff, 0xff, 0xff, 0x22
	.cfi_escape 0x10, 0xfd, 0x00, 0x0e, 0x38, 0x1c, 0x0d, 0xc0, 0xff, 0xff, 0xff, 0x1a, 0x0d, 0x40, 0xff, 0xff, 0xff, 0x22

.LBL_1_11:

        lea       64(%rsp,%r12,8), %rdi
        lea       128(%rsp,%r12,8), %rsi

        call      __svml_dsin_cout_rare_internal
        jmp       .LBL_1_9
	.cfi_restore 4
	.cfi_restore 5
	.cfi_restore 12
	.cfi_restore 13
	.cfi_restore 122
	.cfi_restore 123
	.cfi_restore 124
	.cfi_restore 125

.LBL_1_12:


/* ............Check for Inf and NaNs................. */
        vmovups   16512+__svml_dsin_data_internal_ha(%rip), %zmm1

/*
 * Get the (2^a / 2pi) mod 1 values from the table.
 * Because VLANG doesn't have L-type gather, we need a trivial cast
 */
        lea       __svml_dsin_reduction_data_internal(%rip), %rax
        vmovups   %zmm2, 64(%rsp)
        vmovups   %zmm0, (%rsp)
        vandpd    %zmm9, %zmm1, %zmm6
        vxorpd    %zmm2, %zmm9, %zmm8
        vpbroadcastq .L_2il0floatpacket.26(%rip), %zmm11
        vcmppd    $4, {sae}, %zmm1, %zmm6, %k2
        vmovups   %zmm8, 128(%rsp)
        vmovaps   %zmm11, %zmm5

/*
 * The output is _VRES_Z (high) + _VRES_E (low), and the integer part is _VRES_IND
 * Now resume the original code.
 * ..................... Table look-up ........................
 */
        lea       __svml_dsin_data_internal_ha(%rip), %rcx
        vpandq    .L_2il0floatpacket.27(%rip){1to8}, %zmm9, %zmm4
        vpandnq   %zmm6, %zmm6, %zmm5{%k2}
        vpsrlq    $52, %zmm4, %zmm3
        vcmppd    $3, {sae}, %zmm5, %zmm5, %k0
        vpsllq    $1, %zmm3, %zmm15

/*
 * Break the P_xxx and m into 32-bit chunks ready for
 * the long multiplication via 32x32->64 multiplications
 */
        vpbroadcastq .L_2il0floatpacket.30(%rip), %zmm6
        kxnorw    %k0, %k0, %k3
        kxnorw    %k0, %k0, %k2
        kmovw     %k0, %edx
        vpaddq    %zmm3, %zmm15, %zmm2
        vpsllq    $3, %zmm2, %zmm14
        vpmovqd   %zmm14, %ymm12
        vpxord    %zmm1, %zmm1, %zmm1
        vgatherdpd (%rax,%ymm12), %zmm1{%k3}
        kxnorw    %k0, %k0, %k3
        vpsrlq    $32, %zmm1, %zmm7
        vpxord    %zmm5, %zmm5, %zmm5
        vpxord    %zmm4, %zmm4, %zmm4
        vgatherdpd 8(%rax,%ymm12), %zmm5{%k2}
        vgatherdpd 16(%rax,%ymm12), %zmm4{%k3}
        vpsrlq    $32, %zmm5, %zmm10
        vpsrlq    $32, %zmm4, %zmm13

/*
 * Also get the significand as an integer
 * NB: adding in the integer bit is wrong for denorms!
 * To make this work for denorms we should do something slightly different
 */
        vpandq    .L_2il0floatpacket.28(%rip){1to8}, %zmm9, %zmm8
        vpaddq    .L_2il0floatpacket.29(%rip){1to8}, %zmm8, %zmm15
        vpsrlq    $32, %zmm15, %zmm8
        vpmullq   %zmm10, %zmm8, %zmm3
        vpandq    %zmm6, %zmm1, %zmm0
        vpandq    %zmm6, %zmm5, %zmm12
        vpandq    %zmm6, %zmm4, %zmm5
        vpandq    %zmm6, %zmm15, %zmm14

/* Now do the big multiplication and carry propagation */
        vpmullq   %zmm0, %zmm8, %zmm4
        vpmullq   %zmm12, %zmm8, %zmm2
        vpmullq   %zmm13, %zmm8, %zmm1
        vpmullq   %zmm5, %zmm8, %zmm8
        vpmullq   %zmm0, %zmm14, %zmm5
        vpmullq   %zmm12, %zmm14, %zmm0
        vpmullq   %zmm13, %zmm14, %zmm13
        vpmullq   %zmm7, %zmm14, %zmm7
        vpmullq   %zmm10, %zmm14, %zmm10
        vpsrlq    $32, %zmm13, %zmm14
        vpsrlq    $32, %zmm0, %zmm13
        vpsrlq    $32, %zmm5, %zmm12
        vpsrlq    $32, %zmm10, %zmm15
        vpaddq    %zmm14, %zmm1, %zmm1
        vpaddq    %zmm13, %zmm2, %zmm14
        vpaddq    %zmm12, %zmm4, %zmm2
        vpaddq    %zmm15, %zmm3, %zmm13
        vpandq    %zmm6, %zmm7, %zmm7
        vpaddq    %zmm2, %zmm7, %zmm4
        vpsrlq    $32, %zmm8, %zmm2
        vpandq    %zmm6, %zmm0, %zmm0
        vpaddq    %zmm1, %zmm0, %zmm1
        vpaddq    %zmm1, %zmm2, %zmm15
        vpsrlq    $32, %zmm15, %zmm8
        vpandq    %zmm6, %zmm10, %zmm10
        vpaddq    %zmm14, %zmm10, %zmm0
        vpaddq    %zmm0, %zmm8, %zmm12

/*
 * Now round at the 2^-9 bit position for reduction mod pi/2^8
 * instead of the original 2pi (but still with the same 2pi scaling).
 * Use a shifter of 2^43 + 2^42.
 * The N we get is our final version; it has an offset of
 * 2^9 because of the implicit integer bit, and anyway for negative
 * starting value it's a 2s complement thing. But we need to mask
 * off the exponent part anyway so it's fine.
 */
        vpbroadcastq .L_2il0floatpacket.33(%rip), %zmm0
        vpsrlq    $32, %zmm12, %zmm7
        vpandq    %zmm6, %zmm5, %zmm3
        vpaddq    %zmm13, %zmm3, %zmm5
        vpaddq    %zmm5, %zmm7, %zmm3
        vpsllq    $32, %zmm12, %zmm7
        vpsrlq    $32, %zmm3, %zmm10
        vpaddq    %zmm4, %zmm10, %zmm2

/* Assemble reduced argument from the pieces */
        vpandq    %zmm6, %zmm15, %zmm13
        vpandq    %zmm6, %zmm3, %zmm8
        vpsllq    $32, %zmm2, %zmm6
        vpaddq    %zmm13, %zmm7, %zmm4

/*
 * If the magnitude of the input is <= 2^-20, then
 * just pass through the input, since no reduction will be needed and
 * the main path will only work accurately if the reduced argument is
 * about >= 2^-70 (which it is for all large pi multiples)
 */
        vpbroadcastq .L_2il0floatpacket.42(%rip), %zmm13
        vpaddq    %zmm8, %zmm6, %zmm15
        vpsrlq    $12, %zmm15, %zmm1

/*
 * We want to incorporate the original sign now too.
 * Do it here for convenience in getting the right N value,
 * though we could wait right to the end if we were prepared
 * to modify the sign of N later too.
 * So get the appropriate sign mask now (or sooner).
 */
        vpandq    .L_2il0floatpacket.31(%rip){1to8}, %zmm9, %zmm3

/*
 * Create floating-point high part, implicitly adding integer bit 1
 * Incorporate overall sign at this stage too.
 */
        vpxorq    .L_2il0floatpacket.32(%rip){1to8}, %zmm3, %zmm6
        vporq     %zmm6, %zmm1, %zmm5
        vaddpd    {rn-sae}, %zmm5, %zmm0, %zmm2
        vsubpd    {rn-sae}, %zmm0, %zmm2, %zmm10
        vsubpd    {rn-sae}, %zmm10, %zmm5, %zmm10
        vpandq    .L_2il0floatpacket.36(%rip){1to8}, %zmm4, %zmm12
        vpsllq    $28, %zmm12, %zmm14
        vpsrlq    $24, %zmm4, %zmm4
        vpandq    .L_2il0floatpacket.38(%rip){1to8}, %zmm15, %zmm15

/*
 * Create floating-point low and medium parts, respectively
 * lo_23, ... lo_0, 0, ..., 0
 * hi_11, ... hi_0, lo_63, ..., lo_24
 * then subtract off the implicitly added integer bits,
 * 2^-104 and 2^-52, respectively.
 * Put the original sign into all of them at this stage.
 */
        vpxorq    .L_2il0floatpacket.35(%rip){1to8}, %zmm3, %zmm7
        vpxorq    .L_2il0floatpacket.37(%rip){1to8}, %zmm3, %zmm1
        vpsllq    $40, %zmm15, %zmm3
        vporq     %zmm7, %zmm14, %zmm8
        vsubpd    {rn-sae}, %zmm7, %zmm8, %zmm5
        vandpd    .L_2il0floatpacket.41(%rip){1to8}, %zmm9, %zmm14
        vcmppd    $22, {sae}, %zmm13, %zmm14, %k3
        vcmppd    $26, {sae}, %zmm13, %zmm14, %k2
        vporq     %zmm4, %zmm3, %zmm8
        vporq     %zmm1, %zmm8, %zmm7
        vsubpd    {rn-sae}, %zmm1, %zmm7, %zmm6

/*
 * Now multiply those numbers all by 2 pi, reasonably accurately.
 * (RHi + RLo) * (pi_lead + pi_trail) ~=
 * RHi * pi_lead + (RHi * pi_trail + RLo * pi_lead)
 */
        vpbroadcastq .L_2il0floatpacket.39(%rip), %zmm4

/* Now add them up into 2 reasonably aligned pieces */
        vaddpd    {rn-sae}, %zmm6, %zmm10, %zmm12
        vmulpd    {rn-sae}, %zmm4, %zmm12, %zmm15
        vsubpd    {rn-sae}, %zmm12, %zmm10, %zmm10
        vmovaps   %zmm4, %zmm3
        vfmsub213pd {rn-sae}, %zmm15, %zmm12, %zmm3
        vmovaps   %zmm11, %zmm1

/* Grab our final N value as an integer, appropriately masked mod 2^9 */
        vpandq    .L_2il0floatpacket.34(%rip){1to8}, %zmm2, %zmm0
        vaddpd    {rn-sae}, %zmm10, %zmm6, %zmm2
        vaddpd    {rn-sae}, %zmm5, %zmm2, %zmm6
        vpbroadcastq .L_2il0floatpacket.40(%rip), %zmm5
        vfmadd213pd {rn-sae}, %zmm3, %zmm5, %zmm12
        vfmadd213pd {rn-sae}, %zmm12, %zmm4, %zmm6
        vmovups   16960+__svml_dsin_data_internal_ha(%rip), %zmm4
        vpandnq   %zmm14, %zmm14, %zmm11{%k3}
        vandpd    %zmm9, %zmm11, %zmm9
        vpsllq    $5, %zmm0, %zmm11
        kxnorw    %k0, %k0, %k3
        vpandnq   %zmm14, %zmm14, %zmm1{%k2}
        vandpd    %zmm15, %zmm1, %zmm8
        vandpd    %zmm6, %zmm1, %zmm1
        vpmovqd   %zmm11, %ymm6
        vorpd     %zmm8, %zmm9, %zmm7
        vmovups   17216+__svml_dsin_data_internal_ha(%rip), %zmm14
        vmovups   17088+__svml_dsin_data_internal_ha(%rip), %zmm15

/* ............... Polynomial approximation ................... */
        vmulpd    {rn-sae}, %zmm7, %zmm7, %zmm9
        kxnorw    %k0, %k0, %k2

/* ................. Reconstruction: res_hi ................... */
        vmovaps   %zmm7, %zmm0
        vmovaps   %zmm7, %zmm8
        vpxord    %zmm10, %zmm10, %zmm10
        vgatherdpd (%rcx,%ymm6), %zmm10{%k2}
        kxnorw    %k0, %k0, %k2
        vpxord    %zmm12, %zmm12, %zmm12
        vpxord    %zmm11, %zmm11, %zmm11
        vgatherdpd 8(%rcx,%ymm6), %zmm12{%k3}
        vgatherdpd 16(%rcx,%ymm6), %zmm11{%k2}
        kxnorw    %k0, %k0, %k3
        vfmadd213pd {rn-sae}, %zmm11, %zmm12, %zmm0
        vfmadd132pd {rn-sae}, %zmm10, %zmm0, %zmm8

/* ................. Reconstruction: res_lo ................... */
        vsubpd    {rn-sae}, %zmm0, %zmm11, %zmm3
        vsubpd    {rn-sae}, %zmm8, %zmm0, %zmm2
        vmovups   17024+__svml_dsin_data_internal_ha(%rip), %zmm0
        vfmadd231pd {rn-sae}, %zmm7, %zmm12, %zmm3
        vfmadd231pd {rn-sae}, %zmm10, %zmm7, %zmm2
        vfmadd231pd {rn-sae}, %zmm9, %zmm0, %zmm4
        vaddpd    {rn-sae}, %zmm3, %zmm2, %zmm13
        vaddpd    {rn-sae}, %zmm12, %zmm10, %zmm2
        vmulpd    {rn-sae}, %zmm9, %zmm4, %zmm5
        vmulpd    {rn-sae}, %zmm7, %zmm5, %zmm0

/* ................. Reconstruction: res_lo+corr ................... */
        vfnmadd213pd {rn-sae}, %zmm2, %zmm11, %zmm7
        vfmadd213pd {rn-sae}, %zmm13, %zmm2, %zmm0
        vmovups   17152+__svml_dsin_data_internal_ha(%rip), %zmm13
        vmovups   64(%rsp), %zmm2
        vfmadd231pd {rn-sae}, %zmm9, %zmm14, %zmm13
        vfmadd213pd {rn-sae}, %zmm15, %zmm9, %zmm13
        vmulpd    {rn-sae}, %zmm9, %zmm13, %zmm3
        vfmadd213pd {rn-sae}, %zmm0, %zmm11, %zmm3
        vmovups   (%rsp), %zmm0
        vpxord    %zmm11, %zmm11, %zmm11
        vgatherdpd 24(%rcx,%ymm6), %zmm11{%k3}
        vfmadd213pd {rn-sae}, %zmm11, %zmm7, %zmm1
        vaddpd    {rn-sae}, %zmm1, %zmm3, %zmm7

/* .................. Final reconstruction ................... */
        vaddpd    {rn-sae}, %zmm7, %zmm8, %zmm9
        vxorpd    128(%rsp), %zmm9, %zmm0{%k1}
        jmp       .LBL_1_2
	.align    16,0x90

	.cfi_endproc

	.type	__svml_sin8,@function
	.size	__svml_sin8,.-__svml_sin8
..LN__svml_sin8.0:

.L_2__routine_start___svml_dsin_cout_rare_internal_1:

	.align    16,0x90

__svml_dsin_cout_rare_internal:


	.cfi_startproc
..L67:

        movzwl    6(%rdi), %eax
        andl      $32752, %eax
        movsd     (%rdi), %xmm1
        movb      7(%rdi), %dl
        andb      $127, %dl
        movsd     %xmm1, -8(%rsp)
        cmpl      $32752, %eax
        jne       .LBL_2_6


        cmpl      $0, -8(%rsp)
        jne       .LBL_2_5


        movb      %dl, -1(%rsp)
        cmpl      $2146435072, -4(%rsp)
        jne       .LBL_2_5


        movsd     __dsin_la_CoutTab(%rip), %xmm0
        movl      $1, %eax
        mulsd     %xmm0, %xmm1
        movsd     %xmm1, (%rsi)
        ret

.LBL_2_5:

        mulsd     %xmm1, %xmm1
        xorl      %eax, %eax
        movsd     %xmm1, (%rsi)
        ret

.LBL_2_6:

        xorl      %eax, %eax
        ret
	.align    16,0x90

	.cfi_endproc

	.type	__svml_dsin_cout_rare_internal,@function
	.size	__svml_dsin_cout_rare_internal,.-__svml_dsin_cout_rare_internal
..LN__svml_dsin_cout_rare_internal.1:

	.section .rodata, "a"
	.align 64
	.align 64
__svml_dsin_data_internal:
	.long	4294967295
	.long	2147483647
	.long	4294967295
	.long	2147483647
	.long	4294967295
	.long	2147483647
	.long	4294967295
	.long	2147483647
	.long	4294967295
	.long	2147483647
	.long	4294967295
	.long	2147483647
	.long	4294967295
	.long	2147483647
	.long	4294967295
	.long	2147483647
	.long	0
	.long	1097859072
	.long	0
	.long	1097859072
	.long	0
	.long	1097859072
	.long	0
	.long	1097859072
	.long	0
	.long	1097859072
	.long	0
	.long	1097859072
	.long	0
	.long	1097859072
	.long	0
	.long	1097859072
	.long	1841940611
	.long	1070882608
	.long	1841940611
	.long	1070882608
	.long	1841940611
	.long	1070882608
	.long	1841940611
	.long	1070882608
	.long	1841940611
	.long	1070882608
	.long	1841940611
	.long	1070882608
	.long	1841940611
	.long	1070882608
	.long	1841940611
	.long	1070882608
	.long	0
	.long	1127743488
	.long	0
	.long	1127743488
	.long	0
	.long	1127743488
	.long	0
	.long	1127743488
	.long	0
	.long	1127743488
	.long	0
	.long	1127743488
	.long	0
	.long	1127743488
	.long	0
	.long	1127743488
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	2147483648
	.long	0
	.long	2147483648
	.long	0
	.long	2147483648
	.long	0
	.long	2147483648
	.long	0
	.long	2147483648
	.long	0
	.long	2147483648
	.long	0
	.long	2147483648
	.long	0
	.long	2147483648
	.long	1073741824
	.long	1074340347
	.long	1073741824
	.long	1074340347
	.long	1073741824
	.long	1074340347
	.long	1073741824
	.long	1074340347
	.long	1073741824
	.long	1074340347
	.long	1073741824
	.long	1074340347
	.long	1073741824
	.long	1074340347
	.long	1073741824
	.long	1074340347
	.long	0
	.long	1048855597
	.long	0
	.long	1048855597
	.long	0
	.long	1048855597
	.long	0
	.long	1048855597
	.long	0
	.long	1048855597
	.long	0
	.long	1048855597
	.long	0
	.long	1048855597
	.long	0
	.long	1048855597
	.long	2147483648
	.long	1023952536
	.long	2147483648
	.long	1023952536
	.long	2147483648
	.long	1023952536
	.long	2147483648
	.long	1023952536
	.long	2147483648
	.long	1023952536
	.long	2147483648
	.long	1023952536
	.long	2147483648
	.long	1023952536
	.long	2147483648
	.long	1023952536
	.long	1880851354
	.long	998820945
	.long	1880851354
	.long	998820945
	.long	1880851354
	.long	998820945
	.long	1880851354
	.long	998820945
	.long	1880851354
	.long	998820945
	.long	1880851354
	.long	998820945
	.long	1880851354
	.long	998820945
	.long	1880851354
	.long	998820945
	.long	1413754136
	.long	1074340347
	.long	1413754136
	.long	1074340347
	.long	1413754136
	.long	1074340347
	.long	1413754136
	.long	1074340347
	.long	1413754136
	.long	1074340347
	.long	1413754136
	.long	1074340347
	.long	1413754136
	.long	1074340347
	.long	1413754136
	.long	1074340347
	.long	856972294
	.long	1017226790
	.long	856972294
	.long	1017226790
	.long	856972294
	.long	1017226790
	.long	856972294
	.long	1017226790
	.long	856972294
	.long	1017226790
	.long	856972294
	.long	1017226790
	.long	856972294
	.long	1017226790
	.long	856972294
	.long	1017226790
	.long	688016905
	.long	962338001
	.long	688016905
	.long	962338001
	.long	688016905
	.long	962338001
	.long	688016905
	.long	962338001
	.long	688016905
	.long	962338001
	.long	688016905
	.long	962338001
	.long	688016905
	.long	962338001
	.long	688016905
	.long	962338001
	.long	1431655592
	.long	3217380693
	.long	1431655592
	.long	3217380693
	.long	1431655592
	.long	3217380693
	.long	1431655592
	.long	3217380693
	.long	1431655592
	.long	3217380693
	.long	1431655592
	.long	3217380693
	.long	1431655592
	.long	3217380693
	.long	1431655592
	.long	3217380693
	.long	286303603
	.long	1065423121
	.long	286303603
	.long	1065423121
	.long	286303603
	.long	1065423121
	.long	286303603
	.long	1065423121
	.long	286303603
	.long	1065423121
	.long	286303603
	.long	1065423121
	.long	286303603
	.long	1065423121
	.long	286303603
	.long	1065423121
	.long	430332381
	.long	3207201184
	.long	430332381
	.long	3207201184
	.long	430332381
	.long	3207201184
	.long	430332381
	.long	3207201184
	.long	430332381
	.long	3207201184
	.long	430332381
	.long	3207201184
	.long	430332381
	.long	3207201184
	.long	430332381
	.long	3207201184
	.long	2154487066
	.long	1053236707
	.long	2154487066
	.long	1053236707
	.long	2154487066
	.long	1053236707
	.long	2154487066
	.long	1053236707
	.long	2154487066
	.long	1053236707
	.long	2154487066
	.long	1053236707
	.long	2154487066
	.long	1053236707
	.long	2154487066
	.long	1053236707
	.long	1521109587
	.long	3193628213
	.long	1521109587
	.long	3193628213
	.long	1521109587
	.long	3193628213
	.long	1521109587
	.long	3193628213
	.long	1521109587
	.long	3193628213
	.long	1521109587
	.long	3193628213
	.long	1521109587
	.long	3193628213
	.long	1521109587
	.long	3193628213
	.long	3993098302
	.long	1038487147
	.long	3993098302
	.long	1038487147
	.long	3993098302
	.long	1038487147
	.long	3993098302
	.long	1038487147
	.long	3993098302
	.long	1038487147
	.long	3993098302
	.long	1038487147
	.long	3993098302
	.long	1038487147
	.long	3993098302
	.long	1038487147
	.long	2124375536
	.long	3177836881
	.long	2124375536
	.long	3177836881
	.long	2124375536
	.long	3177836881
	.long	2124375536
	.long	3177836881
	.long	2124375536
	.long	3177836881
	.long	2124375536
	.long	3177836881
	.long	2124375536
	.long	3177836881
	.long	2124375536
	.long	3177836881
	.type	__svml_dsin_data_internal,@object
	.size	__svml_dsin_data_internal,1280
	.align 64
__svml_dsin_data_internal_ha:
	.long	0
	.long	0
	.long	0
	.long	1072693248
	.long	0
	.long	0
	.long	0
	.long	0
	.long	2376373521
	.long	3205741868
	.long	0
	.long	1072693248
	.long	4242458500
	.long	1065951697
	.long	2684354560
	.long	1009354638
	.long	3650591271
	.long	3207838971
	.long	0
	.long	1072693248
	.long	4154680958
	.long	1067000149
	.long	0
	.long	3153796451
	.long	69373323
	.long	3209049152
	.long	0
	.long	1072693248
	.long	1972655565
	.long	1067636837
	.long	1073741824
	.long	1009157878
	.long	220529721
	.long	3209935929
	.long	0
	.long	1072693248
	.long	4044216340
	.long	1068048229
	.long	0
	.long	3156808381
	.long	3810305407
	.long	3210663220
	.long	0
	.long	1072693248
	.long	2046304480
	.long	1068459374
	.long	3758096384
	.long	3156402667
	.long	4269262315
	.long	3211145810
	.long	0
	.long	1072693248
	.long	2462980598
	.long	1068684576
	.long	2684354560
	.long	3158941832
	.long	1118107366
	.long	3211670787
	.long	0
	.long	1072693248
	.long	177906713
	.long	1068889808
	.long	3221225472
	.long	3159310370
	.long	393047345
	.long	3212032302
	.long	0
	.long	1072693248
	.long	3156849708
	.long	1069094822
	.long	3221225472
	.long	3158189848
	.long	1227670166
	.long	3212375297
	.long	0
	.long	1072693248
	.long	3349070549
	.long	1069299589
	.long	3758096384
	.long	3156538269
	.long	2402293340
	.long	3212758471
	.long	0
	.long	1072693248
	.long	1453945614
	.long	1069504078
	.long	1610612736
	.long	1011492612
	.long	2592747447
	.long	3213009315
	.long	0
	.long	1072693248
	.long	3470456183
	.long	1069627888
	.long	1073741824
	.long	3160744771
	.long	1037482584
	.long	3213240992
	.long	0
	.long	1072693248
	.long	1854824762
	.long	1069729808
	.long	2684354560
	.long	1011953664
	.long	3451754846
	.long	3213492662
	.long	0
	.long	1072693248
	.long	2972270170
	.long	1069831542
	.long	1073741824
	.long	3159524770
	.long	1672287667
	.long	3213764289
	.long	0
	.long	1072693248
	.long	1149976518
	.long	1069933076
	.long	1610612736
	.long	1013264895
	.long	2346447124
	.long	3213970635
	.long	0
	.long	1072693248
	.long	3729833777
	.long	1070034393
	.long	3758096384
	.long	1013044718
	.long	18115067
	.long	3214126342
	.long	0
	.long	1072693248
	.long	1013556747
	.long	1070135480
	.long	2684354560
	.long	3160567065
	.long	2660899430
	.long	3214291960
	.long	0
	.long	1072693248
	.long	632292433
	.long	1070236320
	.long	3758096384
	.long	3160963333
	.long	1935888103
	.long	3214467466
	.long	0
	.long	1072693248
	.long	1786662755
	.long	1070336898
	.long	2147483648
	.long	3155882307
	.long	288924873
	.long	3214652833
	.long	0
	.long	1072693248
	.long	3846521617
	.long	1070437199
	.long	536870912
	.long	1013406610
	.long	2377770267
	.long	3214848032
	.long	0
	.long	1072693248
	.long	2065784603
	.long	1070537209
	.long	3758096384
	.long	3160681966
	.long	3250111450
	.long	3214993525
	.long	0
	.long	1072693248
	.long	238550446
	.long	1070616504
	.long	2684354560
	.long	3154383565
	.long	2306566604
	.long	3215100913
	.long	0
	.long	1072693248
	.long	1655830135
	.long	1070666194
	.long	0
	.long	1014506690
	.long	1913604284
	.long	3215213171
	.long	0
	.long	1072693248
	.long	1062001470
	.long	1070715716
	.long	0
	.long	3160875220
	.long	2476548698
	.long	3215330282
	.long	0
	.long	1072693248
	.long	785751814
	.long	1070765062
	.long	2684354560
	.long	3161838221
	.long	1261629236
	.long	3215452229
	.long	0
	.long	1072693248
	.long	3269558610
	.long	1070814224
	.long	536870912
	.long	3161705216
	.long	997322465
	.long	3215578993
	.long	0
	.long	1072693248
	.long	2484561409
	.long	1070863196
	.long	1073741824
	.long	1014024572
	.long	1296295961
	.long	3215710555
	.long	0
	.long	1072693248
	.long	1115219818
	.long	1070911970
	.long	0
	.long	1013072242
	.long	2962723252
	.long	3215846895
	.long	0
	.long	1072693248
	.long	1974149085
	.long	1070960538
	.long	3221225472
	.long	3156147648
	.long	4002549419
	.long	3215985292
	.long	0
	.long	1072693248
	.long	3711903686
	.long	1071008893
	.long	1073741824
	.long	1011944747
	.long	1234824733
	.long	3216058210
	.long	0
	.long	1072693248
	.long	821708191
	.long	1071057029
	.long	3758096384
	.long	3161738009
	.long	3996842794
	.long	3216133484
	.long	0
	.long	1072693248
	.long	824036583
	.long	1071104937
	.long	0
	.long	1008313330
	.long	2255197647
	.long	3216211105
	.long	0
	.long	1072693248
	.long	2796464483
	.long	1071152610
	.long	3221225472
	.long	3160878317
	.long	1638976426
	.long	3216291060
	.long	0
	.long	1072693248
	.long	1673302999
	.long	1071200042
	.long	2147483648
	.long	1013351473
	.long	1972483635
	.long	3216373337
	.long	0
	.long	1072693248
	.long	1135144330
	.long	1071247225
	.long	536870912
	.long	1013373569
	.long	1577996576
	.long	3216457924
	.long	0
	.long	1072693248
	.long	728580042
	.long	1071294152
	.long	1610612736
	.long	3162332944
	.long	1578746984
	.long	3216544808
	.long	0
	.long	1072693248
	.long	165764288
	.long	1071340816
	.long	3221225472
	.long	1013298018
	.long	1612193054
	.long	3216633976
	.long	0
	.long	1072693248
	.long	3623952103
	.long	1071387209
	.long	2684354560
	.long	3161985962
	.long	4133449816
	.long	3216725414
	.long	0
	.long	1072693248
	.long	2570175582
	.long	1071433326
	.long	1073741824
	.long	1012303118
	.long	1539072807
	.long	3216819110
	.long	0
	.long	1072693248
	.long	1535566729
	.long	1071479159
	.long	2147483648
	.long	1014321388
	.long	1945768569
	.long	3216915048
	.long	0
	.long	1072693248
	.long	939980347
	.long	1071524701
	.long	0
	.long	1012796809
	.long	3429717432
	.long	3217013214
	.long	0
	.long	1072693248
	.long	1391425750
	.long	1071569945
	.long	3221225472
	.long	3162362103
	.long	1312926554
	.long	3217072381
	.long	0
	.long	1072693248
	.long	3690502842
	.long	1071614884
	.long	3221225472
	.long	3157453855
	.long	1663679671
	.long	3217123670
	.long	0
	.long	1072693248
	.long	2269920951
	.long	1071652092
	.long	3758096384
	.long	3161672245
	.long	3952756490
	.long	3217176050
	.long	0
	.long	1072693248
	.long	2569207790
	.long	1071674247
	.long	1073741824
	.long	3163183617
	.long	69903290
	.long	3217229515
	.long	0
	.long	1072693248
	.long	1297975695
	.long	1071696240
	.long	3221225472
	.long	3163083735
	.long	2678847490
	.long	3217284054
	.long	0
	.long	1072693248
	.long	1411074851
	.long	1071718067
	.long	1610612736
	.long	3163484731
	.long	2272832445
	.long	3217339661
	.long	0
	.long	1072693248
	.long	1675549513
	.long	1071739725
	.long	3221225472
	.long	3163025138
	.long	1539668340
	.long	3217396327
	.long	0
	.long	1072693248
	.long	967731400
	.long	1071761211
	.long	536870912
	.long	1015752157
	.long	2482246777
	.long	3217454043
	.long	0
	.long	1072693248
	.long	2570316633
	.long	1071782521
	.long	1610612736
	.long	3162744753
	.long	2129093113
	.long	3217512801
	.long	0
	.long	1072693248
	.long	1289556703
	.long	1071803653
	.long	536870912
	.long	3162888820
	.long	1129922991
	.long	3217572592
	.long	0
	.long	1072693248
	.long	637203434
	.long	1071824603
	.long	3221225472
	.long	3159443841
	.long	3761365757
	.long	3217633406
	.long	0
	.long	1072693248
	.long	4242632757
	.long	1071845367
	.long	536870912
	.long	3161390278
	.long	752919289
	.long	3217695236
	.long	0
	.long	1072693248
	.long	2969983475
	.long	1071865944
	.long	2684354560
	.long	3162635443
	.long	3652612115
	.long	3217758070
	.long	0
	.long	1072693248
	.long	689983673
	.long	1071886330
	.long	3758096384
	.long	1014906405
	.long	1883353036
	.long	3217821901
	.long	0
	.long	1072693248
	.long	1397053140
	.long	1071906521
	.long	1610612736
	.long	1015245078
	.long	1403757309
	.long	3217886718
	.long	0
	.long	1072693248
	.long	621354454
	.long	1071926515
	.long	536870912
	.long	1013450602
	.long	3239527685
	.long	3217952511
	.long	0
	.long	1072693248
	.long	2610628921
	.long	1071946308
	.long	1610612736
	.long	3162668769
	.long	3489768009
	.long	3218019271
	.long	0
	.long	1072693248
	.long	3152274921
	.long	1071965898
	.long	3758096384
	.long	1013170835
	.long	2371640770
	.long	1070588851
	.long	0
	.long	1071644672
	.long	2460177814
	.long	1071985282
	.long	2147483648
	.long	3162116843
	.long	2309668539
	.long	1070520188
	.long	0
	.long	1071644672
	.long	881650848
	.long	1072004457
	.long	2147483648
	.long	3162986272
	.long	2081278341
	.long	1070450589
	.long	0
	.long	1071644672
	.long	3194290572
	.long	1072023419
	.long	2147483648
	.long	1015048682
	.long	3753901657
	.long	1070380064
	.long	0
	.long	1071644672
	.long	1427975391
	.long	1072042167
	.long	1073741824
	.long	3161608627
	.long	1403691706
	.long	1070308625
	.long	0
	.long	1071644672
	.long	636516413
	.long	1072060697
	.long	3758096384
	.long	1015823716
	.long	2583490354
	.long	1070236281
	.long	0
	.long	1071644672
	.long	1719614413
	.long	1072079006
	.long	0
	.long	3163282740
	.long	2546065654
	.long	1070163044
	.long	0
	.long	1071644672
	.long	1424664751
	.long	1072097092
	.long	3221225472
	.long	3163405315
	.long	1416934267
	.long	1070088925
	.long	0
	.long	1071644672
	.long	938475414
	.long	1072114952
	.long	0
	.long	1015076079
	.long	4187227697
	.long	1070013934
	.long	0
	.long	1071644672
	.long	1594061409
	.long	1072132583
	.long	2147483648
	.long	1014353870
	.long	3526603391
	.long	1069938084
	.long	0
	.long	1071644672
	.long	577417135
	.long	1072149983
	.long	2684354560
	.long	3161519415
	.long	1250776663
	.long	1069861386
	.long	0
	.long	1071644672
	.long	3814135665
	.long	1072167148
	.long	3221225472
	.long	3163146456
	.long	4019165092
	.long	1069783850
	.long	0
	.long	1071644672
	.long	201299822
	.long	1072184078
	.long	3758096384
	.long	3161912352
	.long	1852581091
	.long	1069705490
	.long	0
	.long	1071644672
	.long	263859903
	.long	1072200768
	.long	0
	.long	3162692284
	.long	2485417816
	.long	1069626316
	.long	0
	.long	1071644672
	.long	1796544321
	.long	1072217216
	.long	536870912
	.long	3162686945
	.long	2586490530
	.long	1069545162
	.long	0
	.long	1071644672
	.long	2750387213
	.long	1072233420
	.long	2147483648
	.long	3160858537
	.long	1224902090
	.long	1069383633
	.long	0
	.long	1071644672
	.long	1234330619
	.long	1072249378
	.long	2684354560
	.long	1015272473
	.long	2285031318
	.long	1069220549
	.long	0
	.long	1071644672
	.long	4106737474
	.long	1072265086
	.long	2684354560
	.long	3162592377
	.long	3876290983
	.long	1069055935
	.long	0
	.long	1071644672
	.long	1207142209
	.long	1072280544
	.long	2147483648
	.long	3162705634
	.long	802660176
	.long	1068889817
	.long	0
	.long	1071644672
	.long	4012486548
	.long	1072295747
	.long	2684354560
	.long	1014701564
	.long	1726519029
	.long	1068722218
	.long	0
	.long	1071644672
	.long	2688952194
	.long	1072310695
	.long	0
	.long	3161532603
	.long	3382663878
	.long	1068553164
	.long	0
	.long	1071644672
	.long	453180130
	.long	1072325385
	.long	1073741824
	.long	3162411281
	.long	2598800519
	.long	1068266419
	.long	0
	.long	1071644672
	.long	688824739
	.long	1072339814
	.long	3758096384
	.long	1010431536
	.long	1038988426
	.long	1067922646
	.long	0
	.long	1071644672
	.long	2653017361
	.long	1072353980
	.long	0
	.long	3162800062
	.long	1102361128
	.long	1067576117
	.long	0
	.long	1071644672
	.long	1477771776
	.long	1072367882
	.long	536870912
	.long	3163104986
	.long	2880516564
	.long	1067003401
	.long	0
	.long	1071644672
	.long	1056266002
	.long	1072381517
	.long	2684354560
	.long	3163469496
	.long	1220541286
	.long	1066197478
	.long	0
	.long	1071644672
	.long	1159294526
	.long	1072394883
	.long	536870912
	.long	3163276959
	.long	1279178457
	.long	1064107143
	.long	0
	.long	1071644672
	.long	1731563730
	.long	1072407978
	.long	536870912
	.long	1015540302
	.long	31019393
	.long	3212646089
	.long	0
	.long	1071644672
	.long	2892993834
	.long	1072420800
	.long	536870912
	.long	3163039143
	.long	3506991783
	.long	3214032490
	.long	0
	.long	1071644672
	.long	645027145
	.long	1072433348
	.long	3221225472
	.long	1012602239
	.long	2140183630
	.long	3214756396
	.long	0
	.long	1071644672
	.long	4051746225
	.long	1072445618
	.long	1610612736
	.long	3161907377
	.long	600368053
	.long	3215209541
	.long	0
	.long	1071644672
	.long	881357723
	.long	1072457611
	.long	3221225472
	.long	1013810890
	.long	913431823
	.long	3215576203
	.long	0
	.long	1071644672
	.long	557060597
	.long	1072469323
	.long	0
	.long	3159554934
	.long	1073154251
	.long	3215945137
	.long	0
	.long	1071644672
	.long	4093443164
	.long	1072480752
	.long	536870912
	.long	1014912865
	.long	3631910143
	.long	3216149439
	.long	0
	.long	1071644672
	.long	4097623923
	.long	1072491898
	.long	2684354560
	.long	3160308587
	.long	1380647130
	.long	3216336095
	.long	0
	.long	1071644672
	.long	1950234076
	.long	1072502759
	.long	536870912
	.long	3159425498
	.long	4049357271
	.long	3216523802
	.long	0
	.long	1071644672
	.long	3511535930
	.long	1072513332
	.long	2147483648
	.long	3162828626
	.long	1896722595
	.long	3216712534
	.long	0
	.long	1071644672
	.long	1942611595
	.long	1072523617
	.long	3221225472
	.long	3162410081
	.long	1699043957
	.long	3216902261
	.long	0
	.long	1071644672
	.long	3476196678
	.long	1072533611
	.long	0
	.long	1014257638
	.long	3296146332
	.long	1069485732
	.long	0
	.long	1070596096
	.long	1647878299
	.long	1072543314
	.long	3758096384
	.long	3162169063
	.long	3286832763
	.long	1069294100
	.long	0
	.long	1070596096
	.long	3066872380
	.long	1072552723
	.long	3221225472
	.long	1015561271
	.long	1962712856
	.long	1069101559
	.long	0
	.long	1070596096
	.long	1647164971
	.long	1072561838
	.long	2147483648
	.long	3162838250
	.long	3601629044
	.long	1068908137
	.long	0
	.long	1070596096
	.long	83265253
	.long	1072570657
	.long	1610612736
	.long	3162510535
	.long	165911977
	.long	1068713865
	.long	0
	.long	1070596096
	.long	1261158782
	.long	1072579178
	.long	2147483648
	.long	1015711544
	.long	1348311045
	.long	1068518770
	.long	0
	.long	1070596096
	.long	3964199186
	.long	1072587400
	.long	3758096384
	.long	3160501078
	.long	386665102
	.long	1068146822
	.long	0
	.long	1070596096
	.long	2873938189
	.long	1072595323
	.long	1610612736
	.long	3162311422
	.long	1991047213
	.long	1067753521
	.long	0
	.long	1070596096
	.long	1455828442
	.long	1072602945
	.long	3758096384
	.long	1015505073
	.long	4107121629
	.long	1067267139
	.long	0
	.long	1070596096
	.long	3370060660
	.long	1072610264
	.long	1610612736
	.long	1014787212
	.long	723478390
	.long	1066474790
	.long	0
	.long	1070596096
	.long	3882371427
	.long	1072617280
	.long	2147483648
	.long	1014923975
	.long	2382326656
	.long	1064562179
	.long	0
	.long	1070596096
	.long	2749658050
	.long	1072623992
	.long	1610612736
	.long	1015427338
	.long	2614369450
	.long	3212624080
	.long	0
	.long	1070596096
	.long	4220661975
	.long	1072630398
	.long	3221225472
	.long	1014312058
	.long	3587565429
	.long	3214108032
	.long	0
	.long	1070596096
	.long	4151720666
	.long	1072636498
	.long	0
	.long	3162639544
	.long	2886567144
	.long	3214910444
	.long	0
	.long	1070596096
	.long	2892293513
	.long	1072642291
	.long	2684354560
	.long	3162340271
	.long	1765797566
	.long	3215324543
	.long	0
	.long	1070596096
	.long	990588717
	.long	1072647776
	.long	3758096384
	.long	3162041857
	.long	240740309
	.long	3215727903
	.long	0
	.long	1070596096
	.long	3489094832
	.long	1072652951
	.long	536870912
	.long	1014325783
	.long	2034433221
	.long	1068349287
	.long	0
	.long	1069547520
	.long	2745245815
	.long	1072657817
	.long	3221225472
	.long	1015566129
	.long	304938777
	.long	1067944017
	.long	0
	.long	1069547520
	.long	4201728937
	.long	1072662372
	.long	1610612736
	.long	1014674006
	.long	3299146087
	.long	1067537882
	.long	0
	.long	1069547520
	.long	617154971
	.long	1072666617
	.long	3758096384
	.long	3163433696
	.long	1953696209
	.long	1066811523
	.long	0
	.long	1069547520
	.long	2131272983
	.long	1072670549
	.long	3221225472
	.long	3163005096
	.long	3987691371
	.long	1065590540
	.long	0
	.long	1069547520
	.long	1905645377
	.long	1072674169
	.long	1610612736
	.long	1014087596
	.long	718380601
	.long	3211081269
	.long	0
	.long	1069547520
	.long	1893834707
	.long	1072677476
	.long	1610612736
	.long	1015147654
	.long	3272206680
	.long	3213771729
	.long	0
	.long	1069547520
	.long	4251821691
	.long	1072680469
	.long	2147483648
	.long	3161841007
	.long	257503056
	.long	3214647653
	.long	0
	.long	1069547520
	.long	2748392742
	.long	1072683149
	.long	536870912
	.long	3163061750
	.long	711626851
	.long	1066916672
	.long	0
	.long	1068498944
	.long	4240268041
	.long	1072685514
	.long	536870912
	.long	1013588963
	.long	2523975598
	.long	1065789700
	.long	0
	.long	1068498944
	.long	2902558778
	.long	1072687565
	.long	3221225472
	.long	1013260780
	.long	3237733378
	.long	3209908784
	.long	0
	.long	1068498944
	.long	1703834029
	.long	1072689301
	.long	3758096384
	.long	1015028364
	.long	1003003824
	.long	3213591144
	.long	0
	.long	1068498944
	.long	3816385918
	.long	1072690721
	.long	536870912
	.long	3161216956
	.long	2896342633
	.long	1064747819
	.long	0
	.long	1067450368
	.long	4026464093
	.long	1072691826
	.long	3221225472
	.long	3163075789
	.long	561145352
	.long	3212540584
	.long	0
	.long	1067450368
	.long	1619315981
	.long	1072692616
	.long	1073741824
	.long	3162584397
	.long	210035182
	.long	3211491512
	.long	0
	.long	1066401792
	.long	379294427
	.long	1072693090
	.long	3221225472
	.long	1015405987
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	1072693248
	.long	0
	.long	0
	.long	210035182
	.long	1064007864
	.long	0
	.long	3213885440
	.long	379294427
	.long	1072693090
	.long	3221225472
	.long	1015405987
	.long	561145352
	.long	1065056936
	.long	0
	.long	3214934016
	.long	1619315981
	.long	1072692616
	.long	1073741824
	.long	3162584397
	.long	2896342633
	.long	3212231467
	.long	0
	.long	3214934016
	.long	4026464093
	.long	1072691826
	.long	3221225472
	.long	3163075789
	.long	1003003824
	.long	1066107496
	.long	0
	.long	3215982592
	.long	3816385918
	.long	1072690721
	.long	536870912
	.long	3161216956
	.long	3237733378
	.long	1062425136
	.long	0
	.long	3215982592
	.long	1703834029
	.long	1072689301
	.long	3758096384
	.long	1015028364
	.long	2523975598
	.long	3213273348
	.long	0
	.long	3215982592
	.long	2902558778
	.long	1072687565
	.long	3221225472
	.long	1013260780
	.long	711626851
	.long	3214400320
	.long	0
	.long	3215982592
	.long	4240268041
	.long	1072685514
	.long	536870912
	.long	1013588963
	.long	257503056
	.long	1067164005
	.long	0
	.long	3217031168
	.long	2748392742
	.long	1072683149
	.long	536870912
	.long	3163061750
	.long	3272206680
	.long	1066288081
	.long	0
	.long	3217031168
	.long	4251821691
	.long	1072680469
	.long	2147483648
	.long	3161841007
	.long	718380601
	.long	1063597621
	.long	0
	.long	3217031168
	.long	1893834707
	.long	1072677476
	.long	1610612736
	.long	1015147654
	.long	3987691371
	.long	3213074188
	.long	0
	.long	3217031168
	.long	1905645377
	.long	1072674169
	.long	1610612736
	.long	1014087596
	.long	1953696209
	.long	3214295171
	.long	0
	.long	3217031168
	.long	2131272983
	.long	1072670549
	.long	3221225472
	.long	3163005096
	.long	3299146087
	.long	3215021530
	.long	0
	.long	3217031168
	.long	617154971
	.long	1072666617
	.long	3758096384
	.long	3163433696
	.long	304938777
	.long	3215427665
	.long	0
	.long	3217031168
	.long	4201728937
	.long	1072662372
	.long	1610612736
	.long	1014674006
	.long	2034433221
	.long	3215832935
	.long	0
	.long	3217031168
	.long	2745245815
	.long	1072657817
	.long	3221225472
	.long	1015566129
	.long	240740309
	.long	1068244255
	.long	0
	.long	3218079744
	.long	3489094832
	.long	1072652951
	.long	536870912
	.long	1014325783
	.long	1765797566
	.long	1067840895
	.long	0
	.long	3218079744
	.long	990588717
	.long	1072647776
	.long	3758096384
	.long	3162041857
	.long	2886567144
	.long	1067426796
	.long	0
	.long	3218079744
	.long	2892293513
	.long	1072642291
	.long	2684354560
	.long	3162340271
	.long	3587565429
	.long	1066624384
	.long	0
	.long	3218079744
	.long	4151720666
	.long	1072636498
	.long	0
	.long	3162639544
	.long	2614369450
	.long	1065140432
	.long	0
	.long	3218079744
	.long	4220661975
	.long	1072630398
	.long	3221225472
	.long	1014312058
	.long	2382326656
	.long	3212045827
	.long	0
	.long	3218079744
	.long	2749658050
	.long	1072623992
	.long	1610612736
	.long	1015427338
	.long	723478390
	.long	3213958438
	.long	0
	.long	3218079744
	.long	3882371427
	.long	1072617280
	.long	2147483648
	.long	1014923975
	.long	4107121629
	.long	3214750787
	.long	0
	.long	3218079744
	.long	3370060660
	.long	1072610264
	.long	1610612736
	.long	1014787212
	.long	1991047213
	.long	3215237169
	.long	0
	.long	3218079744
	.long	1455828442
	.long	1072602945
	.long	3758096384
	.long	1015505073
	.long	386665102
	.long	3215630470
	.long	0
	.long	3218079744
	.long	2873938189
	.long	1072595323
	.long	1610612736
	.long	3162311422
	.long	1348311045
	.long	3216002418
	.long	0
	.long	3218079744
	.long	3964199186
	.long	1072587400
	.long	3758096384
	.long	3160501078
	.long	165911977
	.long	3216197513
	.long	0
	.long	3218079744
	.long	1261158782
	.long	1072579178
	.long	2147483648
	.long	1015711544
	.long	3601629044
	.long	3216391785
	.long	0
	.long	3218079744
	.long	83265253
	.long	1072570657
	.long	1610612736
	.long	3162510535
	.long	1962712856
	.long	3216585207
	.long	0
	.long	3218079744
	.long	1647164971
	.long	1072561838
	.long	2147483648
	.long	3162838250
	.long	3286832763
	.long	3216777748
	.long	0
	.long	3218079744
	.long	3066872380
	.long	1072552723
	.long	3221225472
	.long	1015561271
	.long	3296146332
	.long	3216969380
	.long	0
	.long	3218079744
	.long	1647878299
	.long	1072543314
	.long	3758096384
	.long	3162169063
	.long	1699043957
	.long	1069418613
	.long	0
	.long	3219128320
	.long	3476196678
	.long	1072533611
	.long	0
	.long	1014257638
	.long	1896722595
	.long	1069228886
	.long	0
	.long	3219128320
	.long	1942611595
	.long	1072523617
	.long	3221225472
	.long	3162410081
	.long	4049357271
	.long	1069040154
	.long	0
	.long	3219128320
	.long	3511535930
	.long	1072513332
	.long	2147483648
	.long	3162828626
	.long	1380647130
	.long	1068852447
	.long	0
	.long	3219128320
	.long	1950234076
	.long	1072502759
	.long	536870912
	.long	3159425498
	.long	3631910143
	.long	1068665791
	.long	0
	.long	3219128320
	.long	4097623923
	.long	1072491898
	.long	2684354560
	.long	3160308587
	.long	1073154251
	.long	1068461489
	.long	0
	.long	3219128320
	.long	4093443164
	.long	1072480752
	.long	536870912
	.long	1014912865
	.long	913431823
	.long	1068092555
	.long	0
	.long	3219128320
	.long	557060597
	.long	1072469323
	.long	0
	.long	3159554934
	.long	600368053
	.long	1067725893
	.long	0
	.long	3219128320
	.long	881357723
	.long	1072457611
	.long	3221225472
	.long	1013810890
	.long	2140183630
	.long	1067272748
	.long	0
	.long	3219128320
	.long	4051746225
	.long	1072445618
	.long	1610612736
	.long	3161907377
	.long	3506991783
	.long	1066548842
	.long	0
	.long	3219128320
	.long	645027145
	.long	1072433348
	.long	3221225472
	.long	1012602239
	.long	31019393
	.long	1065162441
	.long	0
	.long	3219128320
	.long	2892993834
	.long	1072420800
	.long	536870912
	.long	3163039143
	.long	1279178457
	.long	3211590791
	.long	0
	.long	3219128320
	.long	1731563730
	.long	1072407978
	.long	536870912
	.long	1015540302
	.long	1220541286
	.long	3213681126
	.long	0
	.long	3219128320
	.long	1159294526
	.long	1072394883
	.long	536870912
	.long	3163276959
	.long	2880516564
	.long	3214487049
	.long	0
	.long	3219128320
	.long	1056266002
	.long	1072381517
	.long	2684354560
	.long	3163469496
	.long	1102361128
	.long	3215059765
	.long	0
	.long	3219128320
	.long	1477771776
	.long	1072367882
	.long	536870912
	.long	3163104986
	.long	1038988426
	.long	3215406294
	.long	0
	.long	3219128320
	.long	2653017361
	.long	1072353980
	.long	0
	.long	3162800062
	.long	2598800519
	.long	3215750067
	.long	0
	.long	3219128320
	.long	688824739
	.long	1072339814
	.long	3758096384
	.long	1010431536
	.long	3382663878
	.long	3216036812
	.long	0
	.long	3219128320
	.long	453180130
	.long	1072325385
	.long	1073741824
	.long	3162411281
	.long	1726519029
	.long	3216205866
	.long	0
	.long	3219128320
	.long	2688952194
	.long	1072310695
	.long	0
	.long	3161532603
	.long	802660176
	.long	3216373465
	.long	0
	.long	3219128320
	.long	4012486548
	.long	1072295747
	.long	2684354560
	.long	1014701564
	.long	3876290983
	.long	3216539583
	.long	0
	.long	3219128320
	.long	1207142209
	.long	1072280544
	.long	2147483648
	.long	3162705634
	.long	2285031318
	.long	3216704197
	.long	0
	.long	3219128320
	.long	4106737474
	.long	1072265086
	.long	2684354560
	.long	3162592377
	.long	1224902090
	.long	3216867281
	.long	0
	.long	3219128320
	.long	1234330619
	.long	1072249378
	.long	2684354560
	.long	1015272473
	.long	2586490530
	.long	3217028810
	.long	0
	.long	3219128320
	.long	2750387213
	.long	1072233420
	.long	2147483648
	.long	3160858537
	.long	2485417816
	.long	3217109964
	.long	0
	.long	3219128320
	.long	1796544321
	.long	1072217216
	.long	536870912
	.long	3162686945
	.long	1852581091
	.long	3217189138
	.long	0
	.long	3219128320
	.long	263859903
	.long	1072200768
	.long	0
	.long	3162692284
	.long	4019165092
	.long	3217267498
	.long	0
	.long	3219128320
	.long	201299822
	.long	1072184078
	.long	3758096384
	.long	3161912352
	.long	1250776663
	.long	3217345034
	.long	0
	.long	3219128320
	.long	3814135665
	.long	1072167148
	.long	3221225472
	.long	3163146456
	.long	3526603391
	.long	3217421732
	.long	0
	.long	3219128320
	.long	577417135
	.long	1072149983
	.long	2684354560
	.long	3161519415
	.long	4187227697
	.long	3217497582
	.long	0
	.long	3219128320
	.long	1594061409
	.long	1072132583
	.long	2147483648
	.long	1014353870
	.long	1416934267
	.long	3217572573
	.long	0
	.long	3219128320
	.long	938475414
	.long	1072114952
	.long	0
	.long	1015076079
	.long	2546065654
	.long	3217646692
	.long	0
	.long	3219128320
	.long	1424664751
	.long	1072097092
	.long	3221225472
	.long	3163405315
	.long	2583490354
	.long	3217719929
	.long	0
	.long	3219128320
	.long	1719614413
	.long	1072079006
	.long	0
	.long	3163282740
	.long	1403691706
	.long	3217792273
	.long	0
	.long	3219128320
	.long	636516413
	.long	1072060697
	.long	3758096384
	.long	1015823716
	.long	3753901657
	.long	3217863712
	.long	0
	.long	3219128320
	.long	1427975391
	.long	1072042167
	.long	1073741824
	.long	3161608627
	.long	2081278341
	.long	3217934237
	.long	0
	.long	3219128320
	.long	3194290572
	.long	1072023419
	.long	2147483648
	.long	1015048682
	.long	2309668539
	.long	3218003836
	.long	0
	.long	3219128320
	.long	881650848
	.long	1072004457
	.long	2147483648
	.long	3162986272
	.long	2371640770
	.long	3218072499
	.long	0
	.long	3219128320
	.long	2460177814
	.long	1071985282
	.long	2147483648
	.long	3162116843
	.long	3489768009
	.long	1070535623
	.long	0
	.long	3220176896
	.long	3152274921
	.long	1071965898
	.long	3758096384
	.long	1013170835
	.long	3239527685
	.long	1070468863
	.long	0
	.long	3220176896
	.long	2610628921
	.long	1071946308
	.long	1610612736
	.long	3162668769
	.long	1403757309
	.long	1070403070
	.long	0
	.long	3220176896
	.long	621354454
	.long	1071926515
	.long	536870912
	.long	1013450602
	.long	1883353036
	.long	1070338253
	.long	0
	.long	3220176896
	.long	1397053140
	.long	1071906521
	.long	1610612736
	.long	1015245078
	.long	3652612115
	.long	1070274422
	.long	0
	.long	3220176896
	.long	689983673
	.long	1071886330
	.long	3758096384
	.long	1014906405
	.long	752919289
	.long	1070211588
	.long	0
	.long	3220176896
	.long	2969983475
	.long	1071865944
	.long	2684354560
	.long	3162635443
	.long	3761365757
	.long	1070149758
	.long	0
	.long	3220176896
	.long	4242632757
	.long	1071845367
	.long	536870912
	.long	3161390278
	.long	1129922991
	.long	1070088944
	.long	0
	.long	3220176896
	.long	637203434
	.long	1071824603
	.long	3221225472
	.long	3159443841
	.long	2129093113
	.long	1070029153
	.long	0
	.long	3220176896
	.long	1289556703
	.long	1071803653
	.long	536870912
	.long	3162888820
	.long	2482246777
	.long	1069970395
	.long	0
	.long	3220176896
	.long	2570316633
	.long	1071782521
	.long	1610612736
	.long	3162744753
	.long	1539668340
	.long	1069912679
	.long	0
	.long	3220176896
	.long	967731400
	.long	1071761211
	.long	536870912
	.long	1015752157
	.long	2272832445
	.long	1069856013
	.long	0
	.long	3220176896
	.long	1675549513
	.long	1071739725
	.long	3221225472
	.long	3163025138
	.long	2678847490
	.long	1069800406
	.long	0
	.long	3220176896
	.long	1411074851
	.long	1071718067
	.long	1610612736
	.long	3163484731
	.long	69903290
	.long	1069745867
	.long	0
	.long	3220176896
	.long	1297975695
	.long	1071696240
	.long	3221225472
	.long	3163083735
	.long	3952756490
	.long	1069692402
	.long	0
	.long	3220176896
	.long	2569207790
	.long	1071674247
	.long	1073741824
	.long	3163183617
	.long	1663679671
	.long	1069640022
	.long	0
	.long	3220176896
	.long	2269920951
	.long	1071652092
	.long	3758096384
	.long	3161672245
	.long	1312926554
	.long	1069588733
	.long	0
	.long	3220176896
	.long	3690502842
	.long	1071614884
	.long	3221225472
	.long	3157453855
	.long	3429717432
	.long	1069529566
	.long	0
	.long	3220176896
	.long	1391425750
	.long	1071569945
	.long	3221225472
	.long	3162362103
	.long	1945768569
	.long	1069431400
	.long	0
	.long	3220176896
	.long	939980347
	.long	1071524701
	.long	0
	.long	1012796809
	.long	1539072807
	.long	1069335462
	.long	0
	.long	3220176896
	.long	1535566729
	.long	1071479159
	.long	2147483648
	.long	1014321388
	.long	4133449816
	.long	1069241766
	.long	0
	.long	3220176896
	.long	2570175582
	.long	1071433326
	.long	1073741824
	.long	1012303118
	.long	1612193054
	.long	1069150328
	.long	0
	.long	3220176896
	.long	3623952103
	.long	1071387209
	.long	2684354560
	.long	3161985962
	.long	1578746984
	.long	1069061160
	.long	0
	.long	3220176896
	.long	165764288
	.long	1071340816
	.long	3221225472
	.long	1013298018
	.long	1577996576
	.long	1068974276
	.long	0
	.long	3220176896
	.long	728580042
	.long	1071294152
	.long	1610612736
	.long	3162332944
	.long	1972483635
	.long	1068889689
	.long	0
	.long	3220176896
	.long	1135144330
	.long	1071247225
	.long	536870912
	.long	1013373569
	.long	1638976426
	.long	1068807412
	.long	0
	.long	3220176896
	.long	1673302999
	.long	1071200042
	.long	2147483648
	.long	1013351473
	.long	2255197647
	.long	1068727457
	.long	0
	.long	3220176896
	.long	2796464483
	.long	1071152610
	.long	3221225472
	.long	3160878317
	.long	3996842794
	.long	1068649836
	.long	0
	.long	3220176896
	.long	824036583
	.long	1071104937
	.long	0
	.long	1008313330
	.long	1234824733
	.long	1068574562
	.long	0
	.long	3220176896
	.long	821708191
	.long	1071057029
	.long	3758096384
	.long	3161738009
	.long	4002549419
	.long	1068501644
	.long	0
	.long	3220176896
	.long	3711903686
	.long	1071008893
	.long	1073741824
	.long	1011944747
	.long	2962723252
	.long	1068363247
	.long	0
	.long	3220176896
	.long	1974149085
	.long	1070960538
	.long	3221225472
	.long	3156147648
	.long	1296295961
	.long	1068226907
	.long	0
	.long	3220176896
	.long	1115219818
	.long	1070911970
	.long	0
	.long	1013072242
	.long	997322465
	.long	1068095345
	.long	0
	.long	3220176896
	.long	2484561409
	.long	1070863196
	.long	1073741824
	.long	1014024572
	.long	1261629236
	.long	1067968581
	.long	0
	.long	3220176896
	.long	3269558610
	.long	1070814224
	.long	536870912
	.long	3161705216
	.long	2476548698
	.long	1067846634
	.long	0
	.long	3220176896
	.long	785751814
	.long	1070765062
	.long	2684354560
	.long	3161838221
	.long	1913604284
	.long	1067729523
	.long	0
	.long	3220176896
	.long	1062001470
	.long	1070715716
	.long	0
	.long	3160875220
	.long	2306566604
	.long	1067617265
	.long	0
	.long	3220176896
	.long	1655830135
	.long	1070666194
	.long	0
	.long	1014506690
	.long	3250111450
	.long	1067509877
	.long	0
	.long	3220176896
	.long	238550446
	.long	1070616504
	.long	2684354560
	.long	3154383565
	.long	2377770267
	.long	1067364384
	.long	0
	.long	3220176896
	.long	2065784603
	.long	1070537209
	.long	3758096384
	.long	3160681966
	.long	288924873
	.long	1067169185
	.long	0
	.long	3220176896
	.long	3846521617
	.long	1070437199
	.long	536870912
	.long	1013406610
	.long	1935888103
	.long	1066983818
	.long	0
	.long	3220176896
	.long	1786662755
	.long	1070336898
	.long	2147483648
	.long	3155882307
	.long	2660899430
	.long	1066808312
	.long	0
	.long	3220176896
	.long	632292433
	.long	1070236320
	.long	3758096384
	.long	3160963333
	.long	18115067
	.long	1066642694
	.long	0
	.long	3220176896
	.long	1013556747
	.long	1070135480
	.long	2684354560
	.long	3160567065
	.long	2346447124
	.long	1066486987
	.long	0
	.long	3220176896
	.long	3729833777
	.long	1070034393
	.long	3758096384
	.long	1013044718
	.long	1672287667
	.long	1066280641
	.long	0
	.long	3220176896
	.long	1149976518
	.long	1069933076
	.long	1610612736
	.long	1013264895
	.long	3451754846
	.long	1066009014
	.long	0
	.long	3220176896
	.long	2972270170
	.long	1069831542
	.long	1073741824
	.long	3159524770
	.long	1037482584
	.long	1065757344
	.long	0
	.long	3220176896
	.long	1854824762
	.long	1069729808
	.long	2684354560
	.long	1011953664
	.long	2592747447
	.long	1065525667
	.long	0
	.long	3220176896
	.long	3470456183
	.long	1069627888
	.long	1073741824
	.long	3160744771
	.long	2402293340
	.long	1065274823
	.long	0
	.long	3220176896
	.long	1453945614
	.long	1069504078
	.long	1610612736
	.long	1011492612
	.long	1227670166
	.long	1064891649
	.long	0
	.long	3220176896
	.long	3349070549
	.long	1069299589
	.long	3758096384
	.long	3156538269
	.long	393047345
	.long	1064548654
	.long	0
	.long	3220176896
	.long	3156849708
	.long	1069094822
	.long	3221225472
	.long	3158189848
	.long	1118107366
	.long	1064187139
	.long	0
	.long	3220176896
	.long	177906713
	.long	1068889808
	.long	3221225472
	.long	3159310370
	.long	4269262315
	.long	1063662162
	.long	0
	.long	3220176896
	.long	2462980598
	.long	1068684576
	.long	2684354560
	.long	3158941832
	.long	3810305407
	.long	1063179572
	.long	0
	.long	3220176896
	.long	2046304480
	.long	1068459374
	.long	3758096384
	.long	3156402667
	.long	220529721
	.long	1062452281
	.long	0
	.long	3220176896
	.long	4044216340
	.long	1068048229
	.long	0
	.long	3156808381
	.long	69373323
	.long	1061565504
	.long	0
	.long	3220176896
	.long	1972655565
	.long	1067636837
	.long	1073741824
	.long	1009157878
	.long	3650591271
	.long	1060355323
	.long	0
	.long	3220176896
	.long	4154680958
	.long	1067000149
	.long	0
	.long	3153796451
	.long	2376373521
	.long	1058258220
	.long	0
	.long	3220176896
	.long	4242458500
	.long	1065951697
	.long	2684354560
	.long	1009354638
	.long	0
	.long	0
	.long	0
	.long	3220176896
	.long	0
	.long	0
	.long	0
	.long	0
	.long	2376373521
	.long	1058258220
	.long	0
	.long	3220176896
	.long	4242458500
	.long	3213435345
	.long	2684354560
	.long	3156838286
	.long	3650591271
	.long	1060355323
	.long	0
	.long	3220176896
	.long	4154680958
	.long	3214483797
	.long	0
	.long	1006312803
	.long	69373323
	.long	1061565504
	.long	0
	.long	3220176896
	.long	1972655565
	.long	3215120485
	.long	1073741824
	.long	3156641526
	.long	220529721
	.long	1062452281
	.long	0
	.long	3220176896
	.long	4044216340
	.long	3215531877
	.long	0
	.long	1009324733
	.long	3810305407
	.long	1063179572
	.long	0
	.long	3220176896
	.long	2046304480
	.long	3215943022
	.long	3758096384
	.long	1008919019
	.long	4269262315
	.long	1063662162
	.long	0
	.long	3220176896
	.long	2462980598
	.long	3216168224
	.long	2684354560
	.long	1011458184
	.long	1118107366
	.long	1064187139
	.long	0
	.long	3220176896
	.long	177906713
	.long	3216373456
	.long	3221225472
	.long	1011826722
	.long	393047345
	.long	1064548654
	.long	0
	.long	3220176896
	.long	3156849708
	.long	3216578470
	.long	3221225472
	.long	1010706200
	.long	1227670166
	.long	1064891649
	.long	0
	.long	3220176896
	.long	3349070549
	.long	3216783237
	.long	3758096384
	.long	1009054621
	.long	2402293340
	.long	1065274823
	.long	0
	.long	3220176896
	.long	1453945614
	.long	3216987726
	.long	1610612736
	.long	3158976260
	.long	2592747447
	.long	1065525667
	.long	0
	.long	3220176896
	.long	3470456183
	.long	3217111536
	.long	1073741824
	.long	1013261123
	.long	1037482584
	.long	1065757344
	.long	0
	.long	3220176896
	.long	1854824762
	.long	3217213456
	.long	2684354560
	.long	3159437312
	.long	3451754846
	.long	1066009014
	.long	0
	.long	3220176896
	.long	2972270170
	.long	3217315190
	.long	1073741824
	.long	1012041122
	.long	1672287667
	.long	1066280641
	.long	0
	.long	3220176896
	.long	1149976518
	.long	3217416724
	.long	1610612736
	.long	3160748543
	.long	2346447124
	.long	1066486987
	.long	0
	.long	3220176896
	.long	3729833777
	.long	3217518041
	.long	3758096384
	.long	3160528366
	.long	18115067
	.long	1066642694
	.long	0
	.long	3220176896
	.long	1013556747
	.long	3217619128
	.long	2684354560
	.long	1013083417
	.long	2660899430
	.long	1066808312
	.long	0
	.long	3220176896
	.long	632292433
	.long	3217719968
	.long	3758096384
	.long	1013479685
	.long	1935888103
	.long	1066983818
	.long	0
	.long	3220176896
	.long	1786662755
	.long	3217820546
	.long	2147483648
	.long	1008398659
	.long	288924873
	.long	1067169185
	.long	0
	.long	3220176896
	.long	3846521617
	.long	3217920847
	.long	536870912
	.long	3160890258
	.long	2377770267
	.long	1067364384
	.long	0
	.long	3220176896
	.long	2065784603
	.long	3218020857
	.long	3758096384
	.long	1013198318
	.long	3250111450
	.long	1067509877
	.long	0
	.long	3220176896
	.long	238550446
	.long	3218100152
	.long	2684354560
	.long	1006899917
	.long	2306566604
	.long	1067617265
	.long	0
	.long	3220176896
	.long	1655830135
	.long	3218149842
	.long	0
	.long	3161990338
	.long	1913604284
	.long	1067729523
	.long	0
	.long	3220176896
	.long	1062001470
	.long	3218199364
	.long	0
	.long	1013391572
	.long	2476548698
	.long	1067846634
	.long	0
	.long	3220176896
	.long	785751814
	.long	3218248710
	.long	2684354560
	.long	1014354573
	.long	1261629236
	.long	1067968581
	.long	0
	.long	3220176896
	.long	3269558610
	.long	3218297872
	.long	536870912
	.long	1014221568
	.long	997322465
	.long	1068095345
	.long	0
	.long	3220176896
	.long	2484561409
	.long	3218346844
	.long	1073741824
	.long	3161508220
	.long	1296295961
	.long	1068226907
	.long	0
	.long	3220176896
	.long	1115219818
	.long	3218395618
	.long	0
	.long	3160555890
	.long	2962723252
	.long	1068363247
	.long	0
	.long	3220176896
	.long	1974149085
	.long	3218444186
	.long	3221225472
	.long	1008664000
	.long	4002549419
	.long	1068501644
	.long	0
	.long	3220176896
	.long	3711903686
	.long	3218492541
	.long	1073741824
	.long	3159428395
	.long	1234824733
	.long	1068574562
	.long	0
	.long	3220176896
	.long	821708191
	.long	3218540677
	.long	3758096384
	.long	1014254361
	.long	3996842794
	.long	1068649836
	.long	0
	.long	3220176896
	.long	824036583
	.long	3218588585
	.long	0
	.long	3155796978
	.long	2255197647
	.long	1068727457
	.long	0
	.long	3220176896
	.long	2796464483
	.long	3218636258
	.long	3221225472
	.long	1013394669
	.long	1638976426
	.long	1068807412
	.long	0
	.long	3220176896
	.long	1673302999
	.long	3218683690
	.long	2147483648
	.long	3160835121
	.long	1972483635
	.long	1068889689
	.long	0
	.long	3220176896
	.long	1135144330
	.long	3218730873
	.long	536870912
	.long	3160857217
	.long	1577996576
	.long	1068974276
	.long	0
	.long	3220176896
	.long	728580042
	.long	3218777800
	.long	1610612736
	.long	1014849296
	.long	1578746984
	.long	1069061160
	.long	0
	.long	3220176896
	.long	165764288
	.long	3218824464
	.long	3221225472
	.long	3160781666
	.long	1612193054
	.long	1069150328
	.long	0
	.long	3220176896
	.long	3623952103
	.long	3218870857
	.long	2684354560
	.long	1014502314
	.long	4133449816
	.long	1069241766
	.long	0
	.long	3220176896
	.long	2570175582
	.long	3218916974
	.long	1073741824
	.long	3159786766
	.long	1539072807
	.long	1069335462
	.long	0
	.long	3220176896
	.long	1535566729
	.long	3218962807
	.long	2147483648
	.long	3161805036
	.long	1945768569
	.long	1069431400
	.long	0
	.long	3220176896
	.long	939980347
	.long	3219008349
	.long	0
	.long	3160280457
	.long	3429717432
	.long	1069529566
	.long	0
	.long	3220176896
	.long	1391425750
	.long	3219053593
	.long	3221225472
	.long	1014878455
	.long	1312926554
	.long	1069588733
	.long	0
	.long	3220176896
	.long	3690502842
	.long	3219098532
	.long	3221225472
	.long	1009970207
	.long	1663679671
	.long	1069640022
	.long	0
	.long	3220176896
	.long	2269920951
	.long	3219135740
	.long	3758096384
	.long	1014188597
	.long	3952756490
	.long	1069692402
	.long	0
	.long	3220176896
	.long	2569207790
	.long	3219157895
	.long	1073741824
	.long	1015699969
	.long	69903290
	.long	1069745867
	.long	0
	.long	3220176896
	.long	1297975695
	.long	3219179888
	.long	3221225472
	.long	1015600087
	.long	2678847490
	.long	1069800406
	.long	0
	.long	3220176896
	.long	1411074851
	.long	3219201715
	.long	1610612736
	.long	1016001083
	.long	2272832445
	.long	1069856013
	.long	0
	.long	3220176896
	.long	1675549513
	.long	3219223373
	.long	3221225472
	.long	1015541490
	.long	1539668340
	.long	1069912679
	.long	0
	.long	3220176896
	.long	967731400
	.long	3219244859
	.long	536870912
	.long	3163235805
	.long	2482246777
	.long	1069970395
	.long	0
	.long	3220176896
	.long	2570316633
	.long	3219266169
	.long	1610612736
	.long	1015261105
	.long	2129093113
	.long	1070029153
	.long	0
	.long	3220176896
	.long	1289556703
	.long	3219287301
	.long	536870912
	.long	1015405172
	.long	1129922991
	.long	1070088944
	.long	0
	.long	3220176896
	.long	637203434
	.long	3219308251
	.long	3221225472
	.long	1011960193
	.long	3761365757
	.long	1070149758
	.long	0
	.long	3220176896
	.long	4242632757
	.long	3219329015
	.long	536870912
	.long	1013906630
	.long	752919289
	.long	1070211588
	.long	0
	.long	3220176896
	.long	2969983475
	.long	3219349592
	.long	2684354560
	.long	1015151795
	.long	3652612115
	.long	1070274422
	.long	0
	.long	3220176896
	.long	689983673
	.long	3219369978
	.long	3758096384
	.long	3162390053
	.long	1883353036
	.long	1070338253
	.long	0
	.long	3220176896
	.long	1397053140
	.long	3219390169
	.long	1610612736
	.long	3162728726
	.long	1403757309
	.long	1070403070
	.long	0
	.long	3220176896
	.long	621354454
	.long	3219410163
	.long	536870912
	.long	3160934250
	.long	3239527685
	.long	1070468863
	.long	0
	.long	3220176896
	.long	2610628921
	.long	3219429956
	.long	1610612736
	.long	1015185121
	.long	3489768009
	.long	1070535623
	.long	0
	.long	3220176896
	.long	3152274921
	.long	3219449546
	.long	3758096384
	.long	3160654483
	.long	2371640770
	.long	3218072499
	.long	0
	.long	3219128320
	.long	2460177814
	.long	3219468930
	.long	2147483648
	.long	1014633195
	.long	2309668539
	.long	3218003836
	.long	0
	.long	3219128320
	.long	881650848
	.long	3219488105
	.long	2147483648
	.long	1015502624
	.long	2081278341
	.long	3217934237
	.long	0
	.long	3219128320
	.long	3194290572
	.long	3219507067
	.long	2147483648
	.long	3162532330
	.long	3753901657
	.long	3217863712
	.long	0
	.long	3219128320
	.long	1427975391
	.long	3219525815
	.long	1073741824
	.long	1014124979
	.long	1403691706
	.long	3217792273
	.long	0
	.long	3219128320
	.long	636516413
	.long	3219544345
	.long	3758096384
	.long	3163307364
	.long	2583490354
	.long	3217719929
	.long	0
	.long	3219128320
	.long	1719614413
	.long	3219562654
	.long	0
	.long	1015799092
	.long	2546065654
	.long	3217646692
	.long	0
	.long	3219128320
	.long	1424664751
	.long	3219580740
	.long	3221225472
	.long	1015921667
	.long	1416934267
	.long	3217572573
	.long	0
	.long	3219128320
	.long	938475414
	.long	3219598600
	.long	0
	.long	3162559727
	.long	4187227697
	.long	3217497582
	.long	0
	.long	3219128320
	.long	1594061409
	.long	3219616231
	.long	2147483648
	.long	3161837518
	.long	3526603391
	.long	3217421732
	.long	0
	.long	3219128320
	.long	577417135
	.long	3219633631
	.long	2684354560
	.long	1014035767
	.long	1250776663
	.long	3217345034
	.long	0
	.long	3219128320
	.long	3814135665
	.long	3219650796
	.long	3221225472
	.long	1015662808
	.long	4019165092
	.long	3217267498
	.long	0
	.long	3219128320
	.long	201299822
	.long	3219667726
	.long	3758096384
	.long	1014428704
	.long	1852581091
	.long	3217189138
	.long	0
	.long	3219128320
	.long	263859903
	.long	3219684416
	.long	0
	.long	1015208636
	.long	2485417816
	.long	3217109964
	.long	0
	.long	3219128320
	.long	1796544321
	.long	3219700864
	.long	536870912
	.long	1015203297
	.long	2586490530
	.long	3217028810
	.long	0
	.long	3219128320
	.long	2750387213
	.long	3219717068
	.long	2147483648
	.long	1013374889
	.long	1224902090
	.long	3216867281
	.long	0
	.long	3219128320
	.long	1234330619
	.long	3219733026
	.long	2684354560
	.long	3162756121
	.long	2285031318
	.long	3216704197
	.long	0
	.long	3219128320
	.long	4106737474
	.long	3219748734
	.long	2684354560
	.long	1015108729
	.long	3876290983
	.long	3216539583
	.long	0
	.long	3219128320
	.long	1207142209
	.long	3219764192
	.long	2147483648
	.long	1015221986
	.long	802660176
	.long	3216373465
	.long	0
	.long	3219128320
	.long	4012486548
	.long	3219779395
	.long	2684354560
	.long	3162185212
	.long	1726519029
	.long	3216205866
	.long	0
	.long	3219128320
	.long	2688952194
	.long	3219794343
	.long	0
	.long	1014048955
	.long	3382663878
	.long	3216036812
	.long	0
	.long	3219128320
	.long	453180130
	.long	3219809033
	.long	1073741824
	.long	1014927633
	.long	2598800519
	.long	3215750067
	.long	0
	.long	3219128320
	.long	688824739
	.long	3219823462
	.long	3758096384
	.long	3157915184
	.long	1038988426
	.long	3215406294
	.long	0
	.long	3219128320
	.long	2653017361
	.long	3219837628
	.long	0
	.long	1015316414
	.long	1102361128
	.long	3215059765
	.long	0
	.long	3219128320
	.long	1477771776
	.long	3219851530
	.long	536870912
	.long	1015621338
	.long	2880516564
	.long	3214487049
	.long	0
	.long	3219128320
	.long	1056266002
	.long	3219865165
	.long	2684354560
	.long	1015985848
	.long	1220541286
	.long	3213681126
	.long	0
	.long	3219128320
	.long	1159294526
	.long	3219878531
	.long	536870912
	.long	1015793311
	.long	1279178457
	.long	3211590791
	.long	0
	.long	3219128320
	.long	1731563730
	.long	3219891626
	.long	536870912
	.long	3163023950
	.long	31019393
	.long	1065162441
	.long	0
	.long	3219128320
	.long	2892993834
	.long	3219904448
	.long	536870912
	.long	1015555495
	.long	3506991783
	.long	1066548842
	.long	0
	.long	3219128320
	.long	645027145
	.long	3219916996
	.long	3221225472
	.long	3160085887
	.long	2140183630
	.long	1067272748
	.long	0
	.long	3219128320
	.long	4051746225
	.long	3219929266
	.long	1610612736
	.long	1014423729
	.long	600368053
	.long	1067725893
	.long	0
	.long	3219128320
	.long	881357723
	.long	3219941259
	.long	3221225472
	.long	3161294538
	.long	913431823
	.long	1068092555
	.long	0
	.long	3219128320
	.long	557060597
	.long	3219952971
	.long	0
	.long	1012071286
	.long	1073154251
	.long	1068461489
	.long	0
	.long	3219128320
	.long	4093443164
	.long	3219964400
	.long	536870912
	.long	3162396513
	.long	3631910143
	.long	1068665791
	.long	0
	.long	3219128320
	.long	4097623923
	.long	3219975546
	.long	2684354560
	.long	1012824939
	.long	1380647130
	.long	1068852447
	.long	0
	.long	3219128320
	.long	1950234076
	.long	3219986407
	.long	536870912
	.long	1011941850
	.long	4049357271
	.long	1069040154
	.long	0
	.long	3219128320
	.long	3511535930
	.long	3219996980
	.long	2147483648
	.long	1015344978
	.long	1896722595
	.long	1069228886
	.long	0
	.long	3219128320
	.long	1942611595
	.long	3220007265
	.long	3221225472
	.long	1014926433
	.long	1699043957
	.long	1069418613
	.long	0
	.long	3219128320
	.long	3476196678
	.long	3220017259
	.long	0
	.long	3161741286
	.long	3296146332
	.long	3216969380
	.long	0
	.long	3218079744
	.long	1647878299
	.long	3220026962
	.long	3758096384
	.long	1014685415
	.long	3286832763
	.long	3216777748
	.long	0
	.long	3218079744
	.long	3066872380
	.long	3220036371
	.long	3221225472
	.long	3163044919
	.long	1962712856
	.long	3216585207
	.long	0
	.long	3218079744
	.long	1647164971
	.long	3220045486
	.long	2147483648
	.long	1015354602
	.long	3601629044
	.long	3216391785
	.long	0
	.long	3218079744
	.long	83265253
	.long	3220054305
	.long	1610612736
	.long	1015026887
	.long	165911977
	.long	3216197513
	.long	0
	.long	3218079744
	.long	1261158782
	.long	3220062826
	.long	2147483648
	.long	3163195192
	.long	1348311045
	.long	3216002418
	.long	0
	.long	3218079744
	.long	3964199186
	.long	3220071048
	.long	3758096384
	.long	1013017430
	.long	386665102
	.long	3215630470
	.long	0
	.long	3218079744
	.long	2873938189
	.long	3220078971
	.long	1610612736
	.long	1014827774
	.long	1991047213
	.long	3215237169
	.long	0
	.long	3218079744
	.long	1455828442
	.long	3220086593
	.long	3758096384
	.long	3162988721
	.long	4107121629
	.long	3214750787
	.long	0
	.long	3218079744
	.long	3370060660
	.long	3220093912
	.long	1610612736
	.long	3162270860
	.long	723478390
	.long	3213958438
	.long	0
	.long	3218079744
	.long	3882371427
	.long	3220100928
	.long	2147483648
	.long	3162407623
	.long	2382326656
	.long	3212045827
	.long	0
	.long	3218079744
	.long	2749658050
	.long	3220107640
	.long	1610612736
	.long	3162910986
	.long	2614369450
	.long	1065140432
	.long	0
	.long	3218079744
	.long	4220661975
	.long	3220114046
	.long	3221225472
	.long	3161795706
	.long	3587565429
	.long	1066624384
	.long	0
	.long	3218079744
	.long	4151720666
	.long	3220120146
	.long	0
	.long	1015155896
	.long	2886567144
	.long	1067426796
	.long	0
	.long	3218079744
	.long	2892293513
	.long	3220125939
	.long	2684354560
	.long	1014856623
	.long	1765797566
	.long	1067840895
	.long	0
	.long	3218079744
	.long	990588717
	.long	3220131424
	.long	3758096384
	.long	1014558209
	.long	240740309
	.long	1068244255
	.long	0
	.long	3218079744
	.long	3489094832
	.long	3220136599
	.long	536870912
	.long	3161809431
	.long	2034433221
	.long	3215832935
	.long	0
	.long	3217031168
	.long	2745245815
	.long	3220141465
	.long	3221225472
	.long	3163049777
	.long	304938777
	.long	3215427665
	.long	0
	.long	3217031168
	.long	4201728937
	.long	3220146020
	.long	1610612736
	.long	3162157654
	.long	3299146087
	.long	3215021530
	.long	0
	.long	3217031168
	.long	617154971
	.long	3220150265
	.long	3758096384
	.long	1015950048
	.long	1953696209
	.long	3214295171
	.long	0
	.long	3217031168
	.long	2131272983
	.long	3220154197
	.long	3221225472
	.long	1015521448
	.long	3987691371
	.long	3213074188
	.long	0
	.long	3217031168
	.long	1905645377
	.long	3220157817
	.long	1610612736
	.long	3161571244
	.long	718380601
	.long	1063597621
	.long	0
	.long	3217031168
	.long	1893834707
	.long	3220161124
	.long	1610612736
	.long	3162631302
	.long	3272206680
	.long	1066288081
	.long	0
	.long	3217031168
	.long	4251821691
	.long	3220164117
	.long	2147483648
	.long	1014357359
	.long	257503056
	.long	1067164005
	.long	0
	.long	3217031168
	.long	2748392742
	.long	3220166797
	.long	536870912
	.long	1015578102
	.long	711626851
	.long	3214400320
	.long	0
	.long	3215982592
	.long	4240268041
	.long	3220169162
	.long	536870912
	.long	3161072611
	.long	2523975598
	.long	3213273348
	.long	0
	.long	3215982592
	.long	2902558778
	.long	3220171213
	.long	3221225472
	.long	3160744428
	.long	3237733378
	.long	1062425136
	.long	0
	.long	3215982592
	.long	1703834029
	.long	3220172949
	.long	3758096384
	.long	3162512012
	.long	1003003824
	.long	1066107496
	.long	0
	.long	3215982592
	.long	3816385918
	.long	3220174369
	.long	536870912
	.long	1013733308
	.long	2896342633
	.long	3212231467
	.long	0
	.long	3214934016
	.long	4026464093
	.long	3220175474
	.long	3221225472
	.long	1015592141
	.long	561145352
	.long	1065056936
	.long	0
	.long	3214934016
	.long	1619315981
	.long	3220176264
	.long	1073741824
	.long	1015100749
	.long	210035182
	.long	1064007864
	.long	0
	.long	3213885440
	.long	379294427
	.long	3220176738
	.long	3221225472
	.long	3162889635
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	3220176896
	.long	0
	.long	0
	.long	210035182
	.long	3211491512
	.long	0
	.long	1066401792
	.long	379294427
	.long	3220176738
	.long	3221225472
	.long	3162889635
	.long	561145352
	.long	3212540584
	.long	0
	.long	1067450368
	.long	1619315981
	.long	3220176264
	.long	1073741824
	.long	1015100749
	.long	2896342633
	.long	1064747819
	.long	0
	.long	1067450368
	.long	4026464093
	.long	3220175474
	.long	3221225472
	.long	1015592141
	.long	1003003824
	.long	3213591144
	.long	0
	.long	1068498944
	.long	3816385918
	.long	3220174369
	.long	536870912
	.long	1013733308
	.long	3237733378
	.long	3209908784
	.long	0
	.long	1068498944
	.long	1703834029
	.long	3220172949
	.long	3758096384
	.long	3162512012
	.long	2523975598
	.long	1065789700
	.long	0
	.long	1068498944
	.long	2902558778
	.long	3220171213
	.long	3221225472
	.long	3160744428
	.long	711626851
	.long	1066916672
	.long	0
	.long	1068498944
	.long	4240268041
	.long	3220169162
	.long	536870912
	.long	3161072611
	.long	257503056
	.long	3214647653
	.long	0
	.long	1069547520
	.long	2748392742
	.long	3220166797
	.long	536870912
	.long	1015578102
	.long	3272206680
	.long	3213771729
	.long	0
	.long	1069547520
	.long	4251821691
	.long	3220164117
	.long	2147483648
	.long	1014357359
	.long	718380601
	.long	3211081269
	.long	0
	.long	1069547520
	.long	1893834707
	.long	3220161124
	.long	1610612736
	.long	3162631302
	.long	3987691371
	.long	1065590540
	.long	0
	.long	1069547520
	.long	1905645377
	.long	3220157817
	.long	1610612736
	.long	3161571244
	.long	1953696209
	.long	1066811523
	.long	0
	.long	1069547520
	.long	2131272983
	.long	3220154197
	.long	3221225472
	.long	1015521448
	.long	3299146087
	.long	1067537882
	.long	0
	.long	1069547520
	.long	617154971
	.long	3220150265
	.long	3758096384
	.long	1015950048
	.long	304938777
	.long	1067944017
	.long	0
	.long	1069547520
	.long	4201728937
	.long	3220146020
	.long	1610612736
	.long	3162157654
	.long	2034433221
	.long	1068349287
	.long	0
	.long	1069547520
	.long	2745245815
	.long	3220141465
	.long	3221225472
	.long	3163049777
	.long	240740309
	.long	3215727903
	.long	0
	.long	1070596096
	.long	3489094832
	.long	3220136599
	.long	536870912
	.long	3161809431
	.long	1765797566
	.long	3215324543
	.long	0
	.long	1070596096
	.long	990588717
	.long	3220131424
	.long	3758096384
	.long	1014558209
	.long	2886567144
	.long	3214910444
	.long	0
	.long	1070596096
	.long	2892293513
	.long	3220125939
	.long	2684354560
	.long	1014856623
	.long	3587565429
	.long	3214108032
	.long	0
	.long	1070596096
	.long	4151720666
	.long	3220120146
	.long	0
	.long	1015155896
	.long	2614369450
	.long	3212624080
	.long	0
	.long	1070596096
	.long	4220661975
	.long	3220114046
	.long	3221225472
	.long	3161795706
	.long	2382326656
	.long	1064562179
	.long	0
	.long	1070596096
	.long	2749658050
	.long	3220107640
	.long	1610612736
	.long	3162910986
	.long	723478390
	.long	1066474790
	.long	0
	.long	1070596096
	.long	3882371427
	.long	3220100928
	.long	2147483648
	.long	3162407623
	.long	4107121629
	.long	1067267139
	.long	0
	.long	1070596096
	.long	3370060660
	.long	3220093912
	.long	1610612736
	.long	3162270860
	.long	1991047213
	.long	1067753521
	.long	0
	.long	1070596096
	.long	1455828442
	.long	3220086593
	.long	3758096384
	.long	3162988721
	.long	386665102
	.long	1068146822
	.long	0
	.long	1070596096
	.long	2873938189
	.long	3220078971
	.long	1610612736
	.long	1014827774
	.long	1348311045
	.long	1068518770
	.long	0
	.long	1070596096
	.long	3964199186
	.long	3220071048
	.long	3758096384
	.long	1013017430
	.long	165911977
	.long	1068713865
	.long	0
	.long	1070596096
	.long	1261158782
	.long	3220062826
	.long	2147483648
	.long	3163195192
	.long	3601629044
	.long	1068908137
	.long	0
	.long	1070596096
	.long	83265253
	.long	3220054305
	.long	1610612736
	.long	1015026887
	.long	1962712856
	.long	1069101559
	.long	0
	.long	1070596096
	.long	1647164971
	.long	3220045486
	.long	2147483648
	.long	1015354602
	.long	3286832763
	.long	1069294100
	.long	0
	.long	1070596096
	.long	3066872380
	.long	3220036371
	.long	3221225472
	.long	3163044919
	.long	3296146332
	.long	1069485732
	.long	0
	.long	1070596096
	.long	1647878299
	.long	3220026962
	.long	3758096384
	.long	1014685415
	.long	1699043957
	.long	3216902261
	.long	0
	.long	1071644672
	.long	3476196678
	.long	3220017259
	.long	0
	.long	3161741286
	.long	1896722595
	.long	3216712534
	.long	0
	.long	1071644672
	.long	1942611595
	.long	3220007265
	.long	3221225472
	.long	1014926433
	.long	4049357271
	.long	3216523802
	.long	0
	.long	1071644672
	.long	3511535930
	.long	3219996980
	.long	2147483648
	.long	1015344978
	.long	1380647130
	.long	3216336095
	.long	0
	.long	1071644672
	.long	1950234076
	.long	3219986407
	.long	536870912
	.long	1011941850
	.long	3631910143
	.long	3216149439
	.long	0
	.long	1071644672
	.long	4097623923
	.long	3219975546
	.long	2684354560
	.long	1012824939
	.long	1073154251
	.long	3215945137
	.long	0
	.long	1071644672
	.long	4093443164
	.long	3219964400
	.long	536870912
	.long	3162396513
	.long	913431823
	.long	3215576203
	.long	0
	.long	1071644672
	.long	557060597
	.long	3219952971
	.long	0
	.long	1012071286
	.long	600368053
	.long	3215209541
	.long	0
	.long	1071644672
	.long	881357723
	.long	3219941259
	.long	3221225472
	.long	3161294538
	.long	2140183630
	.long	3214756396
	.long	0
	.long	1071644672
	.long	4051746225
	.long	3219929266
	.long	1610612736
	.long	1014423729
	.long	3506991783
	.long	3214032490
	.long	0
	.long	1071644672
	.long	645027145
	.long	3219916996
	.long	3221225472
	.long	3160085887
	.long	31019393
	.long	3212646089
	.long	0
	.long	1071644672
	.long	2892993834
	.long	3219904448
	.long	536870912
	.long	1015555495
	.long	1279178457
	.long	1064107143
	.long	0
	.long	1071644672
	.long	1731563730
	.long	3219891626
	.long	536870912
	.long	3163023950
	.long	1220541286
	.long	1066197478
	.long	0
	.long	1071644672
	.long	1159294526
	.long	3219878531
	.long	536870912
	.long	1015793311
	.long	2880516564
	.long	1067003401
	.long	0
	.long	1071644672
	.long	1056266002
	.long	3219865165
	.long	2684354560
	.long	1015985848
	.long	1102361128
	.long	1067576117
	.long	0
	.long	1071644672
	.long	1477771776
	.long	3219851530
	.long	536870912
	.long	1015621338
	.long	1038988426
	.long	1067922646
	.long	0
	.long	1071644672
	.long	2653017361
	.long	3219837628
	.long	0
	.long	1015316414
	.long	2598800519
	.long	1068266419
	.long	0
	.long	1071644672
	.long	688824739
	.long	3219823462
	.long	3758096384
	.long	3157915184
	.long	3382663878
	.long	1068553164
	.long	0
	.long	1071644672
	.long	453180130
	.long	3219809033
	.long	1073741824
	.long	1014927633
	.long	1726519029
	.long	1068722218
	.long	0
	.long	1071644672
	.long	2688952194
	.long	3219794343
	.long	0
	.long	1014048955
	.long	802660176
	.long	1068889817
	.long	0
	.long	1071644672
	.long	4012486548
	.long	3219779395
	.long	2684354560
	.long	3162185212
	.long	3876290983
	.long	1069055935
	.long	0
	.long	1071644672
	.long	1207142209
	.long	3219764192
	.long	2147483648
	.long	1015221986
	.long	2285031318
	.long	1069220549
	.long	0
	.long	1071644672
	.long	4106737474
	.long	3219748734
	.long	2684354560
	.long	1015108729
	.long	1224902090
	.long	1069383633
	.long	0
	.long	1071644672
	.long	1234330619
	.long	3219733026
	.long	2684354560
	.long	3162756121
	.long	2586490530
	.long	1069545162
	.long	0
	.long	1071644672
	.long	2750387213
	.long	3219717068
	.long	2147483648
	.long	1013374889
	.long	2485417816
	.long	1069626316
	.long	0
	.long	1071644672
	.long	1796544321
	.long	3219700864
	.long	536870912
	.long	1015203297
	.long	1852581091
	.long	1069705490
	.long	0
	.long	1071644672
	.long	263859903
	.long	3219684416
	.long	0
	.long	1015208636
	.long	4019165092
	.long	1069783850
	.long	0
	.long	1071644672
	.long	201299822
	.long	3219667726
	.long	3758096384
	.long	1014428704
	.long	1250776663
	.long	1069861386
	.long	0
	.long	1071644672
	.long	3814135665
	.long	3219650796
	.long	3221225472
	.long	1015662808
	.long	3526603391
	.long	1069938084
	.long	0
	.long	1071644672
	.long	577417135
	.long	3219633631
	.long	2684354560
	.long	1014035767
	.long	4187227697
	.long	1070013934
	.long	0
	.long	1071644672
	.long	1594061409
	.long	3219616231
	.long	2147483648
	.long	3161837518
	.long	1416934267
	.long	1070088925
	.long	0
	.long	1071644672
	.long	938475414
	.long	3219598600
	.long	0
	.long	3162559727
	.long	2546065654
	.long	1070163044
	.long	0
	.long	1071644672
	.long	1424664751
	.long	3219580740
	.long	3221225472
	.long	1015921667
	.long	2583490354
	.long	1070236281
	.long	0
	.long	1071644672
	.long	1719614413
	.long	3219562654
	.long	0
	.long	1015799092
	.long	1403691706
	.long	1070308625
	.long	0
	.long	1071644672
	.long	636516413
	.long	3219544345
	.long	3758096384
	.long	3163307364
	.long	3753901657
	.long	1070380064
	.long	0
	.long	1071644672
	.long	1427975391
	.long	3219525815
	.long	1073741824
	.long	1014124979
	.long	2081278341
	.long	1070450589
	.long	0
	.long	1071644672
	.long	3194290572
	.long	3219507067
	.long	2147483648
	.long	3162532330
	.long	2309668539
	.long	1070520188
	.long	0
	.long	1071644672
	.long	881650848
	.long	3219488105
	.long	2147483648
	.long	1015502624
	.long	2371640770
	.long	1070588851
	.long	0
	.long	1071644672
	.long	2460177814
	.long	3219468930
	.long	2147483648
	.long	1014633195
	.long	3489768009
	.long	3218019271
	.long	0
	.long	1072693248
	.long	3152274921
	.long	3219449546
	.long	3758096384
	.long	3160654483
	.long	3239527685
	.long	3217952511
	.long	0
	.long	1072693248
	.long	2610628921
	.long	3219429956
	.long	1610612736
	.long	1015185121
	.long	1403757309
	.long	3217886718
	.long	0
	.long	1072693248
	.long	621354454
	.long	3219410163
	.long	536870912
	.long	3160934250
	.long	1883353036
	.long	3217821901
	.long	0
	.long	1072693248
	.long	1397053140
	.long	3219390169
	.long	1610612736
	.long	3162728726
	.long	3652612115
	.long	3217758070
	.long	0
	.long	1072693248
	.long	689983673
	.long	3219369978
	.long	3758096384
	.long	3162390053
	.long	752919289
	.long	3217695236
	.long	0
	.long	1072693248
	.long	2969983475
	.long	3219349592
	.long	2684354560
	.long	1015151795
	.long	3761365757
	.long	3217633406
	.long	0
	.long	1072693248
	.long	4242632757
	.long	3219329015
	.long	536870912
	.long	1013906630
	.long	1129922991
	.long	3217572592
	.long	0
	.long	1072693248
	.long	637203434
	.long	3219308251
	.long	3221225472
	.long	1011960193
	.long	2129093113
	.long	3217512801
	.long	0
	.long	1072693248
	.long	1289556703
	.long	3219287301
	.long	536870912
	.long	1015405172
	.long	2482246777
	.long	3217454043
	.long	0
	.long	1072693248
	.long	2570316633
	.long	3219266169
	.long	1610612736
	.long	1015261105
	.long	1539668340
	.long	3217396327
	.long	0
	.long	1072693248
	.long	967731400
	.long	3219244859
	.long	536870912
	.long	3163235805
	.long	2272832445
	.long	3217339661
	.long	0
	.long	1072693248
	.long	1675549513
	.long	3219223373
	.long	3221225472
	.long	1015541490
	.long	2678847490
	.long	3217284054
	.long	0
	.long	1072693248
	.long	1411074851
	.long	3219201715
	.long	1610612736
	.long	1016001083
	.long	69903290
	.long	3217229515
	.long	0
	.long	1072693248
	.long	1297975695
	.long	3219179888
	.long	3221225472
	.long	1015600087
	.long	3952756490
	.long	3217176050
	.long	0
	.long	1072693248
	.long	2569207790
	.long	3219157895
	.long	1073741824
	.long	1015699969
	.long	1663679671
	.long	3217123670
	.long	0
	.long	1072693248
	.long	2269920951
	.long	3219135740
	.long	3758096384
	.long	1014188597
	.long	1312926554
	.long	3217072381
	.long	0
	.long	1072693248
	.long	3690502842
	.long	3219098532
	.long	3221225472
	.long	1009970207
	.long	3429717432
	.long	3217013214
	.long	0
	.long	1072693248
	.long	1391425750
	.long	3219053593
	.long	3221225472
	.long	1014878455
	.long	1945768569
	.long	3216915048
	.long	0
	.long	1072693248
	.long	939980347
	.long	3219008349
	.long	0
	.long	3160280457
	.long	1539072807
	.long	3216819110
	.long	0
	.long	1072693248
	.long	1535566729
	.long	3218962807
	.long	2147483648
	.long	3161805036
	.long	4133449816
	.long	3216725414
	.long	0
	.long	1072693248
	.long	2570175582
	.long	3218916974
	.long	1073741824
	.long	3159786766
	.long	1612193054
	.long	3216633976
	.long	0
	.long	1072693248
	.long	3623952103
	.long	3218870857
	.long	2684354560
	.long	1014502314
	.long	1578746984
	.long	3216544808
	.long	0
	.long	1072693248
	.long	165764288
	.long	3218824464
	.long	3221225472
	.long	3160781666
	.long	1577996576
	.long	3216457924
	.long	0
	.long	1072693248
	.long	728580042
	.long	3218777800
	.long	1610612736
	.long	1014849296
	.long	1972483635
	.long	3216373337
	.long	0
	.long	1072693248
	.long	1135144330
	.long	3218730873
	.long	536870912
	.long	3160857217
	.long	1638976426
	.long	3216291060
	.long	0
	.long	1072693248
	.long	1673302999
	.long	3218683690
	.long	2147483648
	.long	3160835121
	.long	2255197647
	.long	3216211105
	.long	0
	.long	1072693248
	.long	2796464483
	.long	3218636258
	.long	3221225472
	.long	1013394669
	.long	3996842794
	.long	3216133484
	.long	0
	.long	1072693248
	.long	824036583
	.long	3218588585
	.long	0
	.long	3155796978
	.long	1234824733
	.long	3216058210
	.long	0
	.long	1072693248
	.long	821708191
	.long	3218540677
	.long	3758096384
	.long	1014254361
	.long	4002549419
	.long	3215985292
	.long	0
	.long	1072693248
	.long	3711903686
	.long	3218492541
	.long	1073741824
	.long	3159428395
	.long	2962723252
	.long	3215846895
	.long	0
	.long	1072693248
	.long	1974149085
	.long	3218444186
	.long	3221225472
	.long	1008664000
	.long	1296295961
	.long	3215710555
	.long	0
	.long	1072693248
	.long	1115219818
	.long	3218395618
	.long	0
	.long	3160555890
	.long	997322465
	.long	3215578993
	.long	0
	.long	1072693248
	.long	2484561409
	.long	3218346844
	.long	1073741824
	.long	3161508220
	.long	1261629236
	.long	3215452229
	.long	0
	.long	1072693248
	.long	3269558610
	.long	3218297872
	.long	536870912
	.long	1014221568
	.long	2476548698
	.long	3215330282
	.long	0
	.long	1072693248
	.long	785751814
	.long	3218248710
	.long	2684354560
	.long	1014354573
	.long	1913604284
	.long	3215213171
	.long	0
	.long	1072693248
	.long	1062001470
	.long	3218199364
	.long	0
	.long	1013391572
	.long	2306566604
	.long	3215100913
	.long	0
	.long	1072693248
	.long	1655830135
	.long	3218149842
	.long	0
	.long	3161990338
	.long	3250111450
	.long	3214993525
	.long	0
	.long	1072693248
	.long	238550446
	.long	3218100152
	.long	2684354560
	.long	1006899917
	.long	2377770267
	.long	3214848032
	.long	0
	.long	1072693248
	.long	2065784603
	.long	3218020857
	.long	3758096384
	.long	1013198318
	.long	288924873
	.long	3214652833
	.long	0
	.long	1072693248
	.long	3846521617
	.long	3217920847
	.long	536870912
	.long	3160890258
	.long	1935888103
	.long	3214467466
	.long	0
	.long	1072693248
	.long	1786662755
	.long	3217820546
	.long	2147483648
	.long	1008398659
	.long	2660899430
	.long	3214291960
	.long	0
	.long	1072693248
	.long	632292433
	.long	3217719968
	.long	3758096384
	.long	1013479685
	.long	18115067
	.long	3214126342
	.long	0
	.long	1072693248
	.long	1013556747
	.long	3217619128
	.long	2684354560
	.long	1013083417
	.long	2346447124
	.long	3213970635
	.long	0
	.long	1072693248
	.long	3729833777
	.long	3217518041
	.long	3758096384
	.long	3160528366
	.long	1672287667
	.long	3213764289
	.long	0
	.long	1072693248
	.long	1149976518
	.long	3217416724
	.long	1610612736
	.long	3160748543
	.long	3451754846
	.long	3213492662
	.long	0
	.long	1072693248
	.long	2972270170
	.long	3217315190
	.long	1073741824
	.long	1012041122
	.long	1037482584
	.long	3213240992
	.long	0
	.long	1072693248
	.long	1854824762
	.long	3217213456
	.long	2684354560
	.long	3159437312
	.long	2592747447
	.long	3213009315
	.long	0
	.long	1072693248
	.long	3470456183
	.long	3217111536
	.long	1073741824
	.long	1013261123
	.long	2402293340
	.long	3212758471
	.long	0
	.long	1072693248
	.long	1453945614
	.long	3216987726
	.long	1610612736
	.long	3158976260
	.long	1227670166
	.long	3212375297
	.long	0
	.long	1072693248
	.long	3349070549
	.long	3216783237
	.long	3758096384
	.long	1009054621
	.long	393047345
	.long	3212032302
	.long	0
	.long	1072693248
	.long	3156849708
	.long	3216578470
	.long	3221225472
	.long	1010706200
	.long	1118107366
	.long	3211670787
	.long	0
	.long	1072693248
	.long	177906713
	.long	3216373456
	.long	3221225472
	.long	1011826722
	.long	4269262315
	.long	3211145810
	.long	0
	.long	1072693248
	.long	2462980598
	.long	3216168224
	.long	2684354560
	.long	1011458184
	.long	3810305407
	.long	3210663220
	.long	0
	.long	1072693248
	.long	2046304480
	.long	3215943022
	.long	3758096384
	.long	1008919019
	.long	220529721
	.long	3209935929
	.long	0
	.long	1072693248
	.long	4044216340
	.long	3215531877
	.long	0
	.long	1009324733
	.long	69373323
	.long	3209049152
	.long	0
	.long	1072693248
	.long	1972655565
	.long	3215120485
	.long	1073741824
	.long	3156641526
	.long	3650591271
	.long	3207838971
	.long	0
	.long	1072693248
	.long	4154680958
	.long	3214483797
	.long	0
	.long	1006312803
	.long	2376373521
	.long	3205741868
	.long	0
	.long	1072693248
	.long	4242458500
	.long	3213435345
	.long	2684354560
	.long	3156838286
	.long	4294967295
	.long	2147483647
	.long	4294967295
	.long	2147483647
	.long	4294967295
	.long	2147483647
	.long	4294967295
	.long	2147483647
	.long	4294967295
	.long	2147483647
	.long	4294967295
	.long	2147483647
	.long	4294967295
	.long	2147483647
	.long	4294967295
	.long	2147483647
	.long	239972940
	.long	1089470464
	.long	239972940
	.long	1089470464
	.long	239972940
	.long	1089470464
	.long	239972940
	.long	1089470464
	.long	239972940
	.long	1089470464
	.long	239972940
	.long	1089470464
	.long	239972940
	.long	1089470464
	.long	239972940
	.long	1089470464
	.long	0
	.long	2146435072
	.long	0
	.long	2146435072
	.long	0
	.long	2146435072
	.long	0
	.long	2146435072
	.long	0
	.long	2146435072
	.long	0
	.long	2146435072
	.long	0
	.long	2146435072
	.long	0
	.long	2146435072
	.long	1841940611
	.long	1079271216
	.long	1841940611
	.long	1079271216
	.long	1841940611
	.long	1079271216
	.long	1841940611
	.long	1079271216
	.long	1841940611
	.long	1079271216
	.long	1841940611
	.long	1079271216
	.long	1841940611
	.long	1079271216
	.long	1841940611
	.long	1079271216
	.long	0
	.long	1127743488
	.long	0
	.long	1127743488
	.long	0
	.long	1127743488
	.long	0
	.long	1127743488
	.long	0
	.long	1127743488
	.long	0
	.long	1127743488
	.long	0
	.long	1127743488
	.long	0
	.long	1127743488
	.long	511
	.long	0
	.long	511
	.long	0
	.long	511
	.long	0
	.long	511
	.long	0
	.long	511
	.long	0
	.long	511
	.long	0
	.long	511
	.long	0
	.long	511
	.long	0
	.long	1413480448
	.long	1065951739
	.long	1413480448
	.long	1065951739
	.long	1413480448
	.long	1065951739
	.long	1413480448
	.long	1065951739
	.long	1413480448
	.long	1065951739
	.long	1413480448
	.long	1065951739
	.long	1413480448
	.long	1065951739
	.long	1413480448
	.long	1065951739
	.long	442499072
	.long	1029747809
	.long	442499072
	.long	1029747809
	.long	442499072
	.long	1029747809
	.long	442499072
	.long	1029747809
	.long	442499072
	.long	1029747809
	.long	442499072
	.long	1029747809
	.long	442499072
	.long	1029747809
	.long	442499072
	.long	1029747809
	.long	771977331
	.long	993204618
	.long	771977331
	.long	993204618
	.long	771977331
	.long	993204618
	.long	771977331
	.long	993204618
	.long	771977331
	.long	993204618
	.long	771977331
	.long	993204618
	.long	771977331
	.long	993204618
	.long	771977331
	.long	993204618
	.long	1431651400
	.long	3217380693
	.long	1431651400
	.long	3217380693
	.long	1431651400
	.long	3217380693
	.long	1431651400
	.long	3217380693
	.long	1431651400
	.long	3217380693
	.long	1431651400
	.long	3217380693
	.long	1431651400
	.long	3217380693
	.long	1431651400
	.long	3217380693
	.long	2880656668
	.long	1065423119
	.long	2880656668
	.long	1065423119
	.long	2880656668
	.long	1065423119
	.long	2880656668
	.long	1065423119
	.long	2880656668
	.long	1065423119
	.long	2880656668
	.long	1065423119
	.long	2880656668
	.long	1065423119
	.long	2880656668
	.long	1065423119
	.long	0
	.long	3219128320
	.long	0
	.long	3219128320
	.long	0
	.long	3219128320
	.long	0
	.long	3219128320
	.long	0
	.long	3219128320
	.long	0
	.long	3219128320
	.long	0
	.long	3219128320
	.long	0
	.long	3219128320
	.long	1431653583
	.long	1067799893
	.long	1431653583
	.long	1067799893
	.long	1431653583
	.long	1067799893
	.long	1431653583
	.long	1067799893
	.long	1431653583
	.long	1067799893
	.long	1431653583
	.long	1067799893
	.long	1431653583
	.long	1067799893
	.long	1431653583
	.long	1067799893
	.long	2976101079
	.long	3210133866
	.long	2976101079
	.long	3210133866
	.long	2976101079
	.long	3210133866
	.long	2976101079
	.long	3210133866
	.long	2976101079
	.long	3210133866
	.long	2976101079
	.long	3210133866
	.long	2976101079
	.long	3210133866
	.long	2976101079
	.long	3210133866
	.type	__svml_dsin_data_internal_ha,@object
	.size	__svml_dsin_data_internal_ha,17280
	.align 64
__svml_dsin_reduction_data_internal:
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	1
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	2
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	5
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	10
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	20
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	40
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	81
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	162
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	325
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	651
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	1303
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	2607
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	5215
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	10430
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	20860
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	41721
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	83443
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	166886
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	333772
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	667544
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	1335088
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	2670176
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	5340353
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	10680707
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	21361414
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	42722829
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	85445659
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	170891318
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	341782637
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	683565275
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	1367130551
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	2734261102
	.long	0
	.long	0
	.long	0
	.long	0
	.long	0
	.long	1173554908
	.long	1
	.long	0
	.long	0
	.long	0
	.long	0
	.long	2347109817
	.long	2
	.long	0
	.long	0
	.long	0
	.long	0
	.long	399252338
	.long	5
	.long	0
	.long	0
	.long	0
	.long	0
	.long	798504676
	.long	10
	.long	0
	.long	0
	.long	0
	.long	0
	.long	1597009353
	.long	20
	.long	0
	.long	0
	.long	0
	.long	0
	.long	3194018707
	.long	40
	.long	0
	.long	0
	.long	0
	.long	0
	.long	2093070119
	.long	81
	.long	0
	.long	0
	.long	0
	.long	0
	.long	4186140238
	.long	162
	.long	0
	.long	0
	.long	0
	.long	0
	.long	4077313180
	.long	325
	.long	0
	.long	0
	.long	0
	.long	0
	.long	3859659065
	.long	651
	.long	0
	.long	0
	.long	0
	.long	0
	.long	3424350834
	.long	1303
	.long	0
	.long	0
	.long	0
	.long	0
	.long	2553734372
	.long	2607
	.long	0
	.long	0
	.long	0
	.long	0
	.long	812501448
	.long	5215
	.long	0
	.long	0
	.long	0
	.long	0
	.long	1625002897
	.long	10430
	.long	0
	.long	0
	.long	0
	.long	0
	.long	3250005794
	.long	20860
	.long	0
	.long	0
	.long	0
	.long	0
	.long	2205044292
	.long	41721
	.long	0
	.long	0
	.long	0
	.long	0
	.long	115121288
	.long	83443
	.long	0
	.long	0
	.long	0
	.long	0
	.long	230242576
	.long	166886
	.long	0
	.long	0
	.long	0
	.long	0
	.long	460485152
	.long	333772
	.long	0
	.long	0
	.long	0
	.long	0
	.long	920970305
	.long	667544
	.long	0
	.long	0
	.long	0
	.long	0
	.long	1841940610
	.long	1335088
	.long	0
	.long	0
	.long	0
	.long	0
	.long	3683881221
	.long	2670176
	.long	0
	.long	0
	.long	0
	.long	0
	.long	3072795146
	.long	5340353
	.long	0
	.long	0
	.long	0
	.long	0
	.long	1850622997
	.long	10680707
	.long	0
	.long	0
	.long	0
	.long	0
	.long	3701245994
	.long	21361414
	.long	0
	.long	0
	.long	0
	.long	0
	.long	3107524692
	.long	42722829
	.long	0
	.long	0
	.long	0
	.long	0
	.long	1920082089
	.long	85445659
	.long	0
	.long	0
	.long	0
	.long	0
	.long	3840164178
	.long	170891318
	.long	0
	.long	0
	.long	0
	.long	0
	.long	3385361061
	.long	341782637
	.long	0
	.long	0
	.long	0
	.long	0
	.long	2475754826
	.long	683565275
	.long	0
	.long	0
	.long	0
	.long	0
	.long	656542356
	.long	1367130551
	.long	0
	.long	0
	.long	0
	.long	0
	.long	1313084713
	.long	2734261102
	.long	0
	.long	0
	.long	1
	.long	0
	.long	2626169427
	.long	1173554908
	.long	0
	.long	0
	.long	2
	.long	0
	.long	957371559
	.long	2347109817
	.long	0
	.long	0
	.long	5
	.long	0
	.long	1914743119
	.long	399252338
	.long	0
	.long	0
	.long	10
	.long	0
	.long	3829486239
	.long	798504676
	.long	0
	.long	0
	.long	20
	.long	0
	.long	3364005183
	.long	1597009353
	.long	0
	.long	0
	.long	40
	.long	0
	.long	2433043071
	.long	3194018707
	.long	0
	.long	0
	.long	81
	.long	0
	.long	571118846
	.long	2093070119
	.long	0
	.long	0
	.long	162
	.long	0
	.long	1142237692
	.long	4186140238
	.long	0
	.long	0
	.long	325
	.long	0
	.long	2284475384
	.long	4077313180
	.long	0
	.long	0
	.long	651
	.long	0
	.long	273983472
	.long	3859659065
	.long	0
	.long	0
	.long	1303
	.long	0
	.long	547966945
	.long	3424350834
	.long	0
	.long	0
	.long	2607
	.long	0
	.long	1095933890
	.long	2553734372
	.long	0
	.long	0
	.long	5215
	.long	0
	.long	2191867780
	.long	812501448
	.long	0
	.long	0
	.long	10430
	.long	0
	.long	88768265
	.long	1625002897
	.long	0
	.long	0
	.long	20860
	.long	0
	.long	177536531
	.long	3250005794
	.long	0
	.long	0
	.long	41721
	.long	0
	.long	355073063
	.long	2205044292
	.long	0
	.long	0
	.long	83443
	.long	0
	.long	710146126
	.long	115121288
	.long	0
	.long	0
	.long	166886
	.long	0
	.long	1420292253
	.long	230242576
	.long	0
	.long	0
	.long	333772
	.long	0
	.long	2840584506
	.long	460485152
	.long	0
	.long	0
	.long	667544
	.long	0
	.long	1386201717
	.long	920970305
	.long	0
	.long	0
	.long	1335088
	.long	0
	.long	2772403434
	.long	1841940610
	.long	0
	.long	0
	.long	2670176
	.long	0
	.long	1249839573
	.long	3683881221
	.long	0
	.long	0
	.long	5340353
	.long	0
	.long	2499679147
	.long	3072795146
	.long	0
	.long	0
	.long	10680707
	.long	0
	.long	704390999
	.long	1850622997
	.long	0
	.long	0
	.long	21361414
	.long	0
	.long	1408781999
	.long	3701245994
	.long	0
	.long	0
	.long	42722829
	.long	0
	.long	2817563999
	.long	3107524692
	.long	0
	.long	0
	.long	85445659
	.long	0
	.long	1340160702
	.long	1920082089
	.long	0
	.long	0
	.long	170891318
	.long	0
	.long	2680321405
	.long	3840164178
	.long	0
	.long	0
	.long	341782637
	.long	0
	.long	1065675514
	.long	3385361061
	.long	0
	.long	0
	.long	683565275
	.long	0
	.long	2131351028
	.long	2475754826
	.long	0
	.long	0
	.long	1367130551
	.long	0
	.long	4262702056
	.long	656542356
	.long	0
	.long	0
	.long	2734261102
	.long	0
	.long	4230436817
	.long	1313084713
	.long	0
	.long	0
	.long	1173554908
	.long	1
	.long	4165906339
	.long	2626169427
	.long	0
	.long	0
	.long	2347109817
	.long	2
	.long	4036845383
	.long	957371559
	.long	0
	.long	0
	.long	399252338
	.long	5
	.long	3778723471
	.long	1914743119
	.long	0
	.long	0
	.long	798504676
	.long	10
	.long	3262479647
	.long	3829486239
	.long	0
	.long	0
	.long	1597009353
	.long	20
	.long	2229991998
	.long	3364005183
	.long	0
	.long	0
	.long	3194018707
	.long	40
	.long	165016701
	.long	2433043071
	.long	0
	.long	0
	.long	2093070119
	.long	81
	.long	330033402
	.long	571118846
	.long	0
	.long	0
	.long	4186140238
	.long	162
	.long	660066805
	.long	1142237692
	.long	0
	.long	0
	.long	4077313180
	.long	325
	.long	1320133610
	.long	2284475384
	.long	0
	.long	0
	.long	3859659065
	.long	651
	.long	2640267220
	.long	273983472
	.long	0
	.long	0
	.long	3424350834
	.long	1303
	.long	985567145
	.long	547966945
	.long	0
	.long	0
	.long	2553734372
	.long	2607
	.long	1971134291
	.long	1095933890
	.long	0
	.long	0
	.long	812501448
	.long	5215
	.long	3942268582
	.long	2191867780
	.long	0
	.long	0
	.long	1625002897
	.long	10430
	.long	3589569869
	.long	88768265
	.long	0
	.long	0
	.long	3250005794
	.long	20860
	.long	2884172442
	.long	177536531
	.long	0
	.long	0
	.long	2205044292
	.long	41721
	.long	1473377588
	.long	355073063
	.long	0
	.long	0
	.long	115121288
	.long	83443
	.long	2946755177
	.long	710146126
	.long	0
	.long	0
	.long	230242576
	.long	166886
	.long	1598543059
	.long	1420292253
	.long	0
	.long	0
	.long	460485152
	.long	333772
	.long	3197086118
	.long	2840584506
	.long	0
	.long	0
	.long	920970305
	.long	667544
	.long	2099204941
	.long	1386201717
	.long	0
	.long	0
	.long	1841940610
	.long	1335088
	.long	4198409883
	.long	2772403434
	.long	0
	.long	0
	.long	3683881221
	.long	2670176
	.long	4101852471
	.long	1249839573
	.long	0
	.long	0
	.long	3072795146
	.long	5340353
	.long	3908737646
	.long	2499679147
	.long	0
	.long	0
	.long	1850622997
	.long	10680707
	.long	3522507997
	.long	704390999
	.long	0
	.long	0
	.long	3701245994
	.long	21361414
	.long	2750048699
	.long	1408781999
	.long	0
	.long	0
	.long	3107524692
	.long	42722829
	.long	1205130103
	.long	2817563999
	.long	0
	.long	0
	.long	1920082089
	.long	85445659
	.long	2410260206
	.long	1340160702
	.long	0
	.long	0
	.long	3840164178
	.long	170891318
	.long	525553116
	.long	2680321405
	.long	0
	.long	0
	.long	3385361061
	.long	341782637
	.long	1051106232
	.long	1065675514
	.long	0
	.long	0
	.long	2475754826
	.long	683565275
	.long	2102212464
	.long	2131351028
	.long	0
	.long	0
	.long	656542356
	.long	1367130551
	.long	4204424928
	.long	4262702056
	.long	0
	.long	0
	.long	1313084713
	.long	2734261102
	.long	4113882560
	.long	4230436817
	.long	1
	.long	0
	.long	2626169427
	.long	1173554908
	.long	3932797825
	.long	4165906339
	.long	2
	.long	0
	.long	957371559
	.long	2347109817
	.long	3570628355
	.long	4036845383
	.long	5
	.long	0
	.long	1914743119
	.long	399252338
	.long	2846289414
	.long	3778723471
	.long	10
	.long	0
	.long	3829486239
	.long	798504676
	.long	1397611533
	.long	3262479647
	.long	20
	.long	0
	.long	3364005183
	.long	1597009353
	.long	2795223067
	.long	2229991998
	.long	40
	.long	0
	.long	2433043071
	.long	3194018707
	.long	1295478838
	.long	165016701
	.long	81
	.long	0
	.long	571118846
	.long	2093070119
	.long	2590957677
	.long	330033402
	.long	162
	.long	0
	.long	1142237692
	.long	4186140238
	.long	886948059
	.long	660066805
	.long	325
	.long	0
	.long	2284475384
	.long	4077313180
	.long	1773896118
	.long	1320133610
	.long	651
	.long	0
	.long	273983472
	.long	3859659065
	.long	3547792237
	.long	2640267220
	.long	1303
	.long	0
	.long	547966945
	.long	3424350834
	.long	2800617179
	.long	985567145
	.long	2607
	.long	0
	.long	1095933890
	.long	2553734372
	.long	1306267062
	.long	1971134291
	.long	5215
	.long	0
	.long	2191867780
	.long	812501448
	.long	2612534124
	.long	3942268582
	.long	10430
	.long	0
	.long	88768265
	.long	1625002897
	.long	930100952
	.long	3589569869
	.long	20860
	.long	0
	.long	177536531
	.long	3250005794
	.long	1860201905
	.long	2884172442
	.long	41721
	.long	0
	.long	355073063
	.long	2205044292
	.long	3720403810
	.long	1473377588
	.long	83443
	.long	0
	.long	710146126
	.long	115121288
	.long	3145840325
	.long	2946755177
	.long	166886
	.long	0
	.long	1420292253
	.long	230242576
	.long	1996713354
	.long	1598543059
	.long	333772
	.long	0
	.long	2840584506
	.long	460485152
	.long	3993426708
	.long	3197086118
	.long	667544
	.long	0
	.long	1386201717
	.long	920970305
	.long	3691886121
	.long	2099204941
	.long	1335088
	.long	0
	.long	2772403434
	.long	1841940610
	.long	3088804946
	.long	4198409883
	.long	2670176
	.long	0
	.long	1249839573
	.long	3683881221
	.long	1882642597
	.long	4101852471
	.long	5340353
	.long	0
	.long	2499679147
	.long	3072795146
	.long	3765285194
	.long	3908737646
	.long	10680707
	.long	0
	.long	704390999
	.long	1850622997
	.long	3235603093
	.long	3522507997
	.long	21361414
	.long	0
	.long	1408781999
	.long	3701245994
	.long	2176238891
	.long	2750048699
	.long	42722829
	.long	0
	.long	2817563999
	.long	3107524692
	.long	57510486
	.long	1205130103
	.long	85445659
	.long	0
	.long	1340160702
	.long	1920082089
	.long	115020972
	.long	2410260206
	.long	170891318
	.long	0
	.long	2680321405
	.long	3840164178
	.long	230041945
	.long	525553116
	.long	341782637
	.long	0
	.long	1065675514
	.long	3385361061
	.long	460083891
	.long	1051106232
	.long	683565275
	.long	0
	.long	2131351028
	.long	2475754826
	.long	920167782
	.long	2102212464
	.long	1367130551
	.long	0
	.long	4262702056
	.long	656542356
	.long	1840335564
	.long	4204424928
	.long	2734261102
	.long	0
	.long	4230436817
	.long	1313084713
	.long	3680671129
	.long	4113882560
	.long	1173554908
	.long	1
	.long	4165906339
	.long	2626169427
	.long	3066374962
	.long	3932797825
	.long	2347109817
	.long	2
	.long	4036845383
	.long	957371559
	.long	1837782628
	.long	3570628355
	.long	399252338
	.long	5
	.long	3778723471
	.long	1914743119
	.long	3675565257
	.long	2846289414
	.long	798504676
	.long	10
	.long	3262479647
	.long	3829486239
	.long	3056163219
	.long	1397611533
	.long	1597009353
	.long	20
	.long	2229991998
	.long	3364005183
	.long	1817359143
	.long	2795223067
	.long	3194018707
	.long	40
	.long	165016701
	.long	2433043071
	.long	3634718287
	.long	1295478838
	.long	2093070119
	.long	81
	.long	330033402
	.long	571118846
	.long	2974469278
	.long	2590957677
	.long	4186140238
	.long	162
	.long	660066805
	.long	1142237692
	.long	1653971260
	.long	886948059
	.long	4077313180
	.long	325
	.long	1320133610
	.long	2284475384
	.long	3307942520
	.long	1773896118
	.long	3859659065
	.long	651
	.long	2640267220
	.long	273983472
	.long	2320917745
	.long	3547792237
	.long	3424350834
	.long	1303
	.long	985567145
	.long	547966945
	.long	346868194
	.long	2800617179
	.long	2553734372
	.long	2607
	.long	1971134291
	.long	1095933890
	.long	693736388
	.long	1306267062
	.long	812501448
	.long	5215
	.long	3942268582
	.long	2191867780
	.long	1387472776
	.long	2612534124
	.long	1625002897
	.long	10430
	.long	3589569869
	.long	88768265
	.long	2774945552
	.long	930100952
	.long	3250005794
	.long	20860
	.long	2884172442
	.long	177536531
	.long	1254923809
	.long	1860201905
	.long	2205044292
	.long	41721
	.long	1473377588
	.long	355073063
	.long	2509847619
	.long	3720403810
	.long	115121288
	.long	83443
	.long	2946755177
	.long	710146126
	.long	724727943
	.long	3145840325
	.long	230242576
	.long	166886
	.long	1598543059
	.long	1420292253
	.long	1449455886
	.long	1996713354
	.long	460485152
	.long	333772
	.long	3197086118
	.long	2840584506
	.long	2898911772
	.long	3993426708
	.long	920970305
	.long	667544
	.long	2099204941
	.long	1386201717
	.long	1502856249
	.long	3691886121
	.long	1841940610
	.long	1335088
	.long	4198409883
	.long	2772403434
	.long	3005712498
	.long	3088804946
	.long	3683881221
	.long	2670176
	.long	4101852471
	.long	1249839573
	.long	1716457700
	.long	1882642597
	.long	3072795146
	.long	5340353
	.long	3908737646
	.long	2499679147
	.long	3432915400
	.long	3765285194
	.long	1850622997
	.long	10680707
	.long	3522507997
	.long	704390999
	.long	2570863504
	.long	3235603093
	.long	3701245994
	.long	21361414
	.long	2750048699
	.long	1408781999
	.long	846759712
	.long	2176238891
	.long	3107524692
	.long	42722829
	.long	1205130103
	.long	2817563999
	.long	1693519425
	.long	57510486
	.long	1920082089
	.long	85445659
	.long	2410260206
	.long	1340160702
	.long	3387038850
	.long	115020972
	.long	3840164178
	.long	170891318
	.long	525553116
	.long	2680321405
	.long	2479110404
	.long	230041945
	.long	3385361061
	.long	341782637
	.long	1051106232
	.long	1065675514
	.long	663253512
	.long	460083891
	.long	2475754826
	.long	683565275
	.long	2102212464
	.long	2131351028
	.long	1326507024
	.long	920167782
	.long	656542356
	.long	1367130551
	.long	4204424928
	.long	4262702056
	.long	2653014048
	.long	1840335564
	.long	1313084713
	.long	2734261102
	.long	4113882560
	.long	4230436817
	.long	1011060801
	.long	3680671129
	.long	2626169427
	.long	1173554908
	.long	3932797825
	.long	4165906339
	.long	2022121603
	.long	3066374962
	.long	957371559
	.long	2347109817
	.long	3570628355
	.long	4036845383
	.long	4044243207
	.long	1837782628
	.long	1914743119
	.long	399252338
	.long	2846289414
	.long	3778723471
	.long	3793519119
	.long	3675565257
	.long	3829486239
	.long	798504676
	.long	1397611533
	.long	3262479647
	.long	3292070943
	.long	3056163219
	.long	3364005183
	.long	1597009353
	.long	2795223067
	.long	2229991998
	.long	2289174591
	.long	1817359143
	.long	2433043071
	.long	3194018707
	.long	1295478838
	.long	165016701
	.long	283381887
	.long	3634718287
	.long	571118846
	.long	2093070119
	.long	2590957677
	.long	330033402
	.long	566763775
	.long	2974469278
	.long	1142237692
	.long	4186140238
	.long	886948059
	.long	660066805
	.long	1133527550
	.long	1653971260
	.long	2284475384
	.long	4077313180
	.long	1773896118
	.long	1320133610
	.long	2267055100
	.long	3307942520
	.long	273983472
	.long	3859659065
	.long	3547792237
	.long	2640267220
	.long	239142905
	.long	2320917745
	.long	547966945
	.long	3424350834
	.long	2800617179
	.long	985567145
	.long	478285810
	.long	346868194
	.long	1095933890
	.long	2553734372
	.long	1306267062
	.long	1971134291
	.long	956571621
	.long	693736388
	.long	2191867780
	.long	812501448
	.long	2612534124
	.long	3942268582
	.long	1913143242
	.long	1387472776
	.long	88768265
	.long	1625002897
	.long	930100952
	.long	3589569869
	.long	3826286484
	.long	2774945552
	.long	177536531
	.long	3250005794
	.long	1860201905
	.long	2884172442
	.long	3357605672
	.long	1254923809
	.long	355073063
	.long	2205044292
	.long	3720403810
	.long	1473377588
	.long	2420244049
	.long	2509847619
	.long	710146126
	.long	115121288
	.long	3145840325
	.long	2946755177
	.long	545520802
	.long	724727943
	.long	1420292253
	.long	230242576
	.long	1996713354
	.long	1598543059
	.long	1091041605
	.long	1449455886
	.long	2840584506
	.long	460485152
	.long	3993426708
	.long	3197086118
	.long	2182083211
	.long	2898911772
	.long	1386201717
	.long	920970305
	.long	3691886121
	.long	2099204941
	.long	69199126
	.long	1502856249
	.long	2772403434
	.long	1841940610
	.long	3088804946
	.long	4198409883
	.long	138398252
	.long	3005712498
	.long	1249839573
	.long	3683881221
	.long	1882642597
	.long	4101852471
	.long	276796504
	.long	1716457700
	.long	2499679147
	.long	3072795146
	.long	3765285194
	.long	3908737646
	.long	553593009
	.long	3432915400
	.long	704390999
	.long	1850622997
	.long	3235603093
	.long	3522507997
	.long	1107186019
	.long	2570863504
	.long	1408781999
	.long	3701245994
	.long	2176238891
	.long	2750048699
	.long	2214372039
	.long	846759712
	.long	2817563999
	.long	3107524692
	.long	57510486
	.long	1205130103
	.long	133776782
	.long	1693519425
	.long	1340160702
	.long	1920082089
	.long	115020972
	.long	2410260206
	.long	267553565
	.long	3387038850
	.long	2680321405
	.long	3840164178
	.long	230041945
	.long	525553116
	.long	535107130
	.long	2479110404
	.long	1065675514
	.long	3385361061
	.long	460083891
	.long	1051106232
	.long	1070214261
	.long	663253512
	.long	2131351028
	.long	2475754826
	.long	920167782
	.long	2102212464
	.long	2140428522
	.long	1326507024
	.long	4262702056
	.long	656542356
	.long	1840335564
	.long	4204424928
	.long	4280857045
	.long	2653014048
	.long	4230436817
	.long	1313084713
	.long	3680671129
	.long	4113882560
	.long	4266746795
	.long	1011060801
	.long	4165906339
	.long	2626169427
	.long	3066374962
	.long	3932797825
	.long	4238526295
	.long	2022121603
	.long	4036845383
	.long	957371559
	.long	1837782628
	.long	3570628355
	.long	4182085295
	.long	4044243207
	.long	3778723471
	.long	1914743119
	.long	3675565257
	.long	2846289414
	.long	4069203294
	.long	3793519119
	.long	3262479647
	.long	3829486239
	.long	3056163219
	.long	1397611533
	.long	3843439293
	.long	3292070943
	.long	2229991998
	.long	3364005183
	.long	1817359143
	.long	2795223067
	.long	3391911291
	.long	2289174591
	.long	165016701
	.long	2433043071
	.long	3634718287
	.long	1295478838
	.long	2488855287
	.long	283381887
	.long	330033402
	.long	571118846
	.long	2974469278
	.long	2590957677
	.long	682743279
	.long	566763775
	.long	660066805
	.long	1142237692
	.long	1653971260
	.long	886948059
	.long	1365486558
	.long	1133527550
	.long	1320133610
	.long	2284475384
	.long	3307942520
	.long	1773896118
	.long	2730973117
	.long	2267055100
	.long	2640267220
	.long	273983472
	.long	2320917745
	.long	3547792237
	.long	1166978938
	.long	239142905
	.long	985567145
	.long	547966945
	.long	346868194
	.long	2800617179
	.long	2333957877
	.long	478285810
	.long	1971134291
	.long	1095933890
	.long	693736388
	.long	1306267062
	.long	372948459
	.long	956571621
	.long	3942268582
	.long	2191867780
	.long	1387472776
	.long	2612534124
	.long	745896919
	.long	1913143242
	.long	3589569869
	.long	88768265
	.long	2774945552
	.long	930100952
	.long	1491793838
	.long	3826286484
	.long	2884172442
	.long	177536531
	.long	1254923809
	.long	1860201905
	.long	2983587677
	.long	3357605672
	.long	1473377588
	.long	355073063
	.long	2509847619
	.long	3720403810
	.long	1672208059
	.long	2420244049
	.long	2946755177
	.long	710146126
	.long	724727943
	.long	3145840325
	.long	3344416119
	.long	545520802
	.long	1598543059
	.long	1420292253
	.long	1449455886
	.long	1996713354
	.long	2393864943
	.long	1091041605
	.long	3197086118
	.long	2840584506
	.long	2898911772
	.long	3993426708
	.long	492762590
	.long	2182083211
	.long	2099204941
	.long	1386201717
	.long	1502856249
	.long	3691886121
	.long	985525180
	.long	69199126
	.long	4198409883
	.long	2772403434
	.long	3005712498
	.long	3088804946
	.long	1971050360
	.long	138398252
	.long	4101852471
	.long	1249839573
	.long	1716457700
	.long	1882642597
	.long	3942100721
	.long	276796504
	.long	3908737646
	.long	2499679147
	.long	3432915400
	.long	3765285194
	.long	3589234146
	.long	553593009
	.long	3522507997
	.long	704390999
	.long	2570863504
	.long	3235603093
	.long	2883500997
	.long	1107186019
	.long	2750048699
	.long	1408781999
	.long	846759712
	.long	2176238891
	.long	1472034698
	.long	2214372039
	.long	1205130103
	.long	2817563999
	.long	1693519425
	.long	57510486
	.long	2944069397
	.long	133776782
	.long	2410260206
	.long	1340160702
	.long	3387038850
	.long	115020972
	.long	1593171499
	.long	267553565
	.long	525553116
	.long	2680321405
	.long	2479110404
	.long	230041945
	.long	3186342998
	.long	535107130
	.long	1051106232
	.long	1065675514
	.long	663253512
	.long	460083891
	.long	2077718700
	.long	1070214261
	.long	2102212464
	.long	2131351028
	.long	1326507024
	.long	920167782
	.long	4155437400
	.long	2140428522
	.long	4204424928
	.long	4262702056
	.long	2653014048
	.long	1840335564
	.long	4015907504
	.long	4280857045
	.long	4113882560
	.long	4230436817
	.long	1011060801
	.long	3680671129
	.long	3736847713
	.long	4266746795
	.long	3932797825
	.long	4165906339
	.long	2022121603
	.long	3066374962
	.long	3178728131
	.long	4238526295
	.long	3570628355
	.long	4036845383
	.long	4044243207
	.long	1837782628
	.long	2062488966
	.long	4182085295
	.long	2846289414
	.long	3778723471
	.long	3793519119
	.long	3675565257
	.long	4124977933
	.long	4069203294
	.long	1397611533
	.long	3262479647
	.long	3292070943
	.long	3056163219
	.long	3954988571
	.long	3843439293
	.long	2795223067
	.long	2229991998
	.long	2289174591
	.long	1817359143
	.long	3615009846
	.long	3391911291
	.long	1295478838
	.long	165016701
	.long	283381887
	.long	3634718287
	.long	2935052397
	.long	2488855287
	.long	2590957677
	.long	330033402
	.long	566763775
	.long	2974469278
	.long	1575137499
	.long	682743279
	.long	886948059
	.long	660066805
	.long	1133527550
	.long	1653971260
	.long	3150274999
	.long	1365486558
	.long	1773896118
	.long	1320133610
	.long	2267055100
	.long	3307942520
	.long	2005582702
	.long	2730973117
	.long	3547792237
	.long	2640267220
	.long	239142905
	.long	2320917745
	.long	4011165404
	.long	1166978938
	.long	2800617179
	.long	985567145
	.long	478285810
	.long	346868194
	.long	3727363513
	.long	2333957877
	.long	1306267062
	.long	1971134291
	.long	956571621
	.long	693736388
	.long	3159759730
	.long	372948459
	.long	2612534124
	.long	3942268582
	.long	1913143242
	.long	1387472776
	.long	2024552164
	.long	745896919
	.long	930100952
	.long	3589569869
	.long	3826286484
	.long	2774945552
	.long	4049104329
	.long	1491793838
	.long	1860201905
	.long	2884172442
	.long	3357605672
	.long	1254923809
	.long	3803241362
	.long	2983587677
	.long	3720403810
	.long	1473377588
	.long	2420244049
	.long	2509847619
	.long	3311515428
	.long	1672208059
	.long	3145840325
	.long	2946755177
	.long	545520802
	.long	724727943
	.long	2328063560
	.long	3344416119
	.long	1996713354
	.long	1598543059
	.long	1091041605
	.long	1449455886
	.long	361159825
	.long	2393864943
	.long	3993426708
	.long	3197086118
	.long	2182083211
	.long	2898911772
	.long	722319651
	.long	492762590
	.long	3691886121
	.long	2099204941
	.long	69199126
	.long	1502856249
	.long	1444639302
	.long	985525180
	.long	3088804946
	.long	4198409883
	.long	138398252
	.long	3005712498
	.long	2889278605
	.long	1971050360
	.long	1882642597
	.long	4101852471
	.long	276796504
	.long	1716457700
	.long	1483589915
	.long	3942100721
	.long	3765285194
	.long	3908737646
	.long	553593009
	.long	3432915400
	.long	2967179831
	.long	3589234146
	.long	3235603093
	.long	3522507997
	.long	1107186019
	.long	2570863504
	.long	1639392366
	.long	2883500997
	.long	2176238891
	.long	2750048699
	.long	2214372039
	.long	846759712
	.long	3278784732
	.long	1472034698
	.long	57510486
	.long	1205130103
	.long	133776782
	.long	1693519425
	.long	2262602168
	.long	2944069397
	.long	115020972
	.long	2410260206
	.long	267553565
	.long	3387038850
	.long	230237041
	.long	1593171499
	.long	230041945
	.long	525553116
	.long	535107130
	.long	2479110404
	.long	460474083
	.long	3186342998
	.long	460083891
	.long	1051106232
	.long	1070214261
	.long	663253512
	.long	920948167
	.long	2077718700
	.long	920167782
	.long	2102212464
	.long	2140428522
	.long	1326507024
	.long	1841896334
	.long	4155437400
	.long	1840335564
	.long	4204424928
	.long	4280857045
	.long	2653014048
	.long	3683792669
	.long	4015907504
	.long	3680671129
	.long	4113882560
	.long	4266746795
	.long	1011060801
	.long	3072618042
	.long	3736847713
	.long	3066374962
	.long	3932797825
	.long	4238526295
	.long	2022121603
	.long	1850268788
	.long	3178728131
	.long	1837782628
	.long	3570628355
	.long	4182085295
	.long	4044243207
	.long	3700537577
	.long	2062488966
	.long	3675565257
	.long	2846289414
	.long	4069203294
	.long	3793519119
	.long	3106107858
	.long	4124977933
	.long	3056163219
	.long	1397611533
	.long	3843439293
	.long	3292070943
	.long	1917248420
	.long	3954988571
	.long	1817359143
	.long	2795223067
	.long	3391911291
	.long	2289174591
	.long	3834496840
	.long	3615009846
	.long	3634718287
	.long	1295478838
	.long	2488855287
	.long	283381887
	.long	3374026384
	.long	2935052397
	.long	2974469278
	.long	2590957677
	.long	682743279
	.long	566763775
	.long	2453085473
	.long	1575137499
	.long	1653971260
	.long	886948059
	.long	1365486558
	.long	1133527550
	.long	611203650
	.long	3150274999
	.long	3307942520
	.long	1773896118
	.long	2730973117
	.long	2267055100
	.long	1222407300
	.long	2005582702
	.long	2320917745
	.long	3547792237
	.long	1166978938
	.long	239142905
	.long	2444814601
	.long	4011165404
	.long	346868194
	.long	2800617179
	.long	2333957877
	.long	478285810
	.long	594661906
	.long	3727363513
	.long	693736388
	.long	1306267062
	.long	372948459
	.long	956571621
	.long	1189323812
	.long	3159759730
	.long	1387472776
	.long	2612534124
	.long	745896919
	.long	1913143242
	.long	2378647625
	.long	2024552164
	.long	2774945552
	.long	930100952
	.long	1491793838
	.long	3826286484
	.long	462327955
	.long	4049104329
	.long	1254923809
	.long	1860201905
	.long	2983587677
	.long	3357605672
	.long	924655910
	.long	3803241362
	.long	2509847619
	.long	3720403810
	.long	1672208059
	.long	2420244049
	.long	1849311821
	.long	3311515428
	.long	724727943
	.long	3145840325
	.long	3344416119
	.long	545520802
	.long	3698623643
	.long	2328063560
	.long	1449455886
	.long	1996713354
	.long	2393864943
	.long	1091041605
	.long	3102279991
	.long	361159825
	.long	2898911772
	.long	3993426708
	.long	492762590
	.long	2182083211
	.long	1909592686
	.long	722319651
	.long	1502856249
	.long	3691886121
	.long	985525180
	.long	69199126
	.long	3819185373
	.long	1444639302
	.long	3005712498
	.long	3088804946
	.long	1971050360
	.long	138398252
	.long	3343403450
	.long	2889278605
	.long	1716457700
	.long	1882642597
	.long	3942100721
	.long	276796504
	.long	2391839604
	.long	1483589915
	.long	3432915400
	.long	3765285194
	.long	3589234146
	.long	553593009
	.long	488711913
	.long	2967179831
	.long	2570863504
	.long	3235603093
	.long	2883500997
	.long	1107186019
	.long	977423826
	.long	1639392366
	.long	846759712
	.long	2176238891
	.long	1472034698
	.long	2214372039
	.long	1954847653
	.long	3278784732
	.long	1693519425
	.long	57510486
	.long	2944069397
	.long	133776782
	.long	3909695307
	.long	2262602168
	.long	3387038850
	.long	115020972
	.long	1593171499
	.long	267553565
	.long	3524423319
	.long	230237041
	.long	2479110404
	.long	230041945
	.long	3186342998
	.long	535107130
	.long	2753879342
	.long	460474083
	.long	663253512
	.long	460083891
	.long	2077718700
	.long	1070214261
	.long	1212791388
	.long	920948167
	.long	1326507024
	.long	920167782
	.long	4155437400
	.long	2140428522
	.long	2425582776
	.long	1841896334
	.long	2653014048
	.long	1840335564
	.long	4015907504
	.long	4280857045
	.long	556198256
	.long	3683792669
	.long	1011060801
	.long	3680671129
	.long	3736847713
	.long	4266746795
	.long	1112396512
	.long	3072618042
	.long	2022121603
	.long	3066374962
	.long	3178728131
	.long	4238526295
	.long	2224793024
	.long	1850268788
	.long	4044243207
	.long	1837782628
	.long	2062488966
	.long	4182085295
	.long	154618752
	.long	3700537577
	.long	3793519119
	.long	3675565257
	.long	4124977933
	.long	4069203294
	.long	309237504
	.long	3106107858
	.long	3292070943
	.long	3056163219
	.long	3954988571
	.long	3843439293
	.long	618475008
	.long	1917248420
	.long	2289174591
	.long	1817359143
	.long	3615009846
	.long	3391911291
	.long	1236950016
	.long	3834496840
	.long	283381887
	.long	3634718287
	.long	2935052397
	.long	2488855287
	.long	2473900033
	.long	3374026384
	.long	566763775
	.long	2974469278
	.long	1575137499
	.long	682743279
	.long	652832771
	.long	2453085473
	.long	1133527550
	.long	1653971260
	.long	3150274999
	.long	1365486558
	.long	1305665542
	.long	611203650
	.long	2267055100
	.long	3307942520
	.long	2005582702
	.long	2730973117
	.long	2611331084
	.long	1222407300
	.long	239142905
	.long	2320917745
	.long	4011165404
	.long	1166978938
	.long	927694873
	.long	2444814601
	.long	478285810
	.long	346868194
	.long	3727363513
	.long	2333957877
	.long	1855389746
	.long	594661906
	.long	956571621
	.long	693736388
	.long	3159759730
	.long	372948459
	.long	3710779492
	.long	1189323812
	.long	1913143242
	.long	1387472776
	.long	2024552164
	.long	745896919
	.long	3126591689
	.long	2378647625
	.long	3826286484
	.long	2774945552
	.long	4049104329
	.long	1491793838
	.long	1958216082
	.long	462327955
	.long	3357605672
	.long	1254923809
	.long	3803241362
	.long	2983587677
	.long	3916432164
	.long	924655910
	.long	2420244049
	.long	2509847619
	.long	3311515428
	.long	1672208059
	.long	3537897033
	.long	1849311821
	.long	545520802
	.long	724727943
	.long	2328063560
	.long	3344416119
	.long	2780826770
	.long	3698623643
	.long	1091041605
	.long	1449455886
	.long	361159825
	.long	2393864943
	.long	1266686244
	.long	3102279991
	.long	2182083211
	.long	2898911772
	.long	722319651
	.long	492762590
	.long	2533372489
	.long	1909592686
	.long	69199126
	.long	1502856249
	.long	1444639302
	.long	985525180
	.long	771777682
	.long	3819185373
	.long	138398252
	.long	3005712498
	.long	2889278605
	.long	1971050360
	.long	1543555365
	.long	3343403450
	.long	276796504
	.long	1716457700
	.long	1483589915
	.long	3942100721
	.long	3087110731
	.long	2391839604
	.long	553593009
	.long	3432915400
	.long	2967179831
	.long	3589234146
	.long	1879254167
	.long	488711913
	.long	1107186019
	.long	2570863504
	.long	1639392366
	.long	2883500997
	.long	3758508334
	.long	977423826
	.long	2214372039
	.long	846759712
	.long	3278784732
	.long	1472034698
	.long	3222049373
	.long	1954847653
	.long	133776782
	.long	1693519425
	.long	2262602168
	.long	2944069397
	.long	2149131451
	.long	3909695307
	.long	267553565
	.long	3387038850
	.long	230237041
	.long	1593171499
	.long	3295607
	.long	3524423319
	.long	535107130
	.long	2479110404
	.long	460474083
	.long	3186342998
	.long	6591214
	.long	2753879342
	.long	1070214261
	.long	663253512
	.long	920948167
	.long	2077718700
	.long	13182429
	.long	1212791388
	.long	2140428522
	.long	1326507024
	.long	1841896334
	.long	4155437400
	.long	26364858
	.long	2425582776
	.long	4280857045
	.long	2653014048
	.long	3683792669
	.long	4015907504
	.long	52729717
	.long	556198256
	.long	4266746795
	.long	1011060801
	.long	3072618042
	.long	3736847713
	.long	105459434
	.long	1112396512
	.long	4238526295
	.long	2022121603
	.long	1850268788
	.long	3178728131
	.long	210918868
	.long	2224793024
	.long	4182085295
	.long	4044243207
	.long	3700537577
	.long	2062488966
	.long	421837736
	.long	154618752
	.long	4069203294
	.long	3793519119
	.long	3106107858
	.long	4124977933
	.long	843675472
	.long	309237504
	.long	3843439293
	.long	3292070943
	.long	1917248420
	.long	3954988571
	.long	1687350944
	.long	618475008
	.long	3391911291
	.long	2289174591
	.long	3834496840
	.long	3615009846
	.long	3374701889
	.long	1236950016
	.long	2488855287
	.long	283381887
	.long	3374026384
	.long	2935052397
	.long	2454436482
	.long	2473900033
	.long	682743279
	.long	566763775
	.long	2453085473
	.long	1575137499
	.long	613905668
	.long	652832771
	.long	1365486558
	.long	1133527550
	.long	611203650
	.long	3150274999
	.long	1227811337
	.long	1305665542
	.long	2730973117
	.long	2267055100
	.long	1222407300
	.long	2005582702
	.long	2455622675
	.long	2611331084
	.long	1166978938
	.long	239142905
	.long	2444814601
	.long	4011165404
	.long	616278055
	.long	927694873
	.long	2333957877
	.long	478285810
	.long	594661906
	.long	3727363513
	.long	1232556110
	.long	1855389746
	.long	372948459
	.long	956571621
	.long	1189323812
	.long	3159759730
	.long	2465112221
	.long	3710779492
	.long	745896919
	.long	1913143242
	.long	2378647625
	.long	2024552164
	.long	635257146
	.long	3126591689
	.long	1491793838
	.long	3826286484
	.long	462327955
	.long	4049104329
	.long	1270514292
	.long	1958216082
	.long	2983587677
	.long	3357605672
	.long	924655910
	.long	3803241362
	.long	2541028584
	.long	3916432164
	.long	1672208059
	.long	2420244049
	.long	1849311821
	.long	3311515428
	.long	787089873
	.long	3537897033
	.long	3344416119
	.long	545520802
	.long	3698623643
	.long	2328063560
	.long	1574179747
	.long	2780826770
	.long	2393864943
	.long	1091041605
	.long	3102279991
	.long	361159825
	.long	3148359494
	.long	1266686244
	.long	492762590
	.long	2182083211
	.long	1909592686
	.long	722319651
	.long	2001751692
	.long	2533372489
	.long	985525180
	.long	69199126
	.long	3819185373
	.long	1444639302
	.long	4003503385
	.long	771777682
	.long	1971050360
	.long	138398252
	.long	3343403450
	.long	2889278605
	.long	3712039474
	.long	1543555365
	.long	3942100721
	.long	276796504
	.long	2391839604
	.long	1483589915
	.long	3129111652
	.long	3087110731
	.long	3589234146
	.long	553593009
	.long	488711913
	.long	2967179831
	.long	1963256009
	.long	1879254167
	.long	2883500997
	.long	1107186019
	.long	977423826
	.long	1639392366
	.long	3926512018
	.long	3758508334
	.long	1472034698
	.long	2214372039
	.long	1954847653
	.long	3278784732
	.long	3558056740
	.long	3222049373
	.long	2944069397
	.long	133776782
	.long	3909695307
	.long	2262602168
	.long	2821146184
	.long	2149131451
	.long	1593171499
	.long	267553565
	.long	3524423319
	.long	230237041
	.long	1347325072
	.long	3295607
	.long	3186342998
	.long	535107130
	.long	2753879342
	.long	460474083
	.long	2694650145
	.long	6591214
	.long	2077718700
	.long	1070214261
	.long	1212791388
	.long	920948167
	.long	1094332995
	.long	13182429
	.long	4155437400
	.long	2140428522
	.long	2425582776
	.long	1841896334
	.long	2188665991
	.long	26364858
	.long	4015907504
	.long	4280857045
	.long	556198256
	.long	3683792669
	.long	82364686
	.long	52729717
	.long	3736847713
	.long	4266746795
	.long	1112396512
	.long	3072618042
	.long	164729372
	.long	105459434
	.long	3178728131
	.long	4238526295
	.long	2224793024
	.long	1850268788
	.long	329458745
	.long	210918868
	.long	2062488966
	.long	4182085295
	.long	154618752
	.long	3700537577
	.long	658917491
	.long	421837736
	.long	4124977933
	.long	4069203294
	.long	309237504
	.long	3106107858
	.long	1317834983
	.long	843675472
	.long	3954988571
	.long	3843439293
	.long	618475008
	.long	1917248420
	.long	2635669967
	.long	1687350944
	.long	3615009846
	.long	3391911291
	.long	1236950016
	.long	3834496840
	.long	976372639
	.long	3374701889
	.long	2935052397
	.long	2488855287
	.long	2473900033
	.long	3374026384
	.long	1952745279
	.long	2454436482
	.long	1575137499
	.long	682743279
	.long	652832771
	.long	2453085473
	.long	3905490559
	.long	613905668
	.long	3150274999
	.long	1365486558
	.long	1305665542
	.long	611203650
	.long	3516013822
	.long	1227811337
	.long	2005582702
	.long	2730973117
	.long	2611331084
	.long	1222407300
	.long	2737060348
	.long	2455622675
	.long	4011165404
	.long	1166978938
	.long	927694873
	.long	2444814601
	.long	1179153400
	.long	616278055
	.long	3727363513
	.long	2333957877
	.long	1855389746
	.long	594661906
	.long	2358306800
	.long	1232556110
	.long	3159759730
	.long	372948459
	.long	3710779492
	.long	1189323812
	.long	421646305
	.long	2465112221
	.long	2024552164
	.long	745896919
	.long	3126591689
	.long	2378647625
	.long	843292611
	.long	635257146
	.long	4049104329
	.long	1491793838
	.long	1958216082
	.long	462327955
	.long	1686585223
	.long	1270514292
	.long	3803241362
	.long	2983587677
	.long	3916432164
	.long	924655910
	.long	3373170446
	.long	2541028584
	.long	3311515428
	.long	1672208059
	.long	3537897033
	.long	1849311821
	.long	2451373597
	.long	787089873
	.long	2328063560
	.long	3344416119
	.long	2780826770
	.long	3698623643
	.long	607779899
	.long	1574179747
	.long	361159825
	.long	2393864943
	.long	1266686244
	.long	3102279991
	.long	1215559799
	.long	3148359494
	.long	722319651
	.long	492762590
	.long	2533372489
	.long	1909592686
	.long	2431119599
	.long	2001751692
	.long	1444639302
	.long	985525180
	.long	771777682
	.long	3819185373
	.long	567271902
	.long	4003503385
	.long	2889278605
	.long	1971050360
	.long	1543555365
	.long	3343403450
	.long	1134543805
	.long	3712039474
	.long	1483589915
	.long	3942100721
	.long	3087110731
	.long	2391839604
	.long	2269087610
	.long	3129111652
	.long	2967179831
	.long	3589234146
	.long	1879254167
	.long	488711913
	.long	243207925
	.long	1963256009
	.long	1639392366
	.long	2883500997
	.long	3758508334
	.long	977423826
	.long	486415851
	.long	3926512018
	.long	3278784732
	.long	1472034698
	.long	3222049373
	.long	1954847653
	.long	972831702
	.long	3558056740
	.long	2262602168
	.long	2944069397
	.long	2149131451
	.long	3909695307
	.long	1945663404
	.long	2821146184
	.long	230237041
	.long	1593171499
	.long	3295607
	.long	3524423319
	.long	3891326808
	.long	1347325072
	.long	460474083
	.long	3186342998
	.long	6591214
	.long	2753879342
	.long	3487686321
	.long	2694650145
	.long	920948167
	.long	2077718700
	.long	13182429
	.long	1212791388
	.long	2680405347
	.long	1094332995
	.long	1841896334
	.long	4155437400
	.long	26364858
	.long	2425582776
	.long	1065843399
	.long	2188665991
	.long	3683792669
	.long	4015907504
	.long	52729717
	.long	556198256
	.long	2131686798
	.long	82364686
	.long	3072618042
	.long	3736847713
	.long	105459434
	.long	1112396512
	.long	4263373596
	.long	164729372
	.long	1850268788
	.long	3178728131
	.long	210918868
	.long	2224793024
	.long	4231779897
	.long	329458745
	.long	3700537577
	.long	2062488966
	.long	421837736
	.long	154618752
	.long	4168592498
	.long	658917491
	.long	3106107858
	.long	4124977933
	.long	843675472
	.long	309237504
	.long	4042217701
	.long	1317834983
	.long	1917248420
	.long	3954988571
	.long	1687350944
	.long	618475008
	.long	3789468107
	.long	2635669967
	.long	3834496840
	.long	3615009846
	.long	3374701889
	.long	1236950016
	.long	3283968918
	.long	976372639
	.long	3374026384
	.long	2935052397
	.long	2454436482
	.long	2473900033
	.long	2272970540
	.long	1952745279
	.long	2453085473
	.long	1575137499
	.long	613905668
	.long	652832771
	.long	250973784
	.long	3905490559
	.long	611203650
	.long	3150274999
	.long	1227811337
	.long	1305665542
	.long	501947569
	.long	3516013822
	.long	1222407300
	.long	2005582702
	.long	2455622675
	.long	2611331084
	.long	1003895138
	.long	2737060348
	.long	2444814601
	.long	4011165404
	.long	616278055
	.long	927694873
	.long	2007790276
	.long	1179153400
	.long	594661906
	.long	3727363513
	.long	1232556110
	.long	1855389746
	.long	4015580553
	.long	2358306800
	.long	1189323812
	.long	3159759730
	.long	2465112221
	.long	3710779492
	.long	3736193810
	.long	421646305
	.long	2378647625
	.long	2024552164
	.long	635257146
	.long	3126591689
	.long	3177420325
	.long	843292611
	.long	462327955
	.long	4049104329
	.long	1270514292
	.long	1958216082
	.long	2059873354
	.long	1686585223
	.long	924655910
	.long	3803241362
	.long	2541028584
	.long	3916432164
	.long	4119746708
	.long	3373170446
	.long	1849311821
	.long	3311515428
	.long	787089873
	.long	3537897033
	.long	3944526121
	.long	2451373597
	.long	3698623643
	.long	2328063560
	.long	1574179747
	.long	2780826770
	.long	3594084947
	.long	607779899
	.long	3102279991
	.long	361159825
	.long	3148359494
	.long	1266686244
	.long	2893202598
	.long	1215559799
	.long	1909592686
	.long	722319651
	.long	2001751692
	.long	2533372489
	.long	1491437901
	.long	2431119599
	.long	3819185373
	.long	1444639302
	.long	4003503385
	.long	771777682
	.long	2982875802
	.long	567271902
	.long	3343403450
	.long	2889278605
	.long	3712039474
	.long	1543555365
	.long	1670784308
	.long	1134543805
	.long	2391839604
	.long	1483589915
	.long	3129111652
	.long	3087110731
	.long	3341568617
	.long	2269087610
	.long	488711913
	.long	2967179831
	.long	1963256009
	.long	1879254167
	.long	2388169939
	.long	243207925
	.long	977423826
	.long	1639392366
	.long	3926512018
	.long	3758508334
	.long	481372583
	.long	486415851
	.long	1954847653
	.long	3278784732
	.long	3558056740
	.long	3222049373
	.long	962745166
	.long	972831702
	.long	3909695307
	.long	2262602168
	.long	2821146184
	.long	2149131451
	.long	1925490332
	.long	1945663404
	.long	3524423319
	.long	230237041
	.long	1347325072
	.long	3295607
	.long	3850980665
	.long	3891326808
	.long	2753879342
	.long	460474083
	.long	2694650145
	.long	6591214
	.long	3406994035
	.long	3487686321
	.long	1212791388
	.long	920948167
	.long	1094332995
	.long	13182429
	.long	2519020775
	.long	2680405347
	.long	2425582776
	.long	1841896334
	.long	2188665991
	.long	26364858
	.long	743074255
	.long	1065843399
	.long	556198256
	.long	3683792669
	.long	82364686
	.long	52729717
	.long	1486148511
	.long	2131686798
	.long	1112396512
	.long	3072618042
	.long	164729372
	.long	105459434
	.long	2972297022
	.long	4263373596
	.long	2224793024
	.long	1850268788
	.long	329458745
	.long	210918868
	.long	1649626749
	.long	4231779897
	.long	154618752
	.long	3700537577
	.long	658917491
	.long	421837736
	.long	3299253499
	.long	4168592498
	.long	309237504
	.long	3106107858
	.long	1317834983
	.long	843675472
	.long	2303539703
	.long	4042217701
	.long	618475008
	.long	1917248420
	.long	2635669967
	.long	1687350944
	.long	312112110
	.long	3789468107
	.long	1236950016
	.long	3834496840
	.long	976372639
	.long	3374701889
	.long	624224221
	.long	3283968918
	.long	2473900033
	.long	3374026384
	.long	1952745279
	.long	2454436482
	.long	1248448442
	.long	2272970540
	.long	652832771
	.long	2453085473
	.long	3905490559
	.long	613905668
	.long	2496896884
	.long	250973784
	.long	1305665542
	.long	611203650
	.long	3516013822
	.long	1227811337
	.long	698826472
	.long	501947569
	.long	2611331084
	.long	1222407300
	.long	2737060348
	.long	2455622675
	.long	1397652945
	.long	1003895138
	.long	927694873
	.long	2444814601
	.long	1179153400
	.long	616278055
	.long	2795305890
	.long	2007790276
	.long	1855389746
	.long	594661906
	.long	2358306800
	.long	1232556110
	.long	1295644484
	.long	4015580553
	.long	3710779492
	.long	1189323812
	.long	421646305
	.long	2465112221
	.long	2591288968
	.long	3736193810
	.long	3126591689
	.long	2378647625
	.long	843292611
	.long	635257146
	.long	887610640
	.long	3177420325
	.long	1958216082
	.long	462327955
	.long	1686585223
	.long	1270514292
	.long	1775221280
	.long	2059873354
	.long	3916432164
	.long	924655910
	.long	3373170446
	.long	2541028584
	.long	3550442561
	.long	4119746708
	.long	3537897033
	.long	1849311821
	.long	2451373597
	.long	787089873
	.long	2805917826
	.long	3944526121
	.long	2780826770
	.long	3698623643
	.long	607779899
	.long	1574179747
	.long	1316868356
	.long	3594084947
	.long	1266686244
	.long	3102279991
	.long	1215559799
	.long	3148359494
	.long	2633736712
	.long	2893202598
	.long	2533372489
	.long	1909592686
	.long	2431119599
	.long	2001751692
	.long	972506129
	.long	1491437901
	.long	771777682
	.long	3819185373
	.long	567271902
	.long	4003503385
	.long	1945012259
	.long	2982875802
	.long	1543555365
	.long	3343403450
	.long	1134543805
	.long	3712039474
	.long	3890024518
	.long	1670784308
	.long	3087110731
	.long	2391839604
	.long	2269087610
	.long	3129111652
	.long	3485081741
	.long	3341568617
	.long	1879254167
	.long	488711913
	.long	243207925
	.long	1963256009
	.long	2675196186
	.long	2388169939
	.long	3758508334
	.long	977423826
	.long	486415851
	.long	3926512018
	.long	1055425077
	.long	481372583
	.long	3222049373
	.long	1954847653
	.long	972831702
	.long	3558056740
	.long	2110850155
	.long	962745166
	.long	2149131451
	.long	3909695307
	.long	1945663404
	.long	2821146184
	.long	4221700311
	.long	1925490332
	.long	3295607
	.long	3524423319
	.long	3891326808
	.long	1347325072
	.long	4148433327
	.long	3850980665
	.long	6591214
	.long	2753879342
	.long	3487686321
	.long	2694650145
	.long	4001899359
	.long	3406994035
	.long	13182429
	.long	1212791388
	.long	2680405347
	.long	1094332995
	.long	3708831422
	.long	2519020775
	.long	26364858
	.long	2425582776
	.long	1065843399
	.long	2188665991
	.long	3122695549
	.long	743074255
	.long	52729717
	.long	556198256
	.long	2131686798
	.long	82364686
	.long	1950423802
	.long	1486148511
	.long	105459434
	.long	1112396512
	.long	4263373596
	.long	164729372
	.long	3900847605
	.long	2972297022
	.long	210918868
	.long	2224793024
	.long	4231779897
	.long	329458745
	.long	3506727914
	.long	1649626749
	.long	421837736
	.long	154618752
	.long	4168592498
	.long	658917491
	.long	2718488532
	.long	3299253499
	.long	843675472
	.long	309237504
	.long	4042217701
	.long	1317834983
	.long	1142009769
	.long	2303539703
	.long	1687350944
	.long	618475008
	.long	3789468107
	.long	2635669967
	.long	2284019538
	.long	312112110
	.long	3374701889
	.long	1236950016
	.long	3283968918
	.long	976372639
	.long	273071781
	.long	624224221
	.long	2454436482
	.long	2473900033
	.long	2272970540
	.long	1952745279
	.long	546143563
	.long	1248448442
	.long	613905668
	.long	652832771
	.long	250973784
	.long	3905490559
	.long	1092287127
	.long	2496896884
	.long	1227811337
	.long	1305665542
	.long	501947569
	.long	3516013822
	.long	2184574254
	.long	698826472
	.long	2455622675
	.long	2611331084
	.long	1003895138
	.long	2737060348
	.long	74181213
	.long	1397652945
	.long	616278055
	.long	927694873
	.long	2007790276
	.long	1179153400
	.long	148362426
	.long	2795305890
	.long	1232556110
	.long	1855389746
	.long	4015580553
	.long	2358306800
	.long	296724853
	.long	1295644484
	.long	2465112221
	.long	3710779492
	.long	3736193810
	.long	421646305
	.long	593449707
	.long	2591288968
	.long	635257146
	.long	3126591689
	.long	3177420325
	.long	843292611
	.long	1186899415
	.long	887610640
	.long	1270514292
	.long	1958216082
	.long	2059873354
	.long	1686585223
	.long	2373798830
	.long	1775221280
	.long	2541028584
	.long	3916432164
	.long	4119746708
	.long	3373170446
	.long	452630365
	.long	3550442561
	.long	787089873
	.long	3537897033
	.long	3944526121
	.long	2451373597
	.long	905260731
	.long	2805917826
	.long	1574179747
	.long	2780826770
	.long	3594084947
	.long	607779899
	.long	1810521462
	.long	1316868356
	.long	3148359494
	.long	1266686244
	.long	2893202598
	.long	1215559799
	.long	3621042925
	.long	2633736712
	.long	2001751692
	.long	2533372489
	.long	1491437901
	.long	2431119599
	.long	2947118554
	.long	972506129
	.long	4003503385
	.long	771777682
	.long	2982875802
	.long	567271902
	.long	1599269812
	.long	1945012259
	.long	3712039474
	.long	1543555365
	.long	1670784308
	.long	1134543805
	.long	3198539624
	.long	3890024518
	.long	3129111652
	.long	3087110731
	.long	3341568617
	.long	2269087610
	.long	2102111953
	.long	3485081741
	.long	1963256009
	.long	1879254167
	.long	2388169939
	.long	243207925
	.long	4204223906
	.long	2675196186
	.long	3926512018
	.long	3758508334
	.long	481372583
	.long	486415851
	.long	4113480516
	.long	1055425077
	.long	3558056740
	.long	3222049373
	.long	962745166
	.long	972831702
	.long	3931993737
	.long	2110850155
	.long	2821146184
	.long	2149131451
	.long	1925490332
	.long	1945663404
	.long	3569020178
	.long	4221700311
	.long	1347325072
	.long	3295607
	.long	3850980665
	.long	3891326808
	.long	2843073060
	.long	4148433327
	.long	2694650145
	.long	6591214
	.long	3406994035
	.long	3487686321
	.long	1391178824
	.long	4001899359
	.long	1094332995
	.long	13182429
	.long	2519020775
	.long	2680405347
	.long	2782357648
	.long	3708831422
	.long	2188665991
	.long	26364858
	.long	743074255
	.long	1065843399
	.long	1269748001
	.long	3122695549
	.long	82364686
	.long	52729717
	.long	1486148511
	.long	2131686798
	.long	2539496002
	.long	1950423802
	.long	164729372
	.long	105459434
	.long	2972297022
	.long	4263373596
	.long	784024708
	.long	3900847605
	.long	329458745
	.long	210918868
	.long	1649626749
	.long	4231779897
	.long	1568049417
	.long	3506727914
	.long	658917491
	.long	421837736
	.long	3299253499
	.long	4168592498
	.long	3136098835
	.long	2718488532
	.long	1317834983
	.long	843675472
	.long	2303539703
	.long	4042217701
	.long	1977230375
	.long	1142009769
	.long	2635669967
	.long	1687350944
	.long	312112110
	.long	3789468107
	.long	3954460750
	.long	2284019538
	.long	976372639
	.long	3374701889
	.long	624224221
	.long	3283968918
	.long	3613954205
	.long	273071781
	.long	1952745279
	.long	2454436482
	.long	1248448442
	.long	2272970540
	.long	2932941114
	.long	546143563
	.long	3905490559
	.long	613905668
	.long	2496896884
	.long	250973784
	.long	1570914932
	.long	1092287127
	.long	3516013822
	.long	1227811337
	.long	698826472
	.long	501947569
	.long	3141829865
	.long	2184574254
	.long	2737060348
	.long	2455622675
	.long	1397652945
	.long	1003895138
	.long	1988692435
	.long	74181213
	.long	1179153400
	.long	616278055
	.long	2795305890
	.long	2007790276
	.long	3977384870
	.long	148362426
	.long	2358306800
	.long	1232556110
	.long	1295644484
	.long	4015580553
	.long	3659802444
	.long	296724853
	.long	421646305
	.long	2465112221
	.long	2591288968
	.long	3736193810
	.long	3024637593
	.long	593449707
	.long	843292611
	.long	635257146
	.long	887610640
	.long	3177420325
	.long	1754307891
	.long	1186899415
	.long	1686585223
	.long	1270514292
	.long	1775221280
	.long	2059873354
	.long	3508615783
	.long	2373798830
	.long	3373170446
	.long	2541028584
	.long	3550442561
	.long	4119746708
	.long	2722264270
	.long	452630365
	.long	2451373597
	.long	787089873
	.long	2805917826
	.long	3944526121
	.long	1149561244
	.long	905260731
	.long	607779899
	.long	1574179747
	.long	1316868356
	.long	3594084947
	.long	2299122488
	.long	1810521462
	.long	1215559799
	.long	3148359494
	.long	2633736712
	.long	2893202598
	.long	303277681
	.long	3621042925
	.long	2431119599
	.long	2001751692
	.long	972506129
	.long	1491437901
	.long	606555363
	.long	2947118554
	.long	567271902
	.long	4003503385
	.long	1945012259
	.long	2982875802
	.long	1213110727
	.long	1599269812
	.long	1134543805
	.long	3712039474
	.long	3890024518
	.long	1670784308
	.long	2426221454
	.long	3198539624
	.long	2269087610
	.long	3129111652
	.long	3485081741
	.long	3341568617
	.long	557475612
	.long	2102111953
	.long	243207925
	.long	1963256009
	.long	2675196186
	.long	2388169939
	.long	1114951224
	.long	4204223906
	.long	486415851
	.long	3926512018
	.long	1055425077
	.long	481372583
	.long	2229902448
	.long	4113480516
	.long	972831702
	.long	3558056740
	.long	2110850155
	.long	962745166
	.long	164837600
	.long	3931993737
	.long	1945663404
	.long	2821146184
	.long	4221700311
	.long	1925490332
	.long	329675200
	.long	3569020178
	.long	3891326808
	.long	1347325072
	.long	4148433327
	.long	3850980665
	.long	659350401
	.long	2843073060
	.long	3487686321
	.long	2694650145
	.long	4001899359
	.long	3406994035
	.long	1318700802
	.long	1391178824
	.long	2680405347
	.long	1094332995
	.long	3708831422
	.long	2519020775
	.long	2637401604
	.long	2782357648
	.long	1065843399
	.long	2188665991
	.long	3122695549
	.long	743074255
	.long	979835913
	.long	1269748001
	.long	2131686798
	.long	82364686
	.long	1950423802
	.long	1486148511
	.long	1959671827
	.long	2539496002
	.long	4263373596
	.long	164729372
	.long	3900847605
	.long	2972297022
	.long	3919343654
	.long	784024708
	.long	4231779897
	.long	329458745
	.long	3506727914
	.long	1649626749
	.long	3543720013
	.long	1568049417
	.long	4168592498
	.long	658917491
	.long	2718488532
	.long	3299253499
	.long	2792472730
	.long	3136098835
	.long	4042217701
	.long	1317834983
	.long	1142009769
	.long	2303539703
	.long	1289978165
	.long	1977230375
	.long	3789468107
	.long	2635669967
	.long	2284019538
	.long	312112110
	.long	2579956331
	.long	3954460750
	.long	3283968918
	.long	976372639
	.long	273071781
	.long	624224221
	.long	864945366
	.long	3613954205
	.long	2272970540
	.long	1952745279
	.long	546143563
	.long	1248448442
	.long	1729890733
	.long	2932941114
	.long	250973784
	.long	3905490559
	.long	1092287127
	.long	2496896884
	.long	3459781466
	.long	1570914932
	.long	501947569
	.long	3516013822
	.long	2184574254
	.long	698826472
	.long	2624595636
	.long	3141829865
	.long	1003895138
	.long	2737060348
	.long	74181213
	.long	1397652945
	.long	954223976
	.long	1988692435
	.long	2007790276
	.long	1179153400
	.long	148362426
	.long	2795305890
	.long	1908447953
	.long	3977384870
	.long	4015580553
	.long	2358306800
	.long	296724853
	.long	1295644484
	.long	3816895906
	.long	3659802444
	.long	3736193810
	.long	421646305
	.long	593449707
	.long	2591288968
	.long	3338824517
	.long	3024637593
	.long	3177420325
	.long	843292611
	.long	1186899415
	.long	887610640
	.long	2382681739
	.long	1754307891
	.long	2059873354
	.long	1686585223
	.long	2373798830
	.long	1775221280
	.long	470396183
	.long	3508615783
	.long	4119746708
	.long	3373170446
	.long	452630365
	.long	3550442561
	.long	940792367
	.long	2722264270
	.long	3944526121
	.long	2451373597
	.long	905260731
	.long	2805917826
	.long	1881584735
	.long	1149561244
	.long	3594084947
	.long	607779899
	.long	1810521462
	.long	1316868356
	.long	3763169470
	.long	2299122488
	.long	2893202598
	.long	1215559799
	.long	3621042925
	.long	2633736712
	.long	3231371645
	.long	303277681
	.long	1491437901
	.long	2431119599
	.long	2947118554
	.long	972506129
	.long	2167775995
	.long	606555363
	.long	2982875802
	.long	567271902
	.long	1599269812
	.long	1945012259
	.long	40584695
	.long	1213110727
	.long	1670784308
	.long	1134543805
	.long	3198539624
	.long	3890024518
	.long	81169391
	.long	2426221454
	.long	3341568617
	.long	2269087610
	.long	2102111953
	.long	3485081741
	.long	162338783
	.long	557475612
	.long	2388169939
	.long	243207925
	.long	4204223906
	.long	2675196186
	.long	324677567
	.long	1114951224
	.long	481372583
	.long	486415851
	.long	4113480516
	.long	1055425077
	.long	649355134
	.long	2229902448
	.long	962745166
	.long	972831702
	.long	3931993737
	.long	2110850155
	.long	1298710268
	.long	164837600
	.long	1925490332
	.long	1945663404
	.long	3569020178
	.long	4221700311
	.long	2597420537
	.long	329675200
	.long	3850980665
	.long	3891326808
	.long	2843073060
	.long	4148433327
	.long	899873778
	.long	659350401
	.long	3406994035
	.long	3487686321
	.long	1391178824
	.long	4001899359
	.long	1799747556
	.long	1318700802
	.long	2519020775
	.long	2680405347
	.long	2782357648
	.long	3708831422
	.long	3599495112
	.long	2637401604
	.long	743074255
	.long	1065843399
	.long	1269748001
	.long	3122695549
	.long	2904022928
	.long	979835913
	.long	1486148511
	.long	2131686798
	.long	2539496002
	.long	1950423802
	.long	1513078560
	.long	1959671827
	.long	2972297022
	.long	4263373596
	.long	784024708
	.long	3900847605
	.long	3026157121
	.long	3919343654
	.long	1649626749
	.long	4231779897
	.long	1568049417
	.long	3506727914
	.long	1757346946
	.long	3543720013
	.long	3299253499
	.long	4168592498
	.long	3136098835
	.long	2718488532
	.long	3514693892
	.long	2792472730
	.long	2303539703
	.long	4042217701
	.long	1977230375
	.long	1142009769
	.long	2734420489
	.long	1289978165
	.long	312112110
	.long	3789468107
	.long	3954460750
	.long	2284019538
	.long	1173873683
	.long	2579956331
	.long	624224221
	.long	3283968918
	.long	3613954205
	.long	273071781
	.long	2347747367
	.long	864945366
	.long	1248448442
	.long	2272970540
	.long	2932941114
	.long	546143563
	.long	400527438
	.long	1729890733
	.long	2496896884
	.long	250973784
	.long	1570914932
	.long	1092287127
	.long	801054876
	.long	3459781466
	.long	698826472
	.long	501947569
	.long	3141829865
	.long	2184574254
	.long	1602109753
	.long	2624595636
	.long	1397652945
	.long	1003895138
	.long	1988692435
	.long	74181213
	.long	3204219507
	.long	954223976
	.long	2795305890
	.long	2007790276
	.long	3977384870
	.long	148362426
	.long	2113471718
	.long	1908447953
	.long	1295644484
	.long	4015580553
	.long	3659802444
	.long	296724853
	.long	4226943436
	.long	3816895906
	.long	2591288968
	.long	3736193810
	.long	3024637593
	.long	593449707
	.long	4158919577
	.long	3338824517
	.long	887610640
	.long	3177420325
	.long	1754307891
	.long	1186899415
	.long	4022871858
	.long	2382681739
	.long	1775221280
	.long	2059873354
	.long	3508615783
	.long	2373798830
	.long	3750776420
	.long	470396183
	.long	3550442561
	.long	4119746708
	.long	2722264270
	.long	452630365
	.long	3206585544
	.long	940792367
	.long	2805917826
	.long	3944526121
	.long	1149561244
	.long	905260731
	.long	2118203793
	.long	1881584735
	.long	1316868356
	.long	3594084947
	.long	2299122488
	.long	1810521462
	.long	4236407587
	.long	3763169470
	.long	2633736712
	.long	2893202598
	.long	303277681
	.long	3621042925
	.long	4177847879
	.long	3231371645
	.long	972506129
	.long	1491437901
	.long	606555363
	.long	2947118554
	.long	4060728462
	.long	2167775995
	.long	1945012259
	.long	2982875802
	.long	1213110727
	.long	1599269812
	.long	3826489629
	.long	40584695
	.long	3890024518
	.long	1670784308
	.long	2426221454
	.long	3198539624
	.long	3358011962
	.long	81169391
	.long	3485081741
	.long	3341568617
	.long	557475612
	.long	2102111953
	.long	2421056629
	.long	162338783
	.long	2675196186
	.long	2388169939
	.long	1114951224
	.long	4204223906
	.long	547145963
	.long	324677567
	.long	1055425077
	.long	481372583
	.long	2229902448
	.long	4113480516
	.long	1094291926
	.long	649355134
	.long	2110850155
	.long	962745166
	.long	164837600
	.long	3931993737
	.long	2188583852
	.long	1298710268
	.long	4221700311
	.long	1925490332
	.long	329675200
	.long	3569020178
	.long	82200408
	.long	2597420537
	.long	4148433327
	.long	3850980665
	.long	659350401
	.long	2843073060
	.long	164400817
	.long	899873778
	.long	4001899359
	.long	3406994035
	.long	1318700802
	.long	1391178824
	.long	328801635
	.long	1799747556
	.long	3708831422
	.long	2519020775
	.long	2637401604
	.long	2782357648
	.long	657603271
	.long	3599495112
	.long	3122695549
	.long	743074255
	.long	979835913
	.long	1269748001
	.long	1315206542
	.long	2904022928
	.long	1950423802
	.long	1486148511
	.long	1959671827
	.long	2539496002
	.long	2630413084
	.long	1513078560
	.long	3900847605
	.long	2972297022
	.long	3919343654
	.long	784024708
	.long	965858873
	.long	3026157121
	.long	3506727914
	.long	1649626749
	.long	3543720013
	.long	1568049417
	.long	1931717747
	.long	1757346946
	.long	2718488532
	.long	3299253499
	.long	2792472730
	.long	3136098835
	.long	3863435494
	.long	3514693892
	.long	1142009769
	.long	2303539703
	.long	1289978165
	.long	1977230375
	.long	3431903692
	.long	2734420489
	.long	2284019538
	.long	312112110
	.long	2579956331
	.long	3954460750
	.long	2568840088
	.long	1173873683
	.long	273071781
	.long	624224221
	.long	864945366
	.long	3613954205
	.long	842712880
	.long	2347747367
	.long	546143563
	.long	1248448442
	.long	1729890733
	.long	2932941114
	.long	1685425760
	.long	400527438
	.long	1092287127
	.long	2496896884
	.long	3459781466
	.long	1570914932
	.long	3370851521
	.long	801054876
	.long	2184574254
	.long	698826472
	.long	2624595636
	.long	3141829865
	.long	2446735747
	.long	1602109753
	.long	74181213
	.long	1397652945
	.long	954223976
	.long	1988692435
	.long	598504198
	.long	3204219507
	.long	148362426
	.long	2795305890
	.long	1908447953
	.long	3977384870
	.long	1197008397
	.long	2113471718
	.long	296724853
	.long	1295644484
	.long	3816895906
	.long	3659802444
	.long	2394016794
	.long	4226943436
	.long	593449707
	.long	2591288968
	.long	3338824517
	.long	3024637593
	.long	493066293
	.long	4158919577
	.long	1186899415
	.long	887610640
	.long	2382681739
	.long	1754307891
	.long	986132586
	.long	4022871858
	.long	2373798830
	.long	1775221280
	.long	470396183
	.long	3508615783
	.long	1972265172
	.long	3750776420
	.long	452630365
	.long	3550442561
	.long	940792367
	.long	2722264270
	.long	3944530345
	.long	3206585544
	.long	905260731
	.long	2805917826
	.long	1881584735
	.long	1149561244
	.long	3594093395
	.long	2118203793
	.long	1810521462
	.long	1316868356
	.long	3763169470
	.long	2299122488
	.long	2893219494
	.long	4236407587
	.long	3621042925
	.long	2633736712
	.long	3231371645
	.long	303277681
	.long	1491471692
	.long	4177847879
	.long	2947118554
	.long	972506129
	.long	2167775995
	.long	606555363
	.long	2982943385
	.long	4060728462
	.long	1599269812
	.long	1945012259
	.long	40584695
	.long	1213110727
	.long	1670919475
	.long	3826489629
	.long	3198539624
	.long	3890024518
	.long	81169391
	.long	2426221454
	.long	3341838951
	.long	3358011962
	.long	2102111953
	.long	3485081741
	.long	162338783
	.long	557475612
	.long	2388710606
	.long	2421056629
	.long	4204223906
	.long	2675196186
	.long	324677567
	.long	1114951224
	.long	482453916
	.long	547145963
	.long	4113480516
	.long	1055425077
	.long	649355134
	.long	2229902448
	.long	964907833
	.long	1094291926
	.long	3931993737
	.long	2110850155
	.long	1298710268
	.long	164837600
	.long	1929815667
	.long	2188583852
	.long	3569020178
	.long	4221700311
	.long	2597420537
	.long	329675200
	.long	3859631335
	.long	82200408
	.long	2843073060
	.long	4148433327
	.long	899873778
	.long	659350401
	.long	3424295375
	.long	164400817
	.long	1391178824
	.long	4001899359
	.long	1799747556
	.long	1318700802
	.long	2553623455
	.long	328801635
	.long	2782357648
	.long	3708831422
	.long	3599495112
	.long	2637401604
	.long	812279614
	.long	657603271
	.long	1269748001
	.long	3122695549
	.long	2904022928
	.long	979835913
	.long	1624559229
	.long	1315206542
	.long	2539496002
	.long	1950423802
	.long	1513078560
	.long	1959671827
	.long	3249118458
	.long	2630413084
	.long	784024708
	.long	3900847605
	.long	3026157121
	.long	3919343654
	.long	2203269620
	.long	965858873
	.long	1568049417
	.long	3506727914
	.long	1757346946
	.long	3543720013
	.long	111571945
	.long	1931717747
	.long	3136098835
	.long	2718488532
	.long	3514693892
	.long	2792472730
	.long	223143890
	.long	3863435494
	.long	1977230375
	.long	1142009769
	.long	2734420489
	.long	1289978165
	.long	446287780
	.long	3431903692
	.long	3954460750
	.long	2284019538
	.long	1173873683
	.long	2579956331
	.long	892575561
	.long	2568840088
	.long	3613954205
	.long	273071781
	.long	2347747367
	.long	864945366
	.long	1785151123
	.long	842712880
	.long	2932941114
	.long	546143563
	.long	400527438
	.long	1729890733
	.long	3570302247
	.long	1685425760
	.long	1570914932
	.long	1092287127
	.long	801054876
	.long	3459781466
	.long	2845637198
	.long	3370851521
	.long	3141829865
	.long	2184574254
	.long	1602109753
	.long	2624595636
	.long	1396307100
	.long	2446735747
	.long	1988692435
	.long	74181213
	.long	3204219507
	.long	954223976
	.long	2792614201
	.long	598504198
	.long	3977384870
	.long	148362426
	.long	2113471718
	.long	1908447953
	.long	1290261106
	.long	1197008397
	.long	3659802444
	.long	296724853
	.long	4226943436
	.long	3816895906
	.long	2580522212
	.long	2394016794
	.long	3024637593
	.long	593449707
	.long	4158919577
	.long	3338824517
	.long	866077128
	.long	493066293
	.long	1754307891
	.long	1186899415
	.long	4022871858
	.long	2382681739
	.long	1732154256
	.long	986132586
	.long	3508615783
	.long	2373798830
	.long	3750776420
	.long	470396183
	.long	3464308513
	.long	1972265172
	.long	2722264270
	.long	452630365
	.long	3206585544
	.long	940792367
	.long	2633649730
	.long	3944530345
	.long	1149561244
	.long	905260731
	.long	2118203793
	.long	1881584735
	.long	972332164
	.long	3594093395
	.long	2299122488
	.long	1810521462
	.long	4236407587
	.long	3763169470
	.long	1944664328
	.long	2893219494
	.long	303277681
	.long	3621042925
	.long	4177847879
	.long	3231371645
	.long	3889328657
	.long	1491471692
	.long	606555363
	.long	2947118554
	.long	4060728462
	.long	2167775995
	.long	3483690018
	.long	2982943385
	.long	1213110727
	.long	1599269812
	.long	3826489629
	.long	40584695
	.long	2672412741
	.long	1670919475
	.long	2426221454
	.long	3198539624
	.long	3358011962
	.long	81169391
	.long	1049858187
	.long	3341838951
	.long	557475612
	.long	2102111953
	.long	2421056629
	.long	162338783
	.long	2099716375
	.long	2388710606
	.long	1114951224
	.long	4204223906
	.long	547145963
	.long	324677567
	.long	4199432751
	.long	482453916
	.long	2229902448
	.long	4113480516
	.long	1094291926
	.long	649355134
	.long	4103898207
	.long	964907833
	.long	164837600
	.long	3931993737
	.long	2188583852
	.long	1298710268
	.long	3912829119
	.long	1929815667
	.long	329675200
	.long	3569020178
	.long	82200408
	.long	2597420537
	.long	3530690942
	.long	3859631335
	.long	659350401
	.long	2843073060
	.long	164400817
	.long	899873778
	.long	2766414588
	.long	3424295375
	.long	1318700802
	.long	1391178824
	.long	328801635
	.long	1799747556
	.long	1237861880
	.long	2553623455
	.long	2637401604
	.long	2782357648
	.long	657603271
	.long	3599495112
	.long	2475723761
	.long	812279614
	.long	979835913
	.long	1269748001
	.long	1315206542
	.long	2904022928
	.long	656480226
	.long	1624559229
	.long	1959671827
	.long	2539496002
	.long	2630413084
	.long	1513078560
	.long	1312960453
	.long	3249118458
	.long	3919343654
	.long	784024708
	.long	965858873
	.long	3026157121
	.long	2625920907
	.long	2203269620
	.long	3543720013
	.long	1568049417
	.long	1931717747
	.long	1757346946
	.long	956874519
	.long	111571945
	.long	2792472730
	.long	3136098835
	.long	3863435494
	.long	3514693892
	.long	1913749038
	.long	223143890
	.long	1289978165
	.long	1977230375
	.long	3431903692
	.long	2734420489
	.long	3827498077
	.long	446287780
	.long	2579956331
	.long	3954460750
	.long	2568840088
	.long	1173873683
	.long	3360028859
	.long	892575561
	.long	864945366
	.long	3613954205
	.long	842712880
	.long	2347747367
	.long	2425090423
	.long	1785151123
	.long	1729890733
	.long	2932941114
	.long	1685425760
	.long	400527438
	.long	555213551
	.long	3570302247
	.long	3459781466
	.long	1570914932
	.long	3370851521
	.long	801054876
	.long	1110427102
	.long	2845637198
	.long	2624595636
	.long	3141829865
	.long	2446735747
	.long	1602109753
	.long	2220854205
	.long	1396307100
	.long	954223976
	.long	1988692435
	.long	598504198
	.long	3204219507
	.long	146741115
	.long	2792614201
	.long	1908447953
	.long	3977384870
	.long	1197008397
	.long	2113471718
	.long	293482231
	.long	1290261106
	.long	3816895906
	.long	3659802444
	.long	2394016794
	.long	4226943436
	.long	586964463
	.long	2580522212
	.long	3338824517
	.long	3024637593
	.long	493066293
	.long	4158919577
	.long	1173928927
	.long	866077128
	.long	2382681739
	.long	1754307891
	.long	986132586
	.long	4022871858
	.long	2347857855
	.long	1732154256
	.long	470396183
	.long	3508615783
	.long	1972265172
	.long	3750776420
	.long	400748414
	.long	3464308513
	.long	940792367
	.long	2722264270
	.long	3944530345
	.long	3206585544
	.long	801496828
	.long	2633649730
	.long	1881584735
	.long	1149561244
	.long	3594093395
	.long	2118203793
	.long	1602993657
	.long	972332164
	.long	3763169470
	.long	2299122488
	.long	2893219494
	.long	4236407587
	.long	3205987314
	.long	1944664328
	.long	3231371645
	.long	303277681
	.long	1491471692
	.long	4177847879
	.long	2117007332
	.long	3889328657
	.long	2167775995
	.long	606555363
	.long	2982943385
	.long	4060728462
	.long	4234014665
	.long	3483690018
	.long	40584695
	.long	1213110727
	.long	1670919475
	.long	3826489629
	.long	4173062034
	.long	2672412741
	.long	81169391
	.long	2426221454
	.long	3341838951
	.long	3358011962
	.long	4051156773
	.long	1049858187
	.long	162338783
	.long	557475612
	.long	2388710606
	.long	2421056629
	.long	3807346250
	.long	2099716375
	.long	324677567
	.long	1114951224
	.long	482453916
	.long	547145963
	.long	3319725204
	.long	4199432751
	.long	649355134
	.long	2229902448
	.long	964907833
	.long	1094291926
	.long	2344483112
	.long	4103898207
	.long	1298710268
	.long	164837600
	.long	1929815667
	.long	2188583852
	.long	393998928
	.long	3912829119
	.long	2597420537
	.long	329675200
	.long	3859631335
	.long	82200408
	.long	787997856
	.long	3530690942
	.long	899873778
	.long	659350401
	.long	3424295375
	.long	164400817
	.long	1575995713
	.long	2766414588
	.long	1799747556
	.long	1318700802
	.long	2553623455
	.long	328801635
	.long	3151991427
	.long	1237861880
	.long	3599495112
	.long	2637401604
	.long	812279614
	.long	657603271
	.long	2009015559
	.long	2475723761
	.long	2904022928
	.long	979835913
	.long	1624559229
	.long	1315206542
	.long	4018031118
	.long	656480226
	.long	1513078560
	.long	1959671827
	.long	3249118458
	.long	2630413084
	.long	3741094941
	.long	1312960453
	.long	3026157121
	.long	3919343654
	.long	2203269620
	.long	965858873
	.long	3187222587
	.long	2625920907
	.long	1757346946
	.long	3543720013
	.long	111571945
	.long	1931717747
	.long	2079477878
	.long	956874519
	.long	3514693892
	.long	2792472730
	.long	223143890
	.long	3863435494
	.long	4158955756
	.long	1913749038
	.long	2734420489
	.long	1289978165
	.long	446287780
	.long	3431903692
	.long	4022944216
	.long	3827498077
	.long	1173873683
	.long	2579956331
	.long	892575561
	.long	2568840088
	.long	3750921137
	.long	3360028859
	.long	2347747367
	.long	864945366
	.long	1785151123
	.long	842712880
	.long	3206874979
	.long	2425090423
	.long	400527438
	.long	1729890733
	.long	3570302247
	.long	1685425760
	.long	2118782663
	.long	555213551
	.long	801054876
	.long	3459781466
	.long	2845637198
	.long	3370851521
	.long	4237565327
	.long	1110427102
	.long	1602109753
	.long	2624595636
	.long	1396307100
	.long	2446735747
	.long	4180163359
	.long	2220854205
	.long	3204219507
	.long	954223976
	.long	2792614201
	.long	598504198
	.long	4065359423
	.long	146741115
	.long	2113471718
	.long	1908447953
	.long	1290261106
	.long	1197008397
	.long	3835751551
	.long	293482231
	.long	4226943436
	.long	3816895906
	.long	2580522212
	.long	2394016794
	.long	3376535807
	.long	586964463
	.long	4158919577
	.long	3338824517
	.long	866077128
	.long	493066293
	.long	2458104319
	.long	1173928927
	.long	4022871858
	.long	2382681739
	.long	1732154256
	.long	986132586
	.long	621241343
	.long	2347857855
	.long	3750776420
	.long	470396183
	.long	3464308513
	.long	1972265172
	.long	1242482686
	.long	400748414
	.long	3206585544
	.long	940792367
	.long	2633649730
	.long	3944530345
	.long	2484965372
	.long	801496828
	.long	2118203793
	.long	1881584735
	.long	972332164
	.long	3594093395
	.long	674963448
	.long	1602993657
	.long	4236407587
	.long	3763169470
	.long	1944664328
	.long	2893219494
	.long	1349926897
	.long	3205987314
	.long	4177847879
	.long	3231371645
	.long	3889328657
	.long	1491471692
	.long	2699853794
	.long	2117007332
	.long	4060728462
	.long	2167775995
	.long	3483690018
	.long	2982943385
	.long	1104740292
	.long	4234014665
	.long	3826489629
	.long	40584695
	.long	2672412741
	.long	1670919475
	.long	2209480585
	.long	4173062034
	.long	3358011962
	.long	81169391
	.long	1049858187
	.long	3341838951
	.long	123993874
	.long	4051156773
	.long	2421056629
	.long	162338783
	.long	2099716375
	.long	2388710606
	.long	247987749
	.long	3807346250
	.long	547145963
	.long	324677567
	.long	4199432751
	.long	482453916
	.long	495975499
	.long	3319725204
	.long	1094291926
	.long	649355134
	.long	4103898207
	.long	964907833
	.long	991950999
	.long	2344483112
	.long	2188583852
	.long	1298710268
	.long	3912829119
	.long	1929815667
	.long	1983901999
	.long	393998928
	.long	82200408
	.long	2597420537
	.long	3530690942
	.long	3859631335
	.long	3967803999
	.long	787997856
	.long	164400817
	.long	899873778
	.long	2766414588
	.long	3424295375
	.long	3640640703
	.long	1575995713
	.long	328801635
	.long	1799747556
	.long	1237861880
	.long	2553623455
	.long	2986314111
	.long	3151991427
	.long	657603271
	.long	3599495112
	.long	2475723761
	.long	812279614
	.long	1677660927
	.long	2009015559
	.long	1315206542
	.long	2904022928
	.long	656480226
	.long	1624559229
	.long	3355321855
	.long	4018031118
	.long	2630413084
	.long	1513078560
	.long	1312960453
	.long	3249118458
	.long	2415676415
	.long	3741094941
	.long	965858873
	.long	3026157121
	.long	2625920907
	.long	2203269620
	.long	536385535
	.long	3187222587
	.long	1931717747
	.long	1757346946
	.long	956874519
	.long	111571945
	.long	1072771071
	.long	2079477878
	.long	3863435494
	.long	3514693892
	.long	1913749038
	.long	223143890
	.long	2145542143
	.long	4158955756
	.long	3431903692
	.long	2734420489
	.long	3827498077
	.long	446287780
	.long	4291084286
	.long	4022944216
	.long	2568840088
	.long	1173873683
	.long	3360028859
	.long	892575561
	.long	4287201277
	.long	3750921137
	.long	842712880
	.long	2347747367
	.long	2425090423
	.long	1785151123
	.long	4279435259
	.long	3206874979
	.long	1685425760
	.long	400527438
	.long	555213551
	.long	3570302247
	.long	4263903223
	.long	2118782663
	.long	3370851521
	.long	801054876
	.long	1110427102
	.long	2845637198
	.long	4232839151
	.long	4237565327
	.long	2446735747
	.long	1602109753
	.long	2220854205
	.long	1396307100
	.long	4170711006
	.long	4180163359
	.long	598504198
	.long	3204219507
	.long	146741115
	.long	2792614201
	.long	4046454716
	.long	4065359423
	.long	1197008397
	.long	2113471718
	.long	293482231
	.long	1290261106
	.long	3797942136
	.long	3835751551
	.long	2394016794
	.long	4226943436
	.long	586964463
	.long	2580522212
	.long	3300916976
	.long	3376535807
	.long	493066293
	.long	4158919577
	.long	1173928927
	.long	866077128
	.long	2306866656
	.long	2458104319
	.long	986132586
	.long	4022871858
	.long	2347857855
	.long	1732154256
	.long	318766016
	.long	621241343
	.long	1972265172
	.long	3750776420
	.long	400748414
	.long	3464308513
	.long	637532033
	.long	1242482686
	.long	3944530345
	.long	3206585544
	.long	801496828
	.long	2633649730
	.long	1275064066
	.long	2484965372
	.long	3594093395
	.long	2118203793
	.long	1602993657
	.long	972332164
	.long	2550128133
	.long	674963448
	.long	2893219494
	.long	4236407587
	.long	3205987314
	.long	1944664328
	.long	805288971
	.long	1349926897
	.long	1491471692
	.long	4177847879
	.long	2117007332
	.long	3889328657
	.long	1610577942
	.long	2699853794
	.long	2982943385
	.long	4060728462
	.long	4234014665
	.long	3483690018
	.long	3221155884
	.long	1104740292
	.long	1670919475
	.long	3826489629
	.long	4173062034
	.long	2672412741
	.long	2147344473
	.long	2209480585
	.long	3341838951
	.long	3358011962
	.long	4051156773
	.long	1049858187
	.long	4294688947
	.long	123993874
	.long	2388710606
	.long	2421056629
	.long	3807346250
	.long	2099716375
	.long	4294410598
	.long	247987749
	.long	482453916
	.long	547145963
	.long	3319725204
	.long	4199432751
	.long	4293853900
	.long	495975499
	.long	964907833
	.long	1094291926
	.long	2344483112
	.long	4103898207
	.long	4292740504
	.long	991950999
	.long	1929815667
	.long	2188583852
	.long	393998928
	.long	3912829119
	.long	4290513712
	.long	1983901999
	.long	3859631335
	.long	82200408
	.long	787997856
	.long	3530690942
	.long	4286060128
	.long	3967803999
	.long	3424295375
	.long	164400817
	.long	1575995713
	.long	2766414588
	.long	4277152960
	.long	3640640703
	.long	2553623455
	.long	328801635
	.long	3151991427
	.long	1237861880
	.long	4259338624
	.long	2986314111
	.long	812279614
	.long	657603271
	.long	2009015559
	.long	2475723761
	.long	4223709953
	.long	1677660927
	.long	1624559229
	.long	1315206542
	.long	4018031118
	.long	656480226
	.long	4152452611
	.long	3355321855
	.long	3249118458
	.long	2630413084
	.long	3741094941
	.long	1312960453
	.long	4009937927
	.long	2415676415
	.long	2203269620
	.long	965858873
	.long	3187222587
	.long	2625920907
	.long	3724908559
	.long	536385535
	.long	111571945
	.long	1931717747
	.long	2079477878
	.long	956874519
	.long	3154849823
	.long	1072771071
	.long	223143890
	.long	3863435494
	.long	4158955756
	.long	1913749038
	.long	2014732351
	.long	2145542143
	.long	446287780
	.long	3431903692
	.long	4022944216
	.long	3827498077
	.long	4029464703
	.long	4291084286
	.long	892575561
	.long	2568840088
	.long	3750921137
	.long	3360028859
	.long	3763962110
	.long	4287201277
	.long	1785151123
	.long	842712880
	.long	3206874979
	.long	2425090423
	.long	3232956925
	.long	4279435259
	.long	3570302247
	.long	1685425760
	.long	2118782663
	.long	555213551
	.long	2170946555
	.long	4263903223
	.long	2845637198
	.long	3370851521
	.long	4237565327
	.long	1110427102
	.long	46925815
	.long	4232839151
	.long	1396307100
	.long	2446735747
	.long	4180163359
	.long	2220854205
	.long	93851631
	.long	4170711006
	.long	2792614201
	.long	598504198
	.long	4065359423
	.long	146741115
	.long	187703262
	.long	4046454716
	.long	1290261106
	.long	1197008397
	.long	3835751551
	.long	293482231
	.long	375406524
	.long	3797942136
	.long	2580522212
	.long	2394016794
	.long	3376535807
	.long	586964463
	.long	750813049
	.long	3300916976
	.long	866077128
	.long	493066293
	.long	2458104319
	.long	1173928927
	.long	1501626098
	.long	2306866656
	.long	1732154256
	.long	986132586
	.long	621241343
	.long	2347857855
	.long	3003252197
	.long	318766016
	.long	3464308513
	.long	1972265172
	.long	1242482686
	.long	400748414
	.long	1711537099
	.long	637532033
	.long	2633649730
	.long	3944530345
	.long	2484965372
	.long	801496828
	.long	3423074199
	.long	1275064066
	.long	972332164
	.long	3594093395
	.long	674963448
	.long	1602993657
	.long	2551181103
	.long	2550128133
	.long	1944664328
	.long	2893219494
	.long	1349926897
	.long	3205987314
	.long	807394910
	.long	805288971
	.long	3889328657
	.long	1491471692
	.long	2699853794
	.long	2117007332
	.long	1614789820
	.long	1610577942
	.long	3483690018
	.long	2982943385
	.long	1104740292
	.long	4234014665
	.long	3229579640
	.long	3221155884
	.long	2672412741
	.long	1670919475
	.long	2209480585
	.long	4173062034
	.long	2164191985
	.long	2147344473
	.long	1049858187
	.long	3341838951
	.long	123993874
	.long	4051156773
	.long	33416674
	.long	4294688947
	.long	2099716375
	.long	2388710606
	.long	247987749
	.long	3807346250
	.long	66833348
	.long	4294410598
	.long	4199432751
	.long	482453916
	.long	495975499
	.long	3319725204
	.long	133666696
	.long	4293853900
	.long	4103898207
	.long	964907833
	.long	991950999
	.long	2344483112
	.long	267333393
	.long	4292740504
	.long	3912829119
	.long	1929815667
	.long	1983901999
	.long	393998928
	.long	534666787
	.long	4290513712
	.long	3530690942
	.long	3859631335
	.long	3967803999
	.long	787997856
	.long	1069333574
	.long	4286060128
	.long	2766414588
	.long	3424295375
	.long	3640640703
	.long	1575995713
	.long	2138667148
	.long	4277152960
	.long	1237861880
	.long	2553623455
	.long	2986314111
	.long	3151991427
	.long	4277334296
	.long	4259338624
	.long	2475723761
	.long	812279614
	.long	1677660927
	.long	2009015559
	.long	4259701297
	.long	4223709953
	.long	656480226
	.long	1624559229
	.long	3355321855
	.long	4018031118
	.long	4224435298
	.long	4152452611
	.long	1312960453
	.long	3249118458
	.long	2415676415
	.long	3741094941
	.long	4153903301
	.long	4009937927
	.long	2625920907
	.long	2203269620
	.long	536385535
	.long	3187222587
	.long	4012839307
	.long	3724908559
	.long	956874519
	.long	111571945
	.long	1072771071
	.long	2079477878
	.long	3730711318
	.long	3154849823
	.long	1913749038
	.long	223143890
	.long	2145542143
	.long	4158955756
	.long	3166455341
	.long	2014732351
	.long	3827498077
	.long	446287780
	.long	4291084286
	.long	4022944216
	.long	2037943386
	.long	4029464703
	.long	3360028859
	.long	892575561
	.long	4287201277
	.long	3750921137
	.long	4075886773
	.long	3763962110
	.long	2425090423
	.long	1785151123
	.long	4279435259
	.long	3206874979
	.long	3856806251
	.long	3232956925
	.long	555213551
	.long	3570302247
	.long	4263903223
	.long	2118782663
	.long	3418645206
	.long	2170946555
	.long	1110427102
	.long	2845637198
	.long	4232839151
	.long	4237565327
	.long	2542323117
	.long	46925815
	.long	2220854205
	.long	1396307100
	.long	4170711006
	.long	4180163359
	.long	789678938
	.long	93851631
	.long	146741115
	.long	2792614201
	.long	4046454716
	.long	4065359423
	.long	1579357876
	.long	187703262
	.long	293482231
	.long	1290261106
	.long	3797942136
	.long	3835751551
	.long	3158715752
	.long	375406524
	.long	586964463
	.long	2580522212
	.long	3300916976
	.long	3376535807
	.long	2022464208
	.long	750813049
	.long	1173928927
	.long	866077128
	.long	2306866656
	.long	2458104319
	.long	4044928416
	.long	1501626098
	.long	2347857855
	.long	1732154256
	.long	318766016
	.long	621241343
	.long	3794889537
	.long	3003252197
	.long	400748414
	.long	3464308513
	.long	637532033
	.long	1242482686
	.long	3294811778
	.long	1711537099
	.long	801496828
	.long	2633649730
	.long	1275064066
	.long	2484965372
	.long	2294656261
	.long	3423074199
	.long	1602993657
	.long	972332164
	.long	2550128133
	.long	674963448
	.long	294345226
	.long	2551181103
	.long	3205987314
	.long	1944664328
	.long	805288971
	.long	1349926897
	.long	588690452
	.long	807394910
	.long	2117007332
	.long	3889328657
	.long	1610577942
	.long	2699853794
	.long	1177380905
	.long	1614789820
	.long	4234014665
	.long	3483690018
	.long	3221155884
	.long	1104740292
	.long	2354761811
	.long	3229579640
	.long	4173062034
	.long	2672412741
	.long	2147344473
	.long	2209480585
	.long	414556326
	.long	2164191985
	.long	4051156773
	.long	1049858187
	.long	4294688947
	.long	123993874
	.long	829112653
	.long	33416674
	.long	3807346250
	.long	2099716375
	.long	4294410598
	.long	247987749
	.long	1658225307
	.long	66833348
	.long	3319725204
	.long	4199432751
	.long	4293853900
	.long	495975499
	.long	3316450614
	.long	133666696
	.long	2344483112
	.long	4103898207
	.long	4292740504
	.long	991950999
	.long	2337933933
	.long	267333393
	.long	393998928
	.long	3912829119
	.long	4290513712
	.long	1983901999
	.long	380900570
	.long	534666787
	.long	787997856
	.long	3530690942
	.long	4286060128
	.long	3967803999
	.long	761801140
	.long	1069333574
	.long	1575995713
	.long	2766414588
	.long	4277152960
	.long	3640640703
	.long	1523602280
	.long	2138667148
	.long	3151991427
	.long	1237861880
	.long	4259338624
	.long	2986314111
	.long	3047204561
	.long	4277334296
	.long	2009015559
	.long	2475723761
	.long	4223709953
	.long	1677660927
	.long	1799441827
	.long	4259701297
	.long	4018031118
	.long	656480226
	.long	4152452611
	.long	3355321855
	.long	3598883655
	.long	4224435298
	.long	3741094941
	.long	1312960453
	.long	4009937927
	.long	2415676415
	.long	2902800015
	.long	4153903301
	.long	3187222587
	.long	2625920907
	.long	3724908559
	.long	536385535
	.long	1510632735
	.long	4012839307
	.long	2079477878
	.long	956874519
	.long	3154849823
	.long	1072771071
	.long	3021265470
	.long	3730711318
	.long	4158955756
	.long	1913749038
	.long	2014732351
	.long	2145542143
	.long	1747563645
	.long	3166455341
	.long	4022944216
	.long	3827498077
	.long	4029464703
	.long	4291084286
	.long	3495127291
	.long	2037943386
	.long	3750921137
	.long	3360028859
	.long	3763962110
	.long	4287201277
	.long	2695287286
	.long	4075886773
	.long	3206874979
	.long	2425090423
	.long	3232956925
	.long	4279435259
	.long	1095607277
	.long	3856806251
	.long	2118782663
	.long	555213551
	.long	2170946555
	.long	4263903223
	.long	2191214555
	.long	3418645206
	.long	4237565327
	.long	1110427102
	.long	46925815
	.long	4232839151
	.long	87461814
	.long	2542323117
	.long	4180163359
	.long	2220854205
	.long	93851631
	.long	4170711006
	.long	174923629
	.long	789678938
	.long	4065359423
	.long	146741115
	.long	187703262
	.long	4046454716
	.long	349847258
	.long	1579357876
	.long	3835751551
	.long	293482231
	.long	375406524
	.long	3797942136
	.long	699694516
	.long	3158715752
	.long	3376535807
	.long	586964463
	.long	750813049
	.long	3300916976
	.long	1399389033
	.long	2022464208
	.long	2458104319
	.long	1173928927
	.long	1501626098
	.long	2306866656
	.long	2798778067
	.long	4044928416
	.long	621241343
	.long	2347857855
	.long	3003252197
	.long	318766016
	.long	1302588838
	.long	3794889537
	.long	1242482686
	.long	400748414
	.long	1711537099
	.long	637532033
	.long	2605177677
	.long	3294811778
	.long	2484965372
	.long	801496828
	.long	3423074199
	.long	1275064066
	.long	915388059
	.long	2294656261
	.long	674963448
	.long	1602993657
	.long	2551181103
	.long	2550128133
	.long	1830776118
	.long	294345226
	.long	1349926897
	.long	3205987314
	.long	807394910
	.long	805288971
	.long	3661552236
	.long	588690452
	.long	2699853794
	.long	2117007332
	.long	1614789820
	.long	1610577942
	.long	3028137177
	.long	1177380905
	.long	1104740292
	.long	4234014665
	.long	3229579640
	.long	3221155884
	.long	1761307059
	.long	2354761811
	.long	2209480585
	.long	4173062034
	.long	2164191985
	.long	2147344473
	.long	3522614119
	.long	414556326
	.long	123993874
	.long	4051156773
	.long	33416674
	.long	4294688947
	.long	2750260943
	.long	829112653
	.long	247987749
	.long	3807346250
	.long	66833348
	.long	4294410598
	.long	1205554591
	.long	1658225307
	.long	495975499
	.long	3319725204
	.long	133666696
	.long	4293853900
	.long	2411109183
	.long	3316450614
	.long	991950999
	.long	2344483112
	.long	267333393
	.long	4292740504
	.long	527251070
	.long	2337933933
	.long	1983901999
	.long	393998928
	.long	534666787
	.long	4290513712
	.long	1054502141
	.long	380900570
	.long	3967803999
	.long	787997856
	.long	1069333574
	.long	4286060128
	.long	2109004283
	.long	761801140
	.long	3640640703
	.long	1575995713
	.long	2138667148
	.long	4277152960
	.long	4218008566
	.long	1523602280
	.long	2986314111
	.long	3151991427
	.long	4277334296
	.long	4259338624
	.long	4141049836
	.long	3047204561
	.long	1677660927
	.long	2009015559
	.long	4259701297
	.long	4223709953
	.long	3987132377
	.long	1799441827
	.long	3355321855
	.long	4018031118
	.long	4224435298
	.long	4152452611
	.long	3679297459
	.long	3598883655
	.long	2415676415
	.long	3741094941
	.long	4153903301
	.long	4009937927
	.long	3063627623
	.long	2902800015
	.long	536385535
	.long	3187222587
	.long	4012839307
	.long	3724908559
	.long	1832287951
	.long	1510632735
	.long	1072771071
	.long	2079477878
	.long	3730711318
	.long	3154849823
	.long	3664575902
	.long	3021265470
	.long	2145542143
	.long	4158955756
	.long	3166455341
	.long	2014732351
	.long	3034184508
	.long	1747563645
	.long	4291084286
	.long	4022944216
	.long	2037943386
	.long	4029464703
	.long	1773401721
	.long	3495127291
	.long	4287201277
	.long	3750921137
	.long	4075886773
	.long	3763962110
	.long	3546803442
	.long	2695287286
	.long	4279435259
	.long	3206874979
	.long	3856806251
	.long	3232956925
	.long	2798639588
	.long	1095607277
	.long	4263903223
	.long	2118782663
	.long	3418645206
	.long	2170946555
	.long	1302311881
	.long	2191214555
	.long	4232839151
	.long	4237565327
	.long	2542323117
	.long	46925815
	.long	2604623763
	.long	87461814
	.long	4170711006
	.long	4180163359
	.long	789678938
	.long	93851631
	.long	914280231
	.long	174923629
	.long	4046454716
	.long	4065359423
	.long	1579357876
	.long	187703262
	.long	1828560463
	.long	349847258
	.long	3797942136
	.long	3835751551
	.long	3158715752
	.long	375406524
	.long	3657120927
	.long	699694516
	.long	3300916976
	.long	3376535807
	.long	2022464208
	.long	750813049
	.long	3019274558
	.long	1399389033
	.long	2306866656
	.long	2458104319
	.long	4044928416
	.long	1501626098
	.long	1743581820
	.long	2798778067
	.long	318766016
	.long	621241343
	.long	3794889537
	.long	3003252197
	.long	3487163641
	.long	1302588838
	.long	637532033
	.long	1242482686
	.long	3294811778
	.long	1711537099
	.long	2679359986
	.long	2605177677
	.long	1275064066
	.long	2484965372
	.long	2294656261
	.long	3423074199
	.long	1063752677
	.long	915388059
	.long	2550128133
	.long	674963448
	.long	294345226
	.long	2551181103
	.long	2127505355
	.long	1830776118
	.long	805288971
	.long	1349926897
	.long	588690452
	.long	807394910
	.long	4255010710
	.long	3661552236
	.long	1610577942
	.long	2699853794
	.long	1177380905
	.long	1614789820
	.long	4215054124
	.long	3028137177
	.long	3221155884
	.long	1104740292
	.long	2354761811
	.long	3229579640
	.long	4135140952
	.long	1761307059
	.long	2147344473
	.long	2209480585
	.long	414556326
	.long	2164191985
	.long	3975314608
	.long	3522614119
	.long	4294688947
	.long	123993874
	.long	829112653
	.long	33416674
	.long	3655661921
	.long	2750260943
	.long	4294410598
	.long	247987749
	.long	1658225307
	.long	66833348
	.long	3016356546
	.long	1205554591
	.long	4293853900
	.long	495975499
	.long	3316450614
	.long	133666696
	.long	1737745796
	.long	2411109183
	.long	4292740504
	.long	991950999
	.long	2337933933
	.long	267333393
	.long	3475491593
	.long	527251070
	.long	4290513712
	.long	1983901999
	.long	380900570
	.long	534666787
	.long	2656015891
	.long	1054502141
	.long	4286060128
	.long	3967803999
	.long	761801140
	.long	1069333574
	.long	1017064486
	.long	2109004283
	.long	4277152960
	.long	3640640703
	.long	1523602280
	.long	2138667148
	.long	2034128973
	.long	4218008566
	.long	4259338624
	.long	2986314111
	.long	3047204561
	.long	4277334296
	.long	4068257947
	.long	4141049836
	.long	4223709953
	.long	1677660927
	.long	1799441827
	.long	4259701297
	.long	3841548598
	.long	3987132377
	.long	4152452611
	.long	3355321855
	.long	3598883655
	.long	4224435298
	.long	3388129901
	.long	3679297459
	.long	4009937927
	.long	2415676415
	.long	2902800015
	.long	4153903301
	.long	2481292507
	.long	3063627623
	.long	3724908559
	.long	536385535
	.long	1510632735
	.long	4012839307
	.long	667617719
	.long	1832287951
	.long	3154849823
	.long	1072771071
	.long	3021265470
	.long	3730711318
	.long	1335235438
	.long	3664575902
	.long	2014732351
	.long	2145542143
	.long	1747563645
	.long	3166455341
	.long	2670470877
	.long	3034184508
	.long	4029464703
	.long	4291084286
	.long	3495127291
	.long	2037943386
	.long	1045974458
	.long	1773401721
	.long	3763962110
	.long	4287201277
	.long	2695287286
	.long	4075886773
	.long	2091948916
	.long	3546803442
	.long	3232956925
	.long	4279435259
	.long	1095607277
	.long	3856806251
	.long	4183897833
	.long	2798639588
	.long	2170946555
	.long	4263903223
	.long	2191214555
	.long	3418645206
	.long	4072828371
	.long	1302311881
	.long	46925815
	.long	4232839151
	.long	87461814
	.long	2542323117
	.long	3850689447
	.long	2604623763
	.long	93851631
	.long	4170711006
	.long	174923629
	.long	789678938
	.long	3406411599
	.long	914280231
	.long	187703262
	.long	4046454716
	.long	349847258
	.long	1579357876
	.long	2517855902
	.long	1828560463
	.long	375406524
	.long	3797942136
	.long	699694516
	.long	3158715752
	.long	740744509
	.long	3657120927
	.long	750813049
	.long	3300916976
	.long	1399389033
	.long	2022464208
	.long	1481489018
	.long	3019274558
	.long	1501626098
	.long	2306866656
	.long	2798778067
	.long	4044928416
	.long	2962978036
	.long	1743581820
	.long	3003252197
	.long	318766016
	.long	1302588838
	.long	3794889537
	.long	1630988776
	.long	3487163641
	.long	1711537099
	.long	637532033
	.long	2605177677
	.long	3294811778
	.long	3261977553
	.long	2679359986
	.long	3423074199
	.long	1275064066
	.long	915388059
	.long	2294656261
	.long	2228987811
	.long	1063752677
	.long	2551181103
	.long	2550128133
	.long	1830776118
	.long	294345226
	.long	163008326
	.long	2127505355
	.long	807394910
	.long	805288971
	.long	3661552236
	.long	588690452
	.long	326016652
	.long	4255010710
	.long	1614789820
	.long	1610577942
	.long	3028137177
	.long	1177380905
	.long	652033304
	.long	4215054124
	.long	3229579640
	.long	3221155884
	.long	1761307059
	.long	2354761811
	.long	1304066609
	.long	4135140952
	.long	2164191985
	.long	2147344473
	.long	3522614119
	.long	414556326
	.long	2608133219
	.long	3975314608
	.long	33416674
	.long	4294688947
	.long	2750260943
	.long	829112653
	.long	921299143
	.long	3655661921
	.long	66833348
	.long	4294410598
	.long	1205554591
	.long	1658225307
	.long	1842598287
	.long	3016356546
	.long	133666696
	.long	4293853900
	.long	2411109183
	.long	3316450614
	.long	3685196575
	.long	1737745796
	.long	267333393
	.long	4292740504
	.long	527251070
	.long	2337933933
	.long	3075425855
	.long	3475491593
	.long	534666787
	.long	4290513712
	.long	1054502141
	.long	380900570
	.long	1855884414
	.long	2656015891
	.long	1069333574
	.long	4286060128
	.long	2109004283
	.long	761801140
	.long	3711768829
	.long	1017064486
	.long	2138667148
	.long	4277152960
	.long	4218008566
	.long	1523602280
	.long	3128570363
	.long	2034128973
	.long	4277334296
	.long	4259338624
	.long	4141049836
	.long	3047204561
	.long	1962173430
	.long	4068257947
	.long	4259701297
	.long	4223709953
	.long	3987132377
	.long	1799441827
	.long	3924346860
	.long	3841548598
	.long	4224435298
	.long	4152452611
	.long	3679297459
	.long	3598883655
	.long	3553726425
	.long	3388129901
	.long	4153903301
	.long	4009937927
	.long	3063627623
	.long	2902800015
	.long	2812485555
	.long	2481292507
	.long	4012839307
	.long	3724908559
	.long	1832287951
	.long	1510632735
	.long	1330003814
	.long	667617719
	.long	3730711318
	.long	3154849823
	.long	3664575902
	.long	3021265470
	.long	2660007629
	.long	1335235438
	.long	3166455341
	.long	2014732351
	.long	3034184508
	.long	1747563645
	.long	1025047962
	.long	2670470877
	.long	2037943386
	.long	4029464703
	.long	1773401721
	.long	3495127291
	.long	2050095924
	.long	1045974458
	.long	4075886773
	.long	3763962110
	.long	3546803442
	.long	2695287286
	.long	4100191849
	.long	2091948916
	.long	3856806251
	.long	3232956925
	.long	2798639588
	.long	1095607277
	.long	3905416403
	.long	4183897833
	.long	3418645206
	.long	2170946555
	.long	1302311881
	.long	2191214555
	.long	3515865511
	.long	4072828371
	.long	2542323117
	.long	46925815
	.long	2604623763
	.long	87461814
	.long	2736763727
	.long	3850689447
	.long	789678938
	.long	93851631
	.long	914280231
	.long	174923629
	.long	1178560158
	.long	3406411599
	.long	1579357876
	.long	187703262
	.long	1828560463
	.long	349847258
	.long	2357120316
	.long	2517855902
	.long	3158715752
	.long	375406524
	.long	3657120927
	.long	699694516
	.long	419273337
	.long	740744509
	.long	2022464208
	.long	750813049
	.long	3019274558
	.long	1399389033
	.long	838546674
	.long	1481489018
	.long	4044928416
	.long	1501626098
	.long	1743581820
	.long	2798778067
	.long	1677093349
	.long	2962978036
	.long	3794889537
	.long	3003252197
	.long	3487163641
	.long	1302588838
	.long	3354186699
	.long	1630988776
	.long	3294811778
	.long	1711537099
	.long	2679359986
	.long	2605177677
	.long	2413406103
	.long	3261977553
	.long	2294656261
	.long	3423074199
	.long	1063752677
	.long	915388059
	.long	531844911
	.long	2228987811
	.long	294345226
	.long	2551181103
	.long	2127505355
	.long	1830776118
	.long	1063689823
	.long	163008326
	.long	588690452
	.long	807394910
	.long	4255010710
	.long	3661552236
	.long	2127379647
	.long	326016652
	.long	1177380905
	.long	1614789820
	.long	4215054124
	.long	3028137177
	.long	4254759295
	.long	652033304
	.long	2354761811
	.long	3229579640
	.long	4135140952
	.long	1761307059
	.long	4214551295
	.long	1304066609
	.long	414556326
	.long	2164191985
	.long	3975314608
	.long	3522614119
	.long	4134135294
	.long	2608133219
	.long	829112653
	.long	33416674
	.long	3655661921
	.long	2750260943
	.long	3973303293
	.long	921299143
	.long	1658225307
	.long	66833348
	.long	3016356546
	.long	1205554591
	.long	3651639290
	.long	1842598287
	.long	3316450614
	.long	133666696
	.long	1737745796
	.long	2411109183
	.long	3008311285
	.long	3685196575
	.long	2337933933
	.long	267333393
	.long	3475491593
	.long	527251070
	.long	1721655274
	.long	3075425855
	.long	380900570
	.long	534666787
	.long	2656015891
	.long	1054502141
	.long	3443310548
	.long	1855884414
	.long	761801140
	.long	1069333574
	.long	1017064486
	.long	2109004283
	.long	2591653800
	.long	3711768829
	.long	1523602280
	.long	2138667148
	.long	2034128973
	.long	4218008566
	.long	888340305
	.long	3128570363
	.long	3047204561
	.long	4277334296
	.long	4068257947
	.long	4141049836
	.long	1776680610
	.long	1962173430
	.long	1799441827
	.long	4259701297
	.long	3841548598
	.long	3987132377
	.long	3553361221
	.long	3924346860
	.long	3598883655
	.long	4224435298
	.long	3388129901
	.long	3679297459
	.long	2811755147
	.long	3553726425
	.long	2902800015
	.long	4153903301
	.long	2481292507
	.long	3063627623
	.long	1328542998
	.long	2812485555
	.long	1510632735
	.long	4012839307
	.long	667617719
	.long	1832287951
	.long	2657085997
	.long	1330003814
	.long	3021265470
	.long	3730711318
	.long	1335235438
	.long	3664575902
	.long	1019204698
	.long	2660007629
	.long	1747563645
	.long	3166455341
	.long	2670470877
	.long	3034184508
	.long	2038409397
	.long	1025047962
	.long	3495127291
	.long	2037943386
	.long	1045974458
	.long	1773401721
	.long	4076818795
	.long	2050095924
	.long	2695287286
	.long	4075886773
	.long	2091948916
	.long	3546803442
	.long	3858670295
	.long	4100191849
	.long	1095607277
	.long	3856806251
	.long	4183897833
	.long	2798639588
	.long	3422373294
	.long	3905416403
	.long	2191214555
	.long	3418645206
	.long	4072828371
	.long	1302311881
	.long	2549779293
	.long	3515865511
	.long	87461814
	.long	2542323117
	.long	3850689447
	.long	2604623763
	.long	804591290
	.long	2736763727
	.long	174923629
	.long	789678938
	.long	3406411599
	.long	914280231
	.long	1609182581
	.long	1178560158
	.long	349847258
	.long	1579357876
	.long	2517855902
	.long	1828560463
	.long	3218365162
	.long	2357120316
	.long	699694516
	.long	3158715752
	.long	740744509
	.long	3657120927
	.long	2141763028
	.long	419273337
	.long	1399389033
	.long	2022464208
	.long	1481489018
	.long	3019274558
	.long	4283526057
	.long	838546674
	.long	2798778067
	.long	4044928416
	.long	2962978036
	.long	1743581820
	.long	4272084818
	.long	1677093349
	.long	1302588838
	.long	3794889537
	.long	1630988776
	.long	3487163641
	.long	4249202340
	.long	3354186699
	.long	2605177677
	.long	3294811778
	.long	3261977553
	.long	2679359986
	.long	4203437385
	.long	2413406103
	.long	915388059
	.long	2294656261
	.long	2228987811
	.long	1063752677
	.long	4111907475
	.long	531844911
	.long	1830776118
	.long	294345226
	.long	163008326
	.long	2127505355
	.long	3928847655
	.long	1063689823
	.long	3661552236
	.long	588690452
	.long	326016652
	.long	4255010710
	.long	3562728015
	.long	2127379647
	.long	3028137177
	.long	1177380905
	.long	652033304
	.long	4215054124
	.long	2830488734
	.long	4254759295
	.long	1761307059
	.long	2354761811
	.long	1304066609
	.long	4135140952
	.long	1366010173
	.long	4214551295
	.long	3522614119
	.long	414556326
	.long	2608133219
	.long	3975314608
	.long	2732020347
	.long	4134135294
	.long	2750260943
	.long	829112653
	.long	921299143
	.long	3655661921
	.long	1169073399
	.long	3973303293
	.long	1205554591
	.long	1658225307
	.long	1842598287
	.long	3016356546
	.long	2338146798
	.long	3651639290
	.long	2411109183
	.long	3316450614
	.long	3685196575
	.long	1737745796
	.long	381326301
	.long	3008311285
	.long	527251070
	.long	2337933933
	.long	3075425855
	.long	3475491593
	.long	762652602
	.long	1721655274
	.long	1054502141
	.long	380900570
	.long	1855884414
	.long	2656015891
	.long	1525305205
	.long	3443310548
	.long	2109004283
	.long	761801140
	.long	3711768829
	.long	1017064486
	.long	3050610411
	.long	2591653800
	.long	4218008566
	.long	1523602280
	.long	3128570363
	.long	2034128973
	.long	1806253526
	.long	888340305
	.long	4141049836
	.long	3047204561
	.long	1962173430
	.long	4068257947
	.long	3612507052
	.long	1776680610
	.long	3987132377
	.long	1799441827
	.long	3924346860
	.long	3841548598
	.long	2930046808
	.long	3553361221
	.long	3679297459
	.long	3598883655
	.long	3553726425
	.long	3388129901
	.long	1565126321
	.long	2811755147
	.long	3063627623
	.long	2902800015
	.long	2812485555
	.long	2481292507
	.long	3130252643
	.long	1328542998
	.long	1832287951
	.long	1510632735
	.long	1330003814
	.long	667617719
	.long	1965537991
	.long	2657085997
	.long	3664575902
	.long	3021265470
	.long	2660007629
	.long	1335235438
	.long	3931075983
	.long	1019204698
	.long	3034184508
	.long	1747563645
	.long	1025047962
	.long	2670470877
	.long	3567184671
	.long	2038409397
	.long	1773401721
	.long	3495127291
	.long	2050095924
	.long	1045974458
	.long	2839402047
	.long	4076818795
	.long	3546803442
	.long	2695287286
	.long	4100191849
	.long	2091948916
	.long	1383836798
	.long	3858670295
	.long	2798639588
	.long	1095607277
	.long	3905416403
	.long	4183897833
	.long	2767673597
	.long	3422373294
	.long	1302311881
	.long	2191214555
	.long	3515865511
	.long	4072828371
	.long	1240379898
	.long	2549779293
	.long	2604623763
	.long	87461814
	.long	2736763727
	.long	3850689447
	.long	2480759797
	.long	804591290
	.long	914280231
	.long	174923629
	.long	1178560158
	.long	3406411599
	.long	666552299
	.long	1609182581
	.long	1828560463
	.long	349847258
	.long	2357120316
	.long	2517855902
	.long	1333104599
	.long	3218365162
	.long	3657120927
	.long	699694516
	.long	419273337
	.long	740744509
	.long	2666209199
	.long	2141763028
	.long	3019274558
	.long	1399389033
	.long	838546674
	.long	1481489018
	.long	1037451103
	.long	4283526057
	.long	1743581820
	.long	2798778067
	.long	1677093349
	.long	2962978036
	.long	2074902206
	.long	4272084818
	.long	3487163641
	.long	1302588838
	.long	3354186699
	.long	1630988776
	.long	4149804412
	.long	4249202340
	.long	2679359986
	.long	2605177677
	.long	2413406103
	.long	3261977553
	.long	4004641529
	.long	4203437385
	.long	1063752677
	.long	915388059
	.long	531844911
	.long	2228987811
	.long	3714315762
	.long	4111907475
	.long	2127505355
	.long	1830776118
	.long	1063689823
	.long	163008326
	.long	3133664229
	.long	3928847655
	.long	4255010710
	.long	3661552236
	.long	2127379647
	.long	326016652
	.long	1972361163
	.long	3562728015
	.long	4215054124
	.long	3028137177
	.long	4254759295
	.long	652033304
	.long	3944722327
	.long	2830488734
	.long	4135140952
	.long	1761307059
	.long	4214551295
	.long	1304066609
	.long	3594477359
	.long	1366010173
	.long	3975314608
	.long	3522614119
	.long	4134135294
	.long	2608133219
	.long	2893987423
	.long	2732020347
	.long	3655661921
	.long	2750260943
	.long	3973303293
	.long	921299143
	.long	1493007550
	.long	1169073399
	.long	3016356546
	.long	1205554591
	.long	3651639290
	.long	1842598287
	.long	2986015100
	.long	2338146798
	.long	1737745796
	.long	2411109183
	.long	3008311285
	.long	3685196575
	.long	1677062904
	.long	381326301
	.long	3475491593
	.long	527251070
	.long	1721655274
	.long	3075425855
	.long	3354125809
	.long	762652602
	.long	2656015891
	.long	1054502141
	.long	3443310548
	.long	1855884414
	.long	2413284322
	.long	1525305205
	.long	1017064486
	.long	2109004283
	.long	2591653800
	.long	3711768829
	.long	531601349
	.long	3050610411
	.long	2034128973
	.long	4218008566
	.long	888340305
	.long	3128570363
	.long	1063202699
	.long	1806253526
	.long	4068257947
	.long	4141049836
	.long	1776680610
	.long	1962173430
	.long	2126405399
	.long	3612507052
	.long	3841548598
	.long	3987132377
	.long	3553361221
	.long	3924346860
	.long	4252810799
	.long	2930046808
	.long	3388129901
	.long	3679297459
	.long	2811755147
	.long	3553726425
	.long	4210654302
	.long	1565126321
	.long	2481292507
	.long	3063627623
	.long	1328542998
	.long	2812485555
	.long	4126341309
	.long	3130252643
	.long	667617719
	.long	1832287951
	.long	2657085997
	.long	1330003814
	.long	3957715323
	.long	1965537991
	.long	1335235438
	.long	3664575902
	.long	1019204698
	.long	2660007629
	.long	3620463350
	.long	3931075983
	.long	2670470877
	.long	3034184508
	.long	2038409397
	.long	1025047962
	.long	2945959404
	.long	3567184671
	.long	1045974458
	.long	1773401721
	.long	4076818795
	.long	2050095924
	.long	1596951513
	.long	2839402047
	.long	2091948916
	.long	3546803442
	.long	3858670295
	.long	4100191849
	.long	3193903027
	.long	1383836798
	.long	4183897833
	.long	2798639588
	.long	3422373294
	.long	3905416403
	.long	2092838759
	.long	2767673597
	.long	4072828371
	.long	1302311881
	.long	2549779293
	.long	3515865511
	.long	4185677519
	.long	1240379898
	.long	3850689447
	.long	2604623763
	.long	804591290
	.long	2736763727
	.long	4076387742
	.long	2480759797
	.long	3406411599
	.long	914280231
	.long	1609182581
	.long	1178560158
	.long	3857808189
	.long	666552299
	.long	2517855902
	.long	1828560463
	.long	3218365162
	.long	2357120316
	.long	3420649082
	.long	1333104599
	.long	740744509
	.long	3657120927
	.long	2141763028
	.long	419273337
	.long	2546330868
	.long	2666209199
	.long	1481489018
	.long	3019274558
	.long	4283526057
	.long	838546674
	.long	797694440
	.long	1037451103
	.long	2962978036
	.long	1743581820
	.long	4272084818
	.long	1677093349
	.long	1595388880
	.long	2074902206
	.long	1630988776
	.long	3487163641
	.long	4249202340
	.long	3354186699
	.long	3190777760
	.long	4149804412
	.long	3261977553
	.long	2679359986
	.long	4203437385
	.long	2413406103
	.long	2086588225
	.long	4004641529
	.long	2228987811
	.long	1063752677
	.long	4111907475
	.long	531844911
	.long	4173176451
	.long	3714315762
	.long	163008326
	.long	2127505355
	.long	3928847655
	.long	1063689823
	.long	4051385607
	.long	3133664229
	.long	326016652
	.long	4255010710
	.long	3562728015
	.long	2127379647
	.long	3807803918
	.long	1972361163
	.long	652033304
	.long	4215054124
	.long	2830488734
	.long	4254759295
	.long	3320640540
	.long	3944722327
	.long	1304066609
	.long	4135140952
	.long	1366010173
	.long	4214551295
	.long	2346313785
	.long	3594477359
	.long	2608133219
	.long	3975314608
	.long	2732020347
	.long	4134135294
	.long	397660275
	.long	2893987423
	.long	921299143
	.long	3655661921
	.long	1169073399
	.long	3973303293
	.long	795320551
	.long	1493007550
	.long	1842598287
	.long	3016356546
	.long	2338146798
	.long	3651639290
	.long	1590641102
	.long	2986015100
	.long	3685196575
	.long	1737745796
	.long	381326301
	.long	3008311285
	.long	3181282204
	.long	1677062904
	.long	3075425855
	.long	3475491593
	.long	762652602
	.long	1721655274
	.long	2067597113
	.long	3354125809
	.long	1855884414
	.long	2656015891
	.long	1525305205
	.long	3443310548
	.long	4135194227
	.long	2413284322
	.long	3711768829
	.long	1017064486
	.long	3050610411
	.long	2591653800
	.long	3975421159
	.long	531601349
	.long	3128570363
	.long	2034128973
	.long	1806253526
	.long	888340305
	.long	3655875023
	.long	1063202699
	.long	1962173430
	.long	4068257947
	.long	3612507052
	.long	1776680610
	.long	3016782751
	.long	2126405399
	.long	3924346860
	.long	3841548598
	.long	2930046808
	.long	3553361221
	.long	1738598206
	.long	4252810799
	.long	3553726425
	.long	3388129901
	.long	1565126321
	.long	2811755147
	.long	3477196413
	.long	4210654302
	.long	2812485555
	.long	2481292507
	.long	3130252643
	.long	1328542998
	.long	2659425531
	.long	4126341309
	.long	1330003814
	.long	667617719
	.long	1965537991
	.long	2657085997
	.long	1023883767
	.long	3957715323
	.long	2660007629
	.long	1335235438
	.long	3931075983
	.long	1019204698
	.long	2047767535
	.long	3620463350
	.long	1025047962
	.long	2670470877
	.long	3567184671
	.long	2038409397
	.long	4095535070
	.long	2945959404
	.long	2050095924
	.long	1045974458
	.long	2839402047
	.long	4076818795
	.long	3896102844
	.long	1596951513
	.long	4100191849
	.long	2091948916
	.long	1383836798
	.long	3858670295
	.long	3497238392
	.long	3193903027
	.long	3905416403
	.long	4183897833
	.long	2767673597
	.long	3422373294
	.long	2699509489
	.long	2092838759
	.long	3515865511
	.long	4072828371
	.long	1240379898
	.long	2549779293
	.long	1104051682
	.long	4185677519
	.long	2736763727
	.long	3850689447
	.long	2480759797
	.long	804591290
	.long	2208103365
	.long	4076387742
	.long	1178560158
	.long	3406411599
	.long	666552299
	.long	1609182581
	.long	121239434
	.long	3857808189
	.long	2357120316
	.long	2517855902
	.long	1333104599
	.long	3218365162
	.long	242478868
	.long	3420649082
	.long	419273337
	.long	740744509
	.long	2666209199
	.long	2141763028
	.long	484957737
	.long	2546330868
	.long	838546674
	.long	1481489018
	.long	1037451103
	.long	4283526057
	.long	969915474
	.long	797694440
	.long	1677093349
	.long	2962978036
	.long	2074902206
	.long	4272084818
	.long	1939830949
	.long	1595388880
	.long	3354186699
	.long	1630988776
	.long	4149804412
	.long	4249202340
	.long	3879661898
	.long	3190777760
	.long	2413406103
	.long	3261977553
	.long	4004641529
	.long	4203437385
	.long	3464356500
	.long	2086588225
	.long	531844911
	.long	2228987811
	.long	3714315762
	.long	4111907475
	.long	2633745705
	.long	4173176451
	.long	1063689823
	.long	163008326
	.long	3133664229
	.long	3928847655
	.long	972524114
	.long	4051385607
	.long	2127379647
	.long	326016652
	.long	1972361163
	.long	3562728015
	.long	1945048229
	.long	3807803918
	.long	4254759295
	.long	652033304
	.long	3944722327
	.long	2830488734
	.long	3890096458
	.long	3320640540
	.long	4214551295
	.long	1304066609
	.long	3594477359
	.long	1366010173
	.long	3485225620
	.long	2346313785
	.long	4134135294
	.long	2608133219
	.long	2893987423
	.long	2732020347
	.long	2675483945
	.long	397660275
	.long	3973303293
	.long	921299143
	.long	1493007550
	.long	1169073399
	.long	1056000594
	.long	795320551
	.long	3651639290
	.long	1842598287
	.long	2986015100
	.long	2338146798
	.long	2112001188
	.long	1590641102
	.long	3008311285
	.long	3685196575
	.long	1677062904
	.long	381326301
	.long	4224002377
	.long	3181282204
	.long	1721655274
	.long	3075425855
	.long	3354125809
	.long	762652602
	.long	4153037458
	.long	2067597113
	.long	3443310548
	.long	1855884414
	.long	2413284322
	.long	1525305205
	.long	4011107621
	.long	4135194227
	.long	2591653800
	.long	3711768829
	.long	531601349
	.long	3050610411
	.long	3727247947
	.long	3975421159
	.long	888340305
	.long	3128570363
	.long	1063202699
	.long	1806253526
	.long	3159528599
	.long	3655875023
	.long	1776680610
	.long	1962173430
	.long	2126405399
	.long	3612507052
	.long	2024089902
	.long	3016782751
	.long	3553361221
	.long	3924346860
	.long	4252810799
	.long	2930046808
	.long	4048179805
	.long	1738598206
	.long	2811755147
	.long	3553726425
	.long	4210654302
	.long	1565126321
	.long	3801392314
	.long	3477196413
	.long	1328542998
	.long	2812485555
	.long	4126341309
	.long	3130252643
	.long	3307817333
	.long	2659425531
	.long	2657085997
	.long	1330003814
	.long	3957715323
	.long	1965537991
	.long	2320667370
	.long	1023883767
	.long	1019204698
	.long	2660007629
	.long	3620463350
	.long	3931075983
	.long	346367444
	.long	2047767535
	.long	2038409397
	.long	1025047962
	.long	2945959404
	.long	3567184671
	.long	692734889
	.long	4095535070
	.long	4076818795
	.long	2050095924
	.long	1596951513
	.long	2839402047
	.long	1385469779
	.long	3896102844
	.long	3858670295
	.long	4100191849
	.long	3193903027
	.long	1383836798
	.long	2770939558
	.long	3497238392
	.long	3422373294
	.long	3905416403
	.long	2092838759
	.long	2767673597
	.long	1246911821
	.long	2699509489
	.long	2549779293
	.long	3515865511
	.long	4185677519
	.long	1240379898
	.long	2493823642
	.long	1104051682
	.long	804591290
	.long	2736763727
	.long	4076387742
	.long	2480759797
	.long	692679989
	.long	2208103365
	.long	1609182581
	.long	1178560158
	.long	3857808189
	.long	666552299
	.long	1385359979
	.long	121239434
	.long	3218365162
	.long	2357120316
	.long	3420649082
	.long	1333104599
	.long	2770719959
	.long	242478868
	.long	2141763028
	.long	419273337
	.long	2546330868
	.long	2666209199
	.long	1246472623
	.long	484957737
	.long	4283526057
	.long	838546674
	.long	797694440
	.long	1037451103
	.long	2492945247
	.long	969915474
	.long	4272084818
	.long	1677093349
	.long	1595388880
	.long	2074902206
	.long	690923199
	.long	1939830949
	.long	4249202340
	.long	3354186699
	.long	3190777760
	.long	4149804412
	.long	1381846399
	.long	3879661898
	.long	4203437385
	.long	2413406103
	.long	2086588225
	.long	4004641529
	.long	2763692798
	.long	3464356500
	.long	4111907475
	.long	531844911
	.long	4173176451
	.long	3714315762
	.long	1232418301
	.long	2633745705
	.long	3928847655
	.long	1063689823
	.long	4051385607
	.long	3133664229
	.long	2464836603
	.long	972524114
	.long	3562728015
	.long	2127379647
	.long	3807803918
	.long	1972361163
	.long	634705910
	.long	1945048229
	.long	2830488734
	.long	4254759295
	.long	3320640540
	.long	3944722327
	.long	1269411821
	.long	3890096458
	.long	1366010173
	.long	4214551295
	.long	2346313785
	.long	3594477359
	.long	2538823642
	.long	3485225620
	.long	2732020347
	.long	4134135294
	.long	397660275
	.long	2893987423
	.long	782679989
	.long	2675483945
	.long	1169073399
	.long	3973303293
	.long	795320551
	.long	1493007550
	.long	1565359979
	.long	1056000594
	.long	2338146798
	.long	3651639290
	.long	1590641102
	.long	2986015100
	.long	3130719959
	.long	2112001188
	.long	381326301
	.long	3008311285
	.long	3181282204
	.long	1677062904
	.long	1966472623
	.long	4224002377
	.long	762652602
	.long	1721655274
	.long	2067597113
	.long	3354125809
	.long	3932945247
	.long	4153037458
	.long	1525305205
	.long	3443310548
	.long	4135194227
	.long	2413284322
	.long	3570923199
	.long	4011107621
	.long	3050610411
	.long	2591653800
	.long	3975421159
	.long	531601349
	.long	2846879102
	.long	3727247947
	.long	1806253526
	.long	888340305
	.long	3655875023
	.long	1063202699
	.long	1398790909
	.long	3159528599
	.long	3612507052
	.long	1776680610
	.long	3016782751
	.long	2126405399
	.long	2797581819
	.long	2024089902
	.long	2930046808
	.long	3553361221
	.long	1738598206
	.long	4252810799
	.long	1300196342
	.long	4048179805
	.long	1565126321
	.long	2811755147
	.long	3477196413
	.long	4210654302
	.long	2600392684
	.long	3801392314
	.long	3130252643
	.long	1328542998
	.long	2659425531
	.long	4126341309
	.long	905818072
	.long	3307817333
	.long	1965537991
	.long	2657085997
	.long	1023883767
	.long	3957715323
	.long	1811636145
	.long	2320667370
	.long	3931075983
	.long	1019204698
	.long	2047767535
	.long	3620463350
	.long	3623272290
	.long	346367444
	.long	3567184671
	.long	2038409397
	.long	4095535070
	.long	2945959404
	.long	2951577284
	.long	692734889
	.long	2839402047
	.long	4076818795
	.long	3896102844
	.long	1596951513
	.long	1608187272
	.long	1385469779
	.long	1383836798
	.long	3858670295
	.long	3497238392
	.long	3193903027
	.long	3216374545
	.long	2770939558
	.long	2767673597
	.long	3422373294
	.long	2699509489
	.long	2092838759
	.long	2137781795
	.long	1246911821
	.long	1240379898
	.long	2549779293
	.long	1104051682
	.long	4185677519
	.long	4275563591
	.long	2493823642
	.long	2480759797
	.long	804591290
	.long	2208103365
	.long	4076387742
	.long	4256159887
	.long	692679989
	.long	666552299
	.long	1609182581
	.long	121239434
	.long	3857808189
	.long	4217352479
	.long	1385359979
	.long	1333104599
	.long	3218365162
	.long	242478868
	.long	3420649082
	.long	4139737663
	.long	2770719959
	.long	2666209199
	.long	2141763028
	.long	484957737
	.long	2546330868
	.long	3984508030
	.long	1246472623
	.long	1037451103
	.long	4283526057
	.long	969915474
	.long	797694440
	.long	3674048764
	.long	2492945247
	.long	2074902206
	.long	4272084818
	.long	1939830949
	.long	1595388880
	.long	3053130232
	.long	690923199
	.long	4149804412
	.long	4249202340
	.long	3879661898
	.long	3190777760
	.long	1811293169
	.long	1381846399
	.long	4004641529
	.long	4203437385
	.long	3464356500
	.long	2086588225
	.long	3622586339
	.long	2763692798
	.long	3714315762
	.long	4111907475
	.long	2633745705
	.long	4173176451
	.long	2950205382
	.long	1232418301
	.long	3133664229
	.long	3928847655
	.long	972524114
	.long	4051385607
	.long	1605443469
	.long	2464836603
	.long	1972361163
	.long	3562728015
	.long	1945048229
	.long	3807803918
	.long	3210886938
	.long	634705910
	.long	3944722327
	.long	2830488734
	.long	3890096458
	.long	3320640540
	.long	2126806581
	.long	1269411821
	.long	3594477359
	.long	1366010173
	.long	3485225620
	.long	2346313785
	.long	4253613162
	.long	2538823642
	.long	2893987423
	.long	2732020347
	.long	2675483945
	.long	397660275
	.long	4212259029
	.long	782679989
	.long	1493007550
	.long	1169073399
	.long	1056000594
	.long	795320551
	.long	4129550763
	.long	1565359979
	.long	2986015100
	.long	2338146798
	.long	2112001188
	.long	1590641102
	.long	3964134231
	.long	3130719959
	.long	1677062904
	.long	381326301
	.long	4224002377
	.long	3181282204
	.long	3633301166
	.long	1966472623
	.long	3354125809
	.long	762652602
	.long	4153037458
	.long	2067597113
	.long	2971635037
	.long	3932945247
	.long	2413284322
	.long	1525305205
	.long	4011107621
	.long	4135194227
	.long	1648302778
	.long	3570923199
	.long	531601349
	.long	3050610411
	.long	3727247947
	.long	3975421159
	.long	3296605556
	.long	2846879102
	.long	1063202699
	.long	1806253526
	.long	3159528599
	.long	3655875023
	.long	2298243816
	.long	1398790909
	.long	2126405399
	.long	3612507052
	.long	2024089902
	.long	3016782751
	.long	301520336
	.long	2797581819
	.long	4252810799
	.long	2930046808
	.long	4048179805
	.long	1738598206
	.long	603040673
	.long	1300196342
	.long	4210654302
	.long	1565126321
	.long	3801392314
	.long	3477196413
	.long	1206081346
	.long	2600392684
	.long	4126341309
	.long	3130252643
	.long	3307817333
	.long	2659425531
	.long	2412162692
	.long	905818072
	.long	3957715323
	.long	1965537991
	.long	2320667370
	.long	1023883767
	.long	529358088
	.long	1811636145
	.long	3620463350
	.long	3931075983
	.long	346367444
	.long	2047767535
	.long	1058716176
	.long	3623272290
	.long	2945959404
	.long	3567184671
	.long	692734889
	.long	4095535070
	.long	2117432353
	.long	2951577284
	.long	1596951513
	.long	2839402047
	.long	1385469779
	.long	3896102844
	.long	4234864706
	.long	1608187272
	.long	3193903027
	.long	1383836798
	.long	2770939558
	.long	3497238392
	.long	4174762117
	.long	3216374545
	.long	2092838759
	.long	2767673597
	.long	1246911821
	.long	2699509489
	.long	4054556938
	.long	2137781795
	.long	4185677519
	.long	1240379898
	.long	2493823642
	.long	1104051682
	.long	3814146581
	.long	4275563591
	.long	4076387742
	.long	2480759797
	.long	692679989
	.long	2208103365
	.long	3333325867
	.long	4256159887
	.long	3857808189
	.long	666552299
	.long	1385359979
	.long	121239434
	.long	2371684438
	.long	4217352479
	.long	3420649082
	.long	1333104599
	.long	2770719959
	.long	242478868
	.long	448401580
	.long	4139737663
	.long	2546330868
	.long	2666209199
	.long	1246472623
	.long	484957737
	.long	896803160
	.long	3984508030
	.type	__svml_dsin_reduction_data_internal,@object
	.size	__svml_dsin_reduction_data_internal,49152
	.space 512, 0x00 	
	.align 8
.L_2il0floatpacket.26:
	.long	0xffffffff,0xffffffff
	.type	.L_2il0floatpacket.26,@object
	.size	.L_2il0floatpacket.26,8
	.align 8
.L_2il0floatpacket.27:
	.long	0x00000000,0x7ff00000
	.type	.L_2il0floatpacket.27,@object
	.size	.L_2il0floatpacket.27,8
	.align 8
.L_2il0floatpacket.28:
	.long	0xffffffff,0x000fffff
	.type	.L_2il0floatpacket.28,@object
	.size	.L_2il0floatpacket.28,8
	.align 8
.L_2il0floatpacket.29:
	.long	0x00000000,0x00100000
	.type	.L_2il0floatpacket.29,@object
	.size	.L_2il0floatpacket.29,8
	.align 8
.L_2il0floatpacket.30:
	.long	0xffffffff,0x00000000
	.type	.L_2il0floatpacket.30,@object
	.size	.L_2il0floatpacket.30,8
	.align 8
.L_2il0floatpacket.31:
	.long	0x00000000,0x80000000
	.type	.L_2il0floatpacket.31,@object
	.size	.L_2il0floatpacket.31,8
	.align 8
.L_2il0floatpacket.32:
	.long	0x00000000,0x3ff00000
	.type	.L_2il0floatpacket.32,@object
	.size	.L_2il0floatpacket.32,8
	.align 8
.L_2il0floatpacket.33:
	.long	0x00000000,0x42a80000
	.type	.L_2il0floatpacket.33,@object
	.size	.L_2il0floatpacket.33,8
	.align 8
.L_2il0floatpacket.34:
	.long	0x000001ff,0x00000000
	.type	.L_2il0floatpacket.34,@object
	.size	.L_2il0floatpacket.34,8
	.align 8
.L_2il0floatpacket.35:
	.long	0x00000000,0x39700000
	.type	.L_2il0floatpacket.35,@object
	.size	.L_2il0floatpacket.35,8
	.align 8
.L_2il0floatpacket.36:
	.long	0x00ffffff,0x00000000
	.type	.L_2il0floatpacket.36,@object
	.size	.L_2il0floatpacket.36,8
	.align 8
.L_2il0floatpacket.37:
	.long	0x00000000,0x3cb00000
	.type	.L_2il0floatpacket.37,@object
	.size	.L_2il0floatpacket.37,8
	.align 8
.L_2il0floatpacket.38:
	.long	0x00000fff,0x00000000
	.type	.L_2il0floatpacket.38,@object
	.size	.L_2il0floatpacket.38,8
	.align 8
.L_2il0floatpacket.39:
	.long	0x54442d18,0x401921fb
	.type	.L_2il0floatpacket.39,@object
	.size	.L_2il0floatpacket.39,8
	.align 8
.L_2il0floatpacket.40:
	.long	0x33145c07,0x3cb1a626
	.type	.L_2il0floatpacket.40,@object
	.size	.L_2il0floatpacket.40,8
	.align 8
.L_2il0floatpacket.41:
	.long	0xffffffff,0x7fffffff
	.type	.L_2il0floatpacket.41,@object
	.size	.L_2il0floatpacket.41,8
	.align 8
.L_2il0floatpacket.42:
	.long	0x00000000,0x3eb00000
	.type	.L_2il0floatpacket.42,@object
	.size	.L_2il0floatpacket.42,8
	.align 8
__dsin_la_CoutTab:
	.long	0
	.long	0
	.long	0
	.long	2146435072
	.type	__dsin_la_CoutTab,@object
	.size	__dsin_la_CoutTab,16

      .section        .note.GNU-stack,"",@progbits
